/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import javax.portlet.PortletException;
import org.springframework.util.StringUtils;

public class PortletRequestMethodNotSupportedException
extends PortletException {
    private String method;
    private String[] supportedMethods;

    public PortletRequestMethodNotSupportedException(String method) {
        this(method, null);
    }

    public PortletRequestMethodNotSupportedException(String method, String[] supportedMethods) {
        super("Request method '" + method + "' not supported by mapped handler");
        this.method = method;
        this.supportedMethods = supportedMethods;
    }

    public PortletRequestMethodNotSupportedException(String[] supportedMethods) {
        super("Mapped handler only supports client data requests with methods " + StringUtils.arrayToCommaDelimitedString((Object[])supportedMethods));
        this.supportedMethods = supportedMethods;
    }

    public String getMethod() {
        return this.method;
    }

    public String[] getSupportedMethods() {
        return this.supportedMethods;
    }
}

