/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.broker;

import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.SessionBrokerIdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionBroker
extends DatabaseSessionImpl {
    protected SessionBroker parent;
    protected Map<Class, String> sessionNamesByClass;
    protected Map<String, AbstractSession> sessionsByName = new HashMap<String, AbstractSession>();
    protected Sequencing sequencing;

    public SessionBroker() {
        super(new DatabaseLogin());
        this.sessionNamesByClass = new HashMap<Class, String>();
    }

    protected SessionBroker(Map sessionNames) {
        super(new DatabaseLogin());
        this.sessionNamesByClass = sessionNames;
    }

    public SessionBroker acquireClientSessionBroker() {
        this.log(2, "connection", "acquire_client_session_broker");
        SessionBroker clientBroker = this.copySessionBroker();
        clientBroker.parent = this;
        clientBroker.getIdentityMapAccessorInstance().setIdentityMapManager(this.getIdentityMapAccessorInstance().getIdentityMapManager());
        clientBroker.commitManager = this.getCommitManager();
        clientBroker.commandManager = this.getCommandManager();
        clientBroker.externalTransactionController = this.getExternalTransactionController();
        clientBroker.setServerPlatform(this.getServerPlatform());
        for (String sessionName : this.getSessionsByName().keySet()) {
            AbstractSession serverSession = this.getSessionForName(sessionName);
            if (serverSession instanceof ServerSession) {
                if (serverSession.getProject().hasIsolatedClasses()) {
                    throw ValidationException.isolatedDataNotSupportedInSessionBroker(sessionName);
                }
                clientBroker.internalRegisterSession(sessionName, ((ServerSession)serverSession).acquireClientSession());
                continue;
            }
            throw ValidationException.cannotAcquireClientSessionFromSession();
        }
        clientBroker.initializeSequencing();
        return clientBroker;
    }

    @Override
    public Session acquireHistoricalSession(AsOfClause clause) throws ValidationException {
        if (this.isServerSessionBroker()) {
            throw ValidationException.cannotAcquireHistoricalSession();
        }
        SessionBroker historicalBroker = this.copySessionBroker();
        for (String sessionName : this.getSessionsByName().keySet()) {
            AbstractSession session = this.getSessionForName(sessionName);
            historicalBroker.registerSession(sessionName, session.acquireHistoricalSession(clause));
        }
        return historicalBroker;
    }

    @Override
    public void releaseJTSConnection() {
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.releaseJTSConnection();
        }
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork() {
        if (this.isServerSessionBroker()) {
            return this.acquireClientSessionBroker().acquireUnitOfWork();
        }
        return super.acquireUnitOfWork();
    }

    @Override
    public void addDescriptor(ClassDescriptor descriptor) {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    public void addDescriptors(Vector descriptors) throws ValidationException {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    @Override
    public void addDescriptors(Project project) throws ValidationException {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    @Override
    protected void basicBeginTransaction() throws DatabaseException {
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.beginTransaction();
        }
    }

    @Override
    protected void basicCommitTransaction() throws DatabaseException {
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (session.isConnected()) continue;
            throw DatabaseException.databaseAccessorNotConnected();
        }
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.commitTransaction();
        }
    }

    @Override
    protected void basicRollbackTransaction() throws DatabaseException {
        DatabaseException globalException = null;
        for (AbstractSession session : this.getSessionsByName().values()) {
            try {
                session.rollbackTransaction();
            }
            catch (DatabaseException exception) {
                globalException = exception;
            }
        }
        if (globalException != null) {
            throw globalException;
        }
    }

    @Override
    public boolean containsQuery(String queryName) {
        boolean containsQuery = this.getQueries().containsKey(queryName);
        if (this.isClientSessionBroker() && !containsQuery) {
            String sessionName2 = null;
            AbstractSession ssession = null;
            for (String sessionName2 : this.getSessionsByName().keySet()) {
                ssession = this.getSessionForName(sessionName2);
                if (!(ssession instanceof ClientSession) || !((ClientSession)ssession).getParent().getBroker().containsQuery(queryName)) continue;
                return true;
            }
        }
        return containsQuery;
    }

    protected SessionBroker copySessionBroker() {
        SessionBroker broker = new SessionBroker(this.getSessionNamesByClass());
        broker.accessor = this.getAccessor();
        broker.name = this.getName();
        broker.sessionLog = this.getSessionLog();
        broker.project = this.project;
        if (this.hasEventManager()) {
            broker.eventManager = this.getEventManager().clone(broker);
        }
        broker.shouldPropagateChanges = this.shouldPropagateChanges;
        return broker;
    }

    @Override
    public Accessor getAccessor(Class domainClass) {
        if (domainClass == null) {
            throw QueryException.unnamedQueryOnSessionBroker(null);
        }
        return this.getSessionForClass(domainClass).getAccessor(domainClass);
    }

    @Override
    public Accessor getAccessor(String sessionName) {
        return this.getSessionForName(sessionName).getAccessor(sessionName);
    }

    @Override
    public AsOfClause getAsOfClause() {
        Iterator<AbstractSession> enumtr = this.getSessionsByName().values().iterator();
        if (enumtr.hasNext()) {
            return enumtr.next().getAsOfClause();
        }
        return null;
    }

    @Override
    public SessionBroker getParent() {
        return this.parent;
    }

    @Override
    public AbstractSession getParentIdentityMapSession(DatabaseQuery query, boolean canReturnSelf, boolean terminalOnly) {
        if (query == null) {
            return this;
        }
        return this.getSessionForQuery(query).getParentIdentityMapSession(query, canReturnSelf, terminalOnly);
    }

    @Override
    public AbstractSession getExecutionSession(DatabaseQuery query) {
        AbstractSession sessionByQuery = this.getSessionForQuery(query);
        return sessionByQuery.getExecutionSession(query);
    }

    @Override
    public Platform getPlatform(Class domainClass) {
        if (domainClass == null) {
            return super.getDatasourcePlatform();
        }
        return this.getSessionForClass(domainClass).getDatasourcePlatform();
    }

    @Override
    public DatabaseQuery getQuery(String name) {
        DatabaseQuery query = super.getQuery(name);
        if (this.isClientSessionBroker() && query == null) {
            String sessionName2 = null;
            AbstractSession ssession = null;
            for (String sessionName2 : this.getSessionsByName().keySet()) {
                ssession = this.getSessionForName(sessionName2);
                if (!(ssession instanceof ClientSession) || (query = ((ClientSession)ssession).getParent().getBroker().getQuery(name)) == null) continue;
                return query;
            }
        }
        return query;
    }

    @Override
    public DatabaseQuery getQuery(String name, Vector arguments) {
        DatabaseQuery query = super.getQuery(name, arguments);
        if (this.isClientSessionBroker() && query == null) {
            String sessionName2 = null;
            AbstractSession ssession = null;
            for (String sessionName2 : this.getSessionsByName().keySet()) {
                ssession = this.getSessionForName(sessionName2);
                if (!(ssession instanceof ClientSession) || (query = ((ClientSession)ssession).getParent().getBroker().getQuery(name, arguments)) == null) continue;
                return query;
            }
        }
        return query;
    }

    @Override
    public AbstractSession getSessionForClass(Class domainClass) throws ValidationException {
        if (domainClass == null) {
            return this;
        }
        String sessionName = this.getSessionNamesByClass().get(domainClass);
        if (sessionName == null) {
            throw ValidationException.noSessionRegisteredForClass(domainClass);
        }
        return this.getSessionsByName().get(sessionName);
    }

    public AbstractSession getSessionForName(String name) throws ValidationException {
        AbstractSession sessionByName = this.getSessionsByName().get(name);
        if (sessionByName == null) {
            throw ValidationException.noSessionRegisteredForName(name);
        }
        return sessionByName;
    }

    protected AbstractSession getSessionForQuery(DatabaseQuery query) {
        Class queryClass;
        if (query.hasSessionName()) {
            return this.getSessionForName(query.getSessionName());
        }
        if (query.getDescriptor() != null) {
            queryClass = query.getDescriptor().getJavaClass();
        } else {
            queryClass = query.getReferenceClass();
            if (queryClass == null) {
                throw QueryException.unnamedQueryOnSessionBroker(query);
            }
        }
        return this.getSessionForClass(queryClass);
    }

    protected Map<Class, String> getSessionNamesByClass() {
        return this.sessionNamesByClass;
    }

    public Map<String, AbstractSession> getSessionsByName() {
        return this.sessionsByName;
    }

    @Override
    public void initializeDescriptors() {
        if (!this.isClientSessionBroker()) {
            for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
                databaseSessionImpl.initializeSequencing();
            }
            if (this.hasExternalTransactionController()) {
                this.getExternalTransactionController().initializeSequencingListeners();
            }
        }
        super.initializeDescriptors();
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            if (databaseSessionImpl.getProject().hasGenericHistorySupport()) {
                this.getProject().setHasGenericHistorySupport(true);
            }
            if (databaseSessionImpl.getProject().hasIsolatedClasses()) {
                this.getProject().setHasIsolatedClasses(true);
            }
            if (databaseSessionImpl.getProject().hasNonIsolatedUOWClasses()) {
                this.getProject().setHasNonIsolatedUOWClasses(true);
            }
            this.getProject().getDefaultReadOnlyClasses().addAll(databaseSessionImpl.getProject().getDefaultReadOnlyClasses());
        }
        if (this.isServerSessionBroker()) {
            this.sequencing = null;
        }
    }

    @Override
    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new SessionBrokerIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    @Override
    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord row) throws DatabaseException, QueryException {
        AbstractSession sessionByQuery = this.getSessionForQuery(query);
        return sessionByQuery.internalExecuteQuery(query, row);
    }

    @Override
    public boolean isBroker() {
        return true;
    }

    public boolean isClientSessionBroker() {
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (!session.isClientSession()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        if (this.getSessionsByName() == null || this.getSessionsByName().isEmpty()) {
            return false;
        }
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (session.isConnected()) continue;
            return false;
        }
        return true;
    }

    public boolean isServerSessionBroker() {
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (!session.isServerSession()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSessionBroker() {
        return true;
    }

    @Override
    public void login() throws DatabaseException {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        if (this.eventManager != null) {
            this.eventManager.preLogin(this);
        }
        if (!this.isConnected()) {
            this.getServerPlatform().initializeExternalTransactionController();
        }
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            if (databaseSessionImpl.hasEventManager()) {
                databaseSessionImpl.getEventManager().preLogin(databaseSessionImpl);
            }
            if (databaseSessionImpl.isConnected()) continue;
            databaseSessionImpl.connect();
        }
        this.initializeDescriptors();
        if (this.getCommandManager() != null) {
            this.getCommandManager().initialize();
        }
        this.isLoggedIn = true;
    }

    @Override
    public void login(String userName, String password) throws DatabaseException {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        if (this.eventManager != null) {
            this.eventManager.preLogin(this);
        }
        if (!this.isConnected()) {
            this.getServerPlatform().initializeExternalTransactionController();
        }
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            if (databaseSessionImpl.hasEventManager()) {
                databaseSessionImpl.getEventManager().preLogin(databaseSessionImpl);
            }
            databaseSessionImpl.getDatasourceLogin().setUserName(userName);
            databaseSessionImpl.getDatasourceLogin().setPassword(password);
            if (databaseSessionImpl.isConnected()) continue;
            databaseSessionImpl.connect();
        }
        this.initializeDescriptors();
        this.isLoggedIn = true;
    }

    @Override
    public void logout() throws DatabaseException {
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            databaseSessionImpl.logout();
        }
        if (!this.isClientSessionBroker() && this.hasExternalTransactionController()) {
            this.getExternalTransactionController().clearSequencingListeners();
        }
        this.sequencing = null;
        this.isLoggedIn = false;
    }

    public void registerSession(String name, AbstractSession session) {
        session.setIsInBroker(true);
        this.getSessionsByName().put(name, session);
        session.setBroker(this);
        session.setName(name);
        Iterator descriptors = session.getDescriptors().values().iterator();
        Iterator classes = session.getDescriptors().keySet().iterator();
        while (descriptors.hasNext()) {
            ClassDescriptor descriptor = (ClassDescriptor)descriptors.next();
            Class descriptorClass = (Class)classes.next();
            this.getSessionNamesByClass().put(descriptorClass, name);
            this.getDescriptors().put(descriptorClass, descriptor);
        }
    }

    public void registerSession(String name, Session session) {
        this.registerSession(name, (AbstractSession)session);
    }

    public void internalRegisterSession(String name, AbstractSession session) {
        session.setIsInBroker(true);
        this.getSessionsByName().put(name, session);
        session.setBroker(this);
        session.setName(name);
    }

    @Override
    public void release() {
        if (this.isClientSessionBroker()) {
            this.log(2, "connection", "releasing_client_session_broker");
        }
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.release();
        }
        super.release();
    }

    @Override
    public void setIntegrityChecker(IntegrityChecker integrityChecker) {
        super.setIntegrityChecker(integrityChecker);
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.setIntegrityChecker(integrityChecker);
        }
    }

    @Override
    public void setSessionLog(SessionLog log) {
        super.setSessionLog(log);
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.setSessionLog(log);
        }
    }

    @Override
    public void setLog(Writer log) {
        super.setLog(log);
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.setLog(log);
        }
    }

    @Override
    public void setProfiler(SessionProfiler profiler) {
        super.setProfiler(profiler);
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.setProfiler(profiler);
        }
    }

    protected void setSessionNameByClass(HashMap sessionNameByClass) {
        this.sessionNamesByClass = sessionNameByClass;
    }

    public void setSessionsByName(Map sessionsByName) {
        this.sessionsByName = sessionsByName;
    }

    @Override
    public void setSynchronized(boolean synched) {
        if (!this.isServerSessionBroker()) {
            super.setSynchronized(synched);
            Iterator<AbstractSession> itSessions = this.getSessionsByName().values().iterator();
            while (itSessions.hasNext()) {
                itSessions.next().setSynchronized(synched);
            }
        }
    }

    @Override
    public void writesCompleted() {
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (session.isConnected()) continue;
            throw DatabaseException.databaseAccessorNotConnected();
        }
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.writesCompleted();
        }
    }

    @Override
    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }

    @Override
    protected SequencingHome getSequencingHome() {
        return null;
    }

    @Override
    public Sequencing getSequencing() {
        return this.sequencing;
    }

    public int howManySequencingCallbacks() {
        if (this.isClientSessionBroker()) {
            return this.getParent().howManySequencingCallbacks();
        }
        int nCallbacks = 0;
        Iterator<AbstractSession> itSessions = this.getSessionsByName().values().iterator();
        while (itSessions.hasNext()) {
            if (!((DatabaseSessionImpl)itSessions.next()).isSequencingCallbackRequired()) continue;
            ++nCallbacks;
        }
        return nCallbacks;
    }

    @Override
    public boolean isSequencingCallbackRequired() {
        return this.howManySequencingCallbacks() > 0;
    }
}

