/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.pape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.pape.PapeMessage;

public class PapeRequest
extends PapeMessage {
    private static Log _log = LogFactory.getLog(PapeRequest.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static final List PAPE_FIELDS = Arrays.asList("preferred_auth_policies", "preferred_auth_level_types", "max_auth_age");

    protected PapeRequest() {
        this.set("preferred_auth_policies", "");
        if (DEBUG) {
            _log.debug((Object)"Created empty Pape request.");
        }
    }

    public static PapeRequest createPapeRequest() {
        return new PapeRequest();
    }

    protected PapeRequest(ParameterList params) {
        super(params);
    }

    public static PapeRequest createPapeRequest(ParameterList params) throws MessageException {
        PapeRequest req = new PapeRequest(params);
        req.validate();
        if (DEBUG) {
            _log.debug((Object)("Created PAPE request from parameter list:\n" + params));
        }
        return req;
    }

    public String getPreferredAuthPolicies() {
        return this.getParameterValue("preferred_auth_policies");
    }

    public void setPreferredAuthPolicies(String policyUris) {
        this.set("preferred_auth_policies", policyUris);
    }

    public void addPreferredAuthPolicy(String policyUri) {
        String policies = this.getPreferredAuthPolicies();
        if (policies == null || policies.length() == 0) {
            this.setPreferredAuthPolicies(policyUri);
        } else {
            this.setPreferredAuthPolicies(policies + " " + policyUri);
        }
    }

    public List getPreferredAuthPoliciesList() {
        String policies = this.getParameterValue("preferred_auth_policies");
        if (policies != null) {
            return Arrays.asList(policies.split(" "));
        }
        return new ArrayList();
    }

    public void setMaxAuthAge(int seconds) {
        this.set("max_auth_age", Integer.toString(seconds));
    }

    public int getMaxAuthAge() {
        String maxAuthAge = this.getParameterValue("max_auth_age");
        if (maxAuthAge != null) {
            return Integer.parseInt(maxAuthAge);
        }
        return -1;
    }

    public void validate() throws MessageException {
        if (!this._parameters.hasParameter("preferred_auth_policies")) {
            throw new MessageException("preferred_auth_policies is required in a PAPE request.", 3120);
        }
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String paramName = ((Parameter)it.next()).getKey();
            if (PAPE_FIELDS.contains(paramName) || paramName.startsWith("auth_level.ns.")) continue;
            throw new MessageException("Invalid parameter name in PAPE request: " + paramName, 3120);
        }
    }

    public void addPreferredCustomAuthLevel(String authLevelTypeUri) {
        String alias = this.addAuthLevelExtension(authLevelTypeUri);
        String preferred = this.getParameterValue("preferred_auth_level_types");
        this.set("preferred_auth_level_types", preferred == null ? alias : preferred + " " + alias);
    }
}

