/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.AbstractVersionManager;
import org.apache.jackrabbit.core.version.InternalFrozenNodeImpl;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionItemImpl;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalVersionHistoryImpl
extends InternalVersionItemImpl
implements InternalVersionHistory {
    private static Logger log = LoggerFactory.getLogger((Class)InternalVersionHistory.class);
    private static final Calendar CURRENT_TIME = Calendar.getInstance();
    private HashMap labelCache = new HashMap();
    private InternalVersion rootVersion;
    private LinkedHashMap nameCache = new LinkedHashMap();
    private HashMap versionCache = new HashMap();
    private HashMap tempVersionCache = new HashMap();
    private NodeStateEx labelNode;
    private NodeId historyId;
    private NodeId versionableId;

    public InternalVersionHistoryImpl(AbstractVersionManager vMgr, NodeStateEx node) throws RepositoryException {
        super(vMgr, node);
        this.init();
    }

    private void init() throws RepositoryException {
        int i;
        this.nameCache.clear();
        this.versionCache.clear();
        this.labelCache.clear();
        this.historyId = this.node.getNodeId();
        this.versionableId = NodeId.valueOf(this.node.getPropertyValue(NameConstants.JCR_VERSIONABLEUUID).toString());
        this.labelNode = this.node.getNode(NameConstants.JCR_VERSIONLABELS, 1);
        try {
            PropertyState[] labels = this.labelNode.getProperties();
            for (i = 0; i < labels.length; ++i) {
                PropertyState pState = labels[i];
                if (pState.getType() != 9) continue;
                Name labelName = pState.getName();
                UUID ref = pState.getValues()[0].getUUID();
                NodeId id = new NodeId(ref);
                if (this.node.getState().hasChildNodeEntry(id)) {
                    this.labelCache.put(labelName, this.node.getState().getChildNodeEntry(id).getName());
                    continue;
                }
                log.warn("Error while resolving label reference. Version missing: " + ref);
            }
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
        this.rootVersion = this.createVersionInstance(NameConstants.JCR_ROOTVERSION);
        ChildNodeEntry[] children = (ChildNodeEntry[])this.node.getState().getChildNodeEntries().toArray();
        for (i = 0; i < children.length; ++i) {
            ChildNodeEntry child = children[i];
            if (child.getName().equals(NameConstants.JCR_VERSIONLABELS)) continue;
            this.nameCache.put(child.getName(), child.getId());
        }
        if (this.rootVersion.getSuccessors().length == 0) {
            Iterator iter = this.nameCache.keySet().iterator();
            while (iter.hasNext()) {
                Name versionName = (Name)iter.next();
                InternalVersionImpl v = this.createVersionInstance(versionName);
                v.legacyResolveSuccessors();
            }
        }
    }

    void reload() throws RepositoryException {
        this.tempVersionCache.putAll(this.versionCache);
        this.init();
        Iterator iter = this.tempVersionCache.values().iterator();
        while (iter.hasNext()) {
            InternalVersionImpl v = (InternalVersionImpl)iter.next();
            v.invalidate();
        }
        this.tempVersionCache.clear();
    }

    InternalVersionImpl createVersionInstance(Name name) {
        try {
            NodeStateEx nodeStateEx = this.node.getNode(name, 1);
            InternalVersionImpl v = this.createVersionInstance(nodeStateEx);
            this.versionCache.put(v.getId(), v);
            this.vMgr.versionCreated(v);
            Iterator iter = this.labelCache.keySet().iterator();
            while (iter.hasNext()) {
                Name labelName = (Name)iter.next();
                Name versionName = (Name)this.labelCache.get(labelName);
                if (!v.getName().equals(versionName)) continue;
                v.internalAddLabel(labelName);
            }
            return v;
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException("Failed to create version " + name + ".");
        }
    }

    InternalVersionImpl createVersionInstance(NodeStateEx child) {
        InternalVersionImpl v = (InternalVersionImpl)this.tempVersionCache.remove(child.getNodeId());
        if (v != null) {
            v.clear();
        } else {
            v = new InternalVersionImpl(this, child, child.getName());
        }
        return v;
    }

    public NodeId getId() {
        return this.historyId;
    }

    public InternalVersionItem getParent() {
        return null;
    }

    public InternalVersion getRootVersion() {
        return this.rootVersion;
    }

    public InternalVersion getVersion(Name versionName) throws VersionException {
        NodeId versionId = (NodeId)this.nameCache.get(versionName);
        if (versionId == null) {
            throw new VersionException("Version " + versionName + " does not exist.");
        }
        InternalVersion v = (InternalVersion)this.versionCache.get(versionId);
        if (v == null) {
            v = this.createVersionInstance(versionName);
        }
        return v;
    }

    public boolean hasVersion(Name versionName) {
        return this.nameCache.containsKey(versionName);
    }

    public InternalVersion getVersion(NodeId id) {
        InternalVersion v = (InternalVersion)this.versionCache.get(id);
        if (v == null) {
            Iterator iter = this.nameCache.keySet().iterator();
            while (iter.hasNext()) {
                Name versionName = (Name)iter.next();
                if (!this.nameCache.get(versionName).equals(id)) continue;
                v = this.createVersionInstance(versionName);
                break;
            }
        }
        return v;
    }

    public InternalVersion getVersionByLabel(Name label) {
        Name versionName = (Name)this.labelCache.get(label);
        if (versionName == null) {
            return null;
        }
        NodeId id = (NodeId)this.nameCache.get(versionName);
        InternalVersion v = (InternalVersion)this.versionCache.get(id);
        if (v == null) {
            v = this.createVersionInstance(versionName);
        }
        return v;
    }

    public Name[] getVersionNames() {
        return this.nameCache.keySet().toArray(new Name[this.nameCache.size()]);
    }

    public int getNumVersions() {
        return this.nameCache.size();
    }

    public UUID getVersionableUUID() {
        return this.versionableId.getUUID();
    }

    public Name[] getVersionLabels() {
        return this.labelCache.keySet().toArray(new Name[this.labelCache.size()]);
    }

    public NodeId getVersionLabelsId() {
        return this.labelNode.getNodeId();
    }

    void removeVersion(Name versionName) throws RepositoryException {
        InternalVersionImpl v = (InternalVersionImpl)this.getVersion(versionName);
        if (v.equals(this.rootVersion)) {
            String msg = "Removal of " + versionName + " not allowed.";
            log.debug(msg);
            throw new VersionException(msg);
        }
        if (this.vMgr.hasItemReferences(v.getId())) {
            throw new ReferentialIntegrityException("Unable to remove version. At least once referenced.");
        }
        Name[] labels = v.internalGetLabels();
        for (int i = 0; i < labels.length; ++i) {
            v.internalRemoveLabel(labels[i]);
            this.labelNode.removeProperty(labels[i]);
        }
        v.internalDetach();
        this.node.removeNode(v.getName());
        this.versionCache.remove(v.getId());
        this.nameCache.remove(versionName);
        this.vMgr.versionDestroyed(v);
        if (!this.vMgr.hasItemReferences(this.node.getNodeId())) {
            log.debug("Current version history has no references");
            NodeStateEx[] childNodes = this.node.getChildNodes();
            if (childNodes.length == 2) {
                log.debug("Removing orphan version history as it contains only two children");
                NodeStateEx parentNode = this.vMgr.getNodeStateEx(this.node.getParentId());
                parentNode.removeNode(this.node.getName());
                parentNode.store();
            }
        } else {
            log.debug("Current version history has at least one reference");
            this.node.store();
        }
        for (int i = 0; i < labels.length; ++i) {
            this.labelCache.remove(labels[i]);
        }
    }

    InternalVersion setVersionLabel(Name versionName, Name label, boolean move) throws VersionException {
        InternalVersion version;
        InternalVersion internalVersion = version = versionName != null ? this.getVersion(versionName) : null;
        if (versionName != null && version == null) {
            throw new VersionException("Version " + versionName + " does not exist in this version history.");
        }
        Name prevName = (Name)this.labelCache.get(label);
        InternalVersionImpl prev = null;
        if (prevName == null) {
            if (version == null) {
                return null;
            }
        } else {
            prev = (InternalVersionImpl)this.getVersion(prevName);
            if (prev.equals(version)) {
                return version;
            }
            if (!move) {
                throw new VersionException("Version label " + label + " already defined for version " + prev.getName());
            }
        }
        try {
            if (version == null) {
                this.labelNode.removeProperty(label);
            } else {
                this.labelNode.setPropertyValue(label, InternalValue.create(version.getId().getUUID()));
            }
            this.labelNode.store();
        }
        catch (RepositoryException e) {
            throw new VersionException((Throwable)e);
        }
        if (prev != null) {
            prev.internalRemoveLabel(label);
            this.labelCache.remove(label);
        }
        if (version != null) {
            this.labelCache.put(label, version.getName());
            ((InternalVersionImpl)version).internalAddLabel(label);
        }
        return prev;
    }

    InternalVersionImpl checkin(Name name, NodeImpl src, Calendar cal) throws RepositoryException {
        InternalValue[] predecessors;
        if (src.hasProperty(NameConstants.JCR_PREDECESSORS)) {
            Value[] preds = src.getProperty(NameConstants.JCR_PREDECESSORS).getValues();
            predecessors = new InternalValue[preds.length];
            for (int i = 0; i < preds.length; ++i) {
                UUID predId = UUID.fromString((String)preds[i].getString());
                if (!this.nameCache.containsValue(new NodeId(predId))) {
                    throw new RepositoryException("invalid predecessor in source node");
                }
                predecessors[i] = InternalValue.create(predId);
            }
        } else {
            Iterator iter = this.nameCache.values().iterator();
            NodeId last = null;
            while (iter.hasNext()) {
                last = (NodeId)iter.next();
            }
            if (last == null) {
                last = this.rootVersion.getId();
            }
            predecessors = new InternalValue[]{InternalValue.create(last.getUUID())};
        }
        NodeId versionId = new NodeId(UUID.randomUUID());
        NodeStateEx vNode = this.node.addNode(name, NameConstants.NT_VERSION, versionId, true);
        if (cal == null) {
            cal = InternalVersionHistoryImpl.getCurrentTime();
        }
        vNode.setPropertyValue(NameConstants.JCR_CREATED, InternalValue.create(cal));
        vNode.setPropertyValues(NameConstants.JCR_PREDECESSORS, 9, predecessors);
        vNode.setPropertyValues(NameConstants.JCR_SUCCESSORS, 9, InternalValue.EMPTY_ARRAY);
        InternalFrozenNodeImpl.checkin(vNode, NameConstants.JCR_FROZENNODE, src);
        InternalVersionImpl version = new InternalVersionImpl(this, vNode, name);
        version.internalAttach();
        this.node.store();
        this.vMgr.versionCreated(version);
        this.versionCache.put(version.getId(), version);
        this.nameCache.put(version.getName(), version.getId());
        return version;
    }

    static NodeStateEx create(AbstractVersionManager vMgr, NodeStateEx parent, Name name, NodeState nodeState) throws RepositoryException {
        NodeId historyId = new NodeId(UUID.randomUUID());
        NodeStateEx pNode = parent.addNode(name, NameConstants.NT_VERSIONHISTORY, historyId, true);
        String versionableUUID = nodeState.getNodeId().getUUID().toString();
        pNode.setPropertyValue(NameConstants.JCR_VERSIONABLEUUID, InternalValue.create(versionableUUID));
        pNode.addNode(NameConstants.JCR_VERSIONLABELS, NameConstants.NT_VERSIONLABELS, null, false);
        NodeId versionId = new NodeId(UUID.randomUUID());
        NodeStateEx vNode = pNode.addNode(NameConstants.JCR_ROOTVERSION, NameConstants.NT_VERSION, versionId, true);
        vNode.setPropertyValue(NameConstants.JCR_CREATED, InternalValue.create(InternalVersionHistoryImpl.getCurrentTime()));
        vNode.setPropertyValues(NameConstants.JCR_PREDECESSORS, 9, InternalValue.EMPTY_ARRAY);
        vNode.setPropertyValues(NameConstants.JCR_SUCCESSORS, 9, InternalValue.EMPTY_ARRAY);
        NodeStateEx node = vNode.addNode(NameConstants.JCR_FROZENNODE, NameConstants.NT_FROZENNODE, null, true);
        node.setPropertyValue(NameConstants.JCR_FROZENUUID, InternalValue.create(versionableUUID));
        node.setPropertyValue(NameConstants.JCR_FROZENPRIMARYTYPE, InternalValue.create(nodeState.getNodeTypeName()));
        Set mixins = nodeState.getMixinTypeNames();
        if (mixins.size() > 0) {
            InternalValue[] ivalues = new InternalValue[mixins.size()];
            Iterator iter = mixins.iterator();
            for (int i = 0; i < mixins.size(); ++i) {
                ivalues[i] = InternalValue.create((Name)iter.next());
            }
            node.setPropertyValues(NameConstants.JCR_FROZENMIXINTYPES, 7, ivalues);
        }
        parent.store();
        return pNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Calendar getCurrentTime() {
        long time = System.currentTimeMillis();
        Calendar calendar = CURRENT_TIME;
        synchronized (calendar) {
            if (time > CURRENT_TIME.getTimeInMillis()) {
                CURRENT_TIME.setTimeInMillis(time);
            } else {
                CURRENT_TIME.add(14, 1);
            }
            return (Calendar)CURRENT_TIME.clone();
        }
    }
}

