/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.directory.IndexInputStream;
import org.apache.jackrabbit.core.query.lucene.directory.IndexOutputStream;
import org.apache.lucene.store.Directory;

class IndexInfos {
    private int counter = 0;
    private boolean dirty = false;
    private List indexes = new ArrayList();
    private Set names = new HashSet();
    private final String name;

    IndexInfos(String fileName) {
        this.name = fileName;
    }

    boolean exists(Directory dir) throws IOException {
        return dir.fileExists(this.name);
    }

    String getFileName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(Directory dir) throws IOException {
        IndexInputStream in = new IndexInputStream(dir.openInput(this.name));
        try {
            DataInputStream di = new DataInputStream(in);
            this.counter = di.readInt();
            for (int i = di.readInt(); i > 0; --i) {
                String indexName = di.readUTF();
                this.indexes.add(indexName);
                this.names.add(indexName);
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Directory dir) throws IOException {
        if (!this.dirty) {
            return;
        }
        IndexOutputStream out = new IndexOutputStream(dir.createOutput(this.name + ".new"));
        try {
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(this.counter);
            dataOut.writeInt(this.indexes.size());
            for (int i = 0; i < this.indexes.size(); ++i) {
                dataOut.writeUTF(this.getName(i));
            }
        }
        finally {
            ((OutputStream)out).close();
        }
        if (dir.fileExists(this.name)) {
            dir.deleteFile(this.name);
        }
        dir.renameFile(this.name + ".new", this.name);
        this.dirty = false;
    }

    String getName(int i) {
        return (String)this.indexes.get(i);
    }

    int size() {
        return this.indexes.size();
    }

    void addName(String name) {
        if (this.names.contains(name)) {
            throw new IllegalArgumentException("already contains: " + name);
        }
        this.indexes.add(name);
        this.names.add(name);
        this.dirty = true;
    }

    void removeName(String name) {
        this.indexes.remove(name);
        this.names.remove(name);
        this.dirty = true;
    }

    void removeName(int i) {
        Object name = this.indexes.remove(i);
        this.names.remove(name);
        this.dirty = true;
    }

    boolean contains(String name) {
        return this.names.contains(name);
    }

    String newName() {
        this.dirty = true;
        return "_" + Integer.toString(this.counter++, 36);
    }
}

