/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server.jmx;

import java.io.ByteArrayInputStream;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.naming.InitialContext;
import org.apache.jackrabbit.rmi.remote.RemoteRepository;
import org.apache.jackrabbit.rmi.server.ServerAdapterFactory;
import org.apache.jackrabbit.rmi.server.jmx.JCRServerMBean;

public class JCRServer
implements JCRServerMBean {
    private String localAddress;
    private String remoteAddress;
    private String localEnvironment;
    private String remoteEnvironment;
    RemoteRepository remote;
    private Repository localRepository;

    public void start() throws Exception {
        if (this.localAddress == null) {
            throw new IllegalStateException("local repository address is null");
        }
        if (this.remoteAddress == null) {
            throw new IllegalStateException("remote repository address is null");
        }
        InitialContext localContext = this.createInitialContext(this.localEnvironment);
        this.localRepository = (Repository)localContext.lookup(this.localAddress);
        if (this.localRepository == null) {
            throw new IllegalArgumentException("local repository not found at " + this.localAddress);
        }
        InitialContext remoteContext = this.createInitialContext(this.remoteEnvironment);
        ServerAdapterFactory factory = new ServerAdapterFactory();
        this.remote = factory.getRemoteRepository(this.localRepository);
        remoteContext.bind(this.remoteAddress, (Object)this.remote);
    }

    private InitialContext createInitialContext(String jndiProps) throws Exception {
        InitialContext initialContext = null;
        if (jndiProps != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(jndiProps.getBytes());
            Properties props = new Properties();
            props.load(is);
            initialContext = new InitialContext(props);
        } else {
            initialContext = new InitialContext();
        }
        return initialContext;
    }

    public void stop() throws Exception {
        InitialContext ctx = new InitialContext();
        ctx.unbind(this.remoteAddress);
        this.remote = null;
    }

    public void createWorkspace(String username, String password, String name) throws RepositoryException {
        Session session = this.localRepository.login((Credentials)new SimpleCredentials(username, password.toCharArray()));
        try {
            session.getWorkspace().createWorkspace(name);
        }
        finally {
            session.logout();
        }
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String getLocalEnvironment() {
        return this.localEnvironment;
    }

    public void setLocalEnvironment(String localEnvironment) {
        this.localEnvironment = localEnvironment;
    }

    public String getRemoteEnvironment() {
        return this.remoteEnvironment;
    }

    public void setRemoteEnvironment(String remoteEnvironment) {
        this.remoteEnvironment = remoteEnvironment;
    }
}

