/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.utils;

public class ProgressiveTimeoutGenerator {
    private final float[] FractionsDef = new float[]{35.0f, 12.0f, 6.0f, 2.5f, 1.0f};
    private long timeout;
    private long elapsed;
    private float[] fractions = this.FractionsDef;
    private boolean init = false;
    private int currentIndex;

    public ProgressiveTimeoutGenerator(long timeout) {
        this.timeout = timeout;
        this.elapsed = 0L;
        this.currentIndex = 0;
        this.init = false;
    }

    public void setFractions(float[] fractions) throws Exception {
        if (this.init) {
            throw new Exception("Timeout fractions cannot be set after initialization");
        }
        for (float fraction : fractions) {
            if (!((double)fraction < 1.0)) continue;
            throw new Exception("Timeout fractions cannot be less than 1");
        }
        this.fractions = fractions;
    }

    public long next() {
        long remaining;
        if (!this.hasNext()) {
            return 0L;
        }
        this.init = true;
        long value = remaining = this.timeout - this.elapsed;
        if (this.currentIndex != this.fractions.length - 1) {
            value = (long)Math.ceil((float)remaining / this.fractions[this.currentIndex]);
        }
        ++this.currentIndex;
        this.elapsed += value;
        return value;
    }

    public boolean hasNext() {
        this.init = true;
        return this.currentIndex != this.fractions.length;
    }
}

