/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record.field;

import gr.uoa.di.madgik.commons.utils.ZipUtils;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileFieldDefinition;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileField
extends Field {
    private static final long serialVersionUID = 1L;
    private URI payload = null;
    private URI originalPayload = null;
    private long marshaledSize = 0L;
    private boolean marshaledCompleted = false;
    private boolean marshaledFile = false;
    private static Logger logger = Logger.getLogger(FileField.class.getName());
    private int chunkSize = 524288;

    public FileField() {
    }

    public FileField(File payload) {
        this.setPayload(payload);
    }

    public void setPayload(File payload) {
        URI uriPayload = null;
        if (payload != null) {
            uriPayload = payload.toURI();
        }
        this.payload = uriPayload;
        this.originalPayload = uriPayload;
    }

    public File getPayload() {
        return new File(this.payload);
    }

    public File getOriginalPayload() {
        if (this.originalPayload == null) {
            return null;
        }
        return new File(this.originalPayload);
    }

    @Override
    public FileFieldDefinition getFieldDefinition() throws GRS2RecordDefinitionException {
        if (!(super.getFieldDefinition() instanceof FileFieldDefinition)) {
            throw new GRS2RecordDefinitionException("Provided field definition is not of required type");
        }
        return (FileFieldDefinition)super.getFieldDefinition();
    }

    @Override
    public boolean isAvailable() {
        return this.marshaledCompleted || !this.isRemoteCopy();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.payload == null) {
            return null;
        }
        return new FileInputStream(new File(this.payload));
    }

    public void extendReadObject(ObjectInputStream in, IBuffer.TransportOverride override) throws IOException, ClassNotFoundException {
        this.setDefinitionIndex(in.readInt());
        this.setRemoteCopy(in.readBoolean());
        BufferedOutputStream bout = null;
        try {
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("Marshaling of field is already completed");
            }
            IBuffer.TransportDirective dir = null;
            dir = (IBuffer.TransportDirective)((Object)in.readObject());
            if (override == IBuffer.TransportOverride.Override) {
                dir = IBuffer.TransportDirective.Full;
            }
            boolean firstMarshal = false;
            if (!this.marshaledFile) {
                firstMarshal = true;
                int len = in.readInt();
                if (len < 0) {
                    this.originalPayload = null;
                } else {
                    byte[] pb = new byte[len];
                    in.readFully(pb);
                    this.originalPayload = new URI(new String(pb, "UTF-8"));
                }
                if (this.originalPayload != null) {
                    File tmp = File.createTempFile(UUID.randomUUID().toString(), null);
                    tmp.deleteOnExit();
                    this.payload = tmp.toURI();
                }
                this.marshaledFile = true;
            }
            boolean isCompressed = in.readBoolean();
            if (dir == IBuffer.TransportDirective.Full || dir == IBuffer.TransportDirective.Partial && !firstMarshal) {
                int size;
                bout = new BufferedOutputStream(new FileOutputStream(new File(this.payload), true));
                while ((size = in.readInt()) >= 0) {
                    byte[] b = new byte[size];
                    in.readFully(b);
                    if (isCompressed) {
                        byte[] bb = ZipUtils.UnzipBytes((byte[])b);
                        bout.write(bb);
                        continue;
                    }
                    bout.write(b);
                }
                bout.flush();
                bout.close();
                this.marshaledCompleted = in.readBoolean();
                if (dir == IBuffer.TransportDirective.Full && !this.marshaledCompleted) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Partial transfer detected although full was retrieved");
                }
            }
        }
        catch (Exception e) {
            throw new IOException("unable to unmarshal field", e);
        }
        finally {
            if (bout != null) {
                try {
                    bout.flush();
                }
                catch (Exception ex) {}
                try {
                    bout.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.setDefinitionIndex(in.readInt());
        this.setRemoteCopy(in.readBoolean());
        in.defaultReadObject();
        BufferedOutputStream bout = null;
        try {
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("Marshaling of field is already completed");
            }
            if (this.payload != null && this.originalPayload != null && this.payload.equals(this.originalPayload)) {
                this.payload = File.createTempFile(UUID.randomUUID().toString(), null).toURI();
            }
            boolean isCompressed = false;
            if (this.payload != null) {
                int size;
                File f = new File(this.payload);
                if (f.exists() && f.isDirectory()) {
                    throw new GRS2RecordSerializationException("File exists and is a directory");
                }
                if (f.exists() && !f.delete()) {
                    throw new GRS2RecordSerializationException("File exists and could not be deleted");
                }
                bout = new BufferedOutputStream(new FileOutputStream(f));
                while ((size = in.readInt()) >= 0) {
                    byte[] b = new byte[size];
                    in.readFully(b);
                    if (isCompressed) {
                        byte[] bb = ZipUtils.UnzipBytes((byte[])b);
                        bout.write(bb);
                        continue;
                    }
                    bout.write(b);
                }
                bout.flush();
                bout.close();
            }
        }
        catch (Exception e) {
            throw new IOException("unable to unmarshal field", e);
        }
    }

    public void extendWriteObject(ObjectOutputStream out, IBuffer.TransportOverride override) throws IOException {
        out.writeInt(this.getDefinitionIndex());
        out.writeBoolean(this.isRemoteCopy());
        long start = System.currentTimeMillis();
        BufferedInputStream bin = null;
        try {
            IBuffer.TransportDirective dir = null;
            try {
                dir = this.resolveTransportDirective();
            }
            catch (Exception e) {
                dir = IBuffer.TransportDirective.Partial;
            }
            out.writeObject((Object)dir);
            if (override == IBuffer.TransportOverride.Override) {
                dir = IBuffer.TransportDirective.Full;
            }
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("More to marshal requested but full payload is already provided");
            }
            this.record.markActivity();
            boolean firstMarshal = false;
            if (!this.marshaledFile) {
                firstMarshal = true;
                this.marshaledSize = 0L;
                this.marshaledFile = true;
                if (this.originalPayload != null) {
                    byte[] pb = this.originalPayload.toString().getBytes(this.getFieldDefinition().getCharset());
                    out.writeInt(pb.length);
                    out.write(pb);
                    this.record.markActivity();
                }
            }
            if (dir == IBuffer.TransportDirective.Inherit) {
                throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
            }
            URI payloadFiUri = this.originalPayload;
            if (this.payload != null) {
                payloadFiUri = this.payload;
            }
            bin = new BufferedInputStream(new FileInputStream(new File(payloadFiUri)));
            for (long toSkip = this.marshaledSize; toSkip != 0L; toSkip -= bin.skip(toSkip)) {
            }
            out.writeBoolean(this.getFieldDefinition().isCompress());
            int chunkSize = this.chunkSize;
            if (dir == IBuffer.TransportDirective.Full) {
                int read;
                byte[] buf = new byte[chunkSize];
                while ((read = this.forwardBuffer(bin, out, buf)) >= 0) {
                    this.marshaledSize += (long)read;
                }
                out.writeInt(-1);
                this.marshaledCompleted = true;
                out.writeBoolean(this.marshaledCompleted);
            } else if (dir == IBuffer.TransportDirective.Partial && !firstMarshal) {
                boolean endOfFile = false;
                byte[] buf = new byte[chunkSize];
                int read = this.forwardBuffer(bin, out, buf);
                if (read < 0) {
                    endOfFile = true;
                }
                this.marshaledSize += (long)read;
                out.writeInt(-1);
                if (endOfFile) {
                    this.marshaledCompleted = true;
                }
                out.writeBoolean(this.marshaledCompleted);
            }
        }
        catch (Exception e) {
            throw new IOException("unable to marshal field", e);
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.getDefinitionIndex());
        out.writeBoolean(this.isRemoteCopy());
        long start = System.currentTimeMillis();
        out.defaultWriteObject();
        BufferedInputStream bin = null;
        Object fp = null;
        try {
            int read;
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("More to marshal requested but full payload is already provided");
            }
            URI payloadFiUri = this.originalPayload;
            if (this.payload != null) {
                payloadFiUri = this.payload;
            }
            bin = new BufferedInputStream(new FileInputStream(new File(payloadFiUri)));
            byte[] buf = new byte[this.chunkSize];
            while ((read = bin.read(buf)) >= 0) {
                if (this.getFieldDefinition().isCompress()) {
                    byte[] compressed = ZipUtils.ZipBytes((byte[])buf, (int)read);
                    out.writeInt(compressed.length);
                    out.write(compressed);
                    continue;
                }
                out.writeInt(read);
                out.write(buf, 0, read);
            }
            out.writeInt(-1);
            bin.close();
            this.record.markActivity();
        }
        catch (Exception e) {
            throw new IOException("unable to marshal field", e);
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    @Override
    public void extendSend(DataOutput out, IBuffer.TransportOverride override) throws GRS2RecordSerializationException {
        BufferedInputStream bin = null;
        try {
            IBuffer.TransportDirective dir = this.resolveTransportDirective();
            if (override == IBuffer.TransportOverride.Override) {
                dir = IBuffer.TransportDirective.Full;
            }
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("More to marshal requested but full payload is already provided");
            }
            this.record.markActivity();
            boolean firstMarshal = false;
            if (!this.marshaledFile) {
                firstMarshal = true;
                this.marshaledSize = 0L;
                this.marshaledFile = true;
                firstMarshal = true;
                if (this.originalPayload == null) {
                    out.writeInt(-1);
                } else {
                    byte[] pb = this.originalPayload.toString().getBytes(this.getFieldDefinition().getCharset());
                    out.writeInt(pb.length);
                    out.write(pb);
                    this.record.markActivity();
                }
            }
            if (dir == IBuffer.TransportDirective.Inherit) {
                throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
            }
            URI payloadFiUri = this.originalPayload;
            if (this.payload != null) {
                payloadFiUri = this.payload;
            }
            bin = new BufferedInputStream(new FileInputStream(new File(payloadFiUri)));
            for (long toSkip = this.marshaledSize; toSkip != 0L; toSkip -= bin.skip(toSkip)) {
            }
            int localBufferSize = this.getFieldDefinition().getLocalBuffer();
            int chunkSize = this.getFieldDefinition().getChunkSize();
            if (dir == IBuffer.TransportDirective.Full) {
                int read;
                byte[] buf = new byte[localBufferSize];
                while ((read = this.forwardBuffer(bin, out, buf)) >= 0) {
                    this.marshaledSize += (long)read;
                }
                out.writeInt(-1);
                this.marshaledCompleted = true;
                out.writeBoolean(this.marshaledCompleted);
            } else if (dir == IBuffer.TransportDirective.Partial && !firstMarshal) {
                int read;
                boolean endOfFile = false;
                for (int send = 0; send < chunkSize; send += read) {
                    byte[] buf = new byte[Math.min(chunkSize - send, localBufferSize)];
                    read = this.forwardBuffer(bin, out, buf);
                    if (read < 0) {
                        endOfFile = true;
                        break;
                    }
                    this.marshaledSize += (long)read;
                }
                out.writeInt(-1);
                if (endOfFile) {
                    this.marshaledCompleted = true;
                }
                out.writeBoolean(this.marshaledCompleted);
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to marshal field", e);
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private int forwardBuffer(BufferedInputStream bin, DataOutput out, byte[] buf) throws IOException, GRS2RecordDefinitionException, GRS2BufferException {
        int read = bin.read(buf);
        if (read < 0) {
            return -1;
        }
        this.record.markActivity();
        if (this.getFieldDefinition().isCompress()) {
            byte[] p = ZipUtils.ZipBytes((byte[])buf, (int)read);
            out.writeInt(p.length);
            out.write(p);
        } else {
            out.writeInt(read);
            out.write(buf, 0, read);
        }
        this.record.markActivity();
        return read;
    }

    @Override
    public void extendReceive(DataInput in, IBuffer.TransportOverride override) throws GRS2RecordSerializationException {
        BufferedOutputStream bout = null;
        try {
            int len;
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("Marshaling of field is already completed");
            }
            IBuffer.TransportDirective dir = this.resolveTransportDirective();
            if (override == IBuffer.TransportOverride.Override) {
                dir = IBuffer.TransportDirective.Full;
            }
            this.record.markActivity();
            boolean firstMarshal = false;
            if (!this.marshaledFile) {
                firstMarshal = true;
                len = in.readInt();
                if (len < 0) {
                    this.originalPayload = null;
                } else {
                    byte[] pb = new byte[len];
                    in.readFully(pb);
                    this.originalPayload = new URI(new String(pb, this.getFieldDefinition().getCharset()));
                }
                if (this.originalPayload != null) {
                    File tmp = File.createTempFile(UUID.randomUUID().toString(), null);
                    tmp.deleteOnExit();
                    this.payload = tmp.toURI();
                }
                this.marshaledFile = true;
            }
            if (dir == IBuffer.TransportDirective.Full || dir == IBuffer.TransportDirective.Partial && !firstMarshal) {
                bout = new BufferedOutputStream(new FileOutputStream(new File(this.payload), true));
                while ((len = in.readInt()) >= 0) {
                    byte[] bp = new byte[len];
                    in.readFully(bp);
                    this.record.markActivity();
                    if (this.getFieldDefinition().isCompress()) {
                        bp = ZipUtils.UnzipBytes((byte[])bp);
                    }
                    bout.write(bp);
                    this.record.markActivity();
                    this.marshaledSize += (long)bp.length;
                }
                bout.flush();
                bout.close();
                this.marshaledCompleted = in.readBoolean();
                if (dir == IBuffer.TransportDirective.Full && !this.marshaledCompleted) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Partial transfer detected although full was retrieved");
                }
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to unmarshal field", e);
        }
        finally {
            if (bout != null) {
                try {
                    bout.flush();
                }
                catch (Exception ex) {}
                try {
                    bout.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    @Override
    public void extendDispose() {
        if (this.payload != null && this.originalPayload != null && !this.payload.equals(this.originalPayload)) {
            new File(this.payload).delete();
        }
        try {
            if (this.getFieldDefinition().getDeleteOnDispose() && this.payload != null) {
                new File(this.payload).delete();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to delete local file", e);
        }
        this.payload = null;
        this.originalPayload = null;
    }

    @Override
    public void extendDeflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            byte[] b;
            out.writeUTF(this.getFieldDefinition().getCharset());
            out.writeBoolean(this.getFieldDefinition().isCompress());
            if (this.payload == null) {
                out.writeInt(-1);
            } else {
                b = this.payload.toString().getBytes(this.getFieldDefinition().getCharset());
                out.writeInt(b.length);
                out.write(b);
            }
            if (this.originalPayload == null) {
                out.writeInt(-1);
            } else {
                b = this.originalPayload.toString().getBytes(this.getFieldDefinition().getCharset());
                out.writeInt(b.length);
                out.write(b);
            }
            out.writeLong(this.marshaledSize);
            out.writeBoolean(this.marshaledCompleted);
            out.writeBoolean(this.marshaledFile);
            if (this.payload != null) {
                int read;
                BufferedInputStream bin = new BufferedInputStream(this.getMediatingInputStream());
                byte[] b2 = new byte[this.getFieldDefinition().getLocalBuffer()];
                while ((read = bin.read(b2)) >= 0) {
                    if (this.getFieldDefinition().isCompress()) {
                        byte[] bb = ZipUtils.ZipBytes((byte[])b2, (int)read);
                        out.writeInt(bb.length);
                        out.write(bb);
                        continue;
                    }
                    out.writeInt(read);
                    out.write(b2, 0, read);
                }
                out.writeInt(-1);
                bin.close();
            }
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("unable to deflate field", ex);
        }
    }

    @Override
    public void extendToXML(Document doc, Element element) throws GRS2RecordSerializationException {
        BufferedInputStream bin = null;
        try {
            Element elm = null;
            elm = doc.createElement("charset");
            elm.setTextContent(String.valueOf(this.getFieldDefinition().getCharset()));
            element.appendChild(elm);
            elm = doc.createElement("isCompressed");
            elm.setTextContent(String.valueOf(this.getFieldDefinition().isCompress()));
            element.appendChild(elm);
            if (this.payload != null) {
                elm = doc.createElement("payload");
                elm.setTextContent(this.payload.toString());
                element.appendChild(elm);
            }
            if (this.originalPayload != null) {
                elm = doc.createElement("originalPayload");
                elm.setTextContent(this.originalPayload.toString());
                element.appendChild(elm);
            }
            elm = doc.createElement("marshaledSize");
            elm.setTextContent(String.valueOf(this.marshaledSize));
            element.appendChild(elm);
            elm = doc.createElement("marshaledCompleted");
            elm.setTextContent(String.valueOf(this.marshaledCompleted));
            element.appendChild(elm);
            elm = doc.createElement("marshaledFile");
            elm.setTextContent(String.valueOf(this.marshaledFile));
            element.appendChild(elm);
            if (this.payload != null) {
                int read;
                StringBuffer strBuf = new StringBuffer();
                bin = new BufferedInputStream(this.getMediatingInputStream());
                byte[] b = new byte[this.getFieldDefinition().getLocalBuffer()];
                while ((read = bin.read(b)) >= 0) {
                    if (this.getFieldDefinition().isCompress()) {
                        byte[] bb = ZipUtils.ZipBytes((byte[])b, (int)read);
                        strBuf.append(DatatypeConverter.printBase64Binary((byte[])bb));
                        continue;
                    }
                    byte[] bbb = Arrays.copyOf(b, read);
                    strBuf.append(DatatypeConverter.printBase64Binary((byte[])bbb));
                }
                elm = doc.createElement("payloadData");
                elm.setTextContent(strBuf.toString());
                element.appendChild(elm);
            }
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("unable to deflate field", ex);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void extendFromXML(Element element, boolean reset) throws GRS2RecordSerializationException {
        try {
            String charset = element.getElementsByTagName("charset").item(0).getTextContent();
            Boolean isCompressed = Boolean.parseBoolean(element.getElementsByTagName("isCompressed").item(0).getTextContent());
            String payload = element.getElementsByTagName("payload").item(0).getTextContent();
            try {
                this.payload = new URI(payload);
            }
            catch (URISyntaxException e) {
                throw new GRS2RecordSerializationException("unable to get record from xml", e);
            }
            String originalPayload = element.getElementsByTagName("originalPayload").item(0).getTextContent();
            try {
                this.originalPayload = new URI(originalPayload);
            }
            catch (URISyntaxException e) {
                throw new GRS2RecordSerializationException("unable to get record from xml", e);
            }
            if (this.payload != null && this.originalPayload != null && this.payload.equals(this.originalPayload)) {
                this.payload = File.createTempFile(UUID.randomUUID().toString(), null).toURI();
            }
            Long marshaledSize = Long.parseLong(element.getElementsByTagName("marshaledSize").item(0).getTextContent());
            this.marshaledSize = marshaledSize;
            Boolean marshaledCompleted = Boolean.parseBoolean(element.getElementsByTagName("marshaledCompleted").item(0).getTextContent());
            this.marshaledCompleted = marshaledCompleted;
            Boolean marshaledFile = Boolean.parseBoolean(element.getElementsByTagName("marshaledFile").item(0).getTextContent());
            this.marshaledFile = marshaledFile;
            if (reset) {
                this.marshaledSize = 0L;
                this.marshaledCompleted = false;
                this.marshaledFile = false;
            }
            if (this.payload != null) {
                File f = new File(this.payload);
                if (f.exists() && f.isDirectory()) {
                    throw new GRS2RecordSerializationException("File exists and is a directory");
                }
                if (f.exists() && !f.delete()) {
                    throw new GRS2RecordSerializationException("File exists and could not be deleted");
                }
                BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(f));
                String payloadData = element.getElementsByTagName("payloadData").item(0).getTextContent();
                byte[] decoded = DatatypeConverter.parseBase64Binary((String)payloadData);
                if (isCompressed.booleanValue()) {
                    byte[] bb = ZipUtils.UnzipBytes((byte[])decoded);
                    bout.write(bb);
                } else {
                    bout.write(decoded);
                }
                bout.flush();
                bout.close();
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to get record from xml", e);
        }
    }

    @Override
    public void extendInflate(DataInput in, boolean reset) throws GRS2RecordSerializationException {
        try {
            byte[] b;
            String charset = in.readUTF();
            boolean isCompressed = in.readBoolean();
            int len = in.readInt();
            if (len < 0) {
                this.payload = null;
            } else {
                b = new byte[len];
                in.readFully(b);
                this.payload = new URI(new String(b, charset));
            }
            len = in.readInt();
            if (len < 0) {
                this.originalPayload = null;
            } else {
                b = new byte[len];
                in.readFully(b);
                this.originalPayload = new URI(new String(b, charset));
            }
            if (this.payload != null && this.originalPayload != null && this.payload.equals(this.originalPayload)) {
                this.payload = File.createTempFile(UUID.randomUUID().toString(), null).toURI();
            }
            this.marshaledSize = in.readLong();
            this.marshaledCompleted = in.readBoolean();
            this.marshaledFile = in.readBoolean();
            if (reset) {
                this.marshaledSize = 0L;
                this.marshaledCompleted = false;
                this.marshaledFile = false;
            }
            if (this.payload != null) {
                int size;
                File f = new File(this.payload);
                if (f.exists() && f.isDirectory()) {
                    throw new GRS2RecordSerializationException("File exists and is a directory");
                }
                if (f.exists() && !f.delete()) {
                    throw new GRS2RecordSerializationException("File exists and could not be deleted");
                }
                BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(f));
                while ((size = in.readInt()) >= 0) {
                    byte[] b2 = new byte[size];
                    in.readFully(b2);
                    if (isCompressed) {
                        byte[] bb = ZipUtils.UnzipBytes((byte[])b2);
                        bout.write(bb);
                        continue;
                    }
                    bout.write(b2);
                }
                bout.flush();
                bout.close();
            }
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("unable to deflate field", ex);
        }
    }

    @Override
    protected void extendMakeLocal() {
        this.originalPayload = this.payload;
        this.marshaledSize = 0L;
        this.marshaledCompleted = false;
        this.marshaledFile = false;
    }

    @Override
    public void extendReceiveFromXML(Element element, IBuffer.TransportOverride override) throws GRS2RecordSerializationException {
        BufferedOutputStream bout = null;
        try {
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("Marshaling of field is already completed");
            }
            IBuffer.TransportDirective dir = this.resolveTransportDirective();
            if (override == IBuffer.TransportOverride.Override) {
                dir = IBuffer.TransportDirective.Full;
            }
            this.record.markActivity();
            boolean firstMarshal = false;
            if (!this.marshaledFile) {
                firstMarshal = true;
                this.originalPayload = new URI(element.getElementsByTagName("originalPayload").item(0).getTextContent());
                if (this.originalPayload != null) {
                    File tmp = File.createTempFile(UUID.randomUUID().toString(), null);
                    tmp.deleteOnExit();
                    this.payload = tmp.toURI();
                }
                this.marshaledFile = true;
            }
            if (dir == IBuffer.TransportDirective.Full || dir == IBuffer.TransportDirective.Partial && !firstMarshal) {
                bout = new BufferedOutputStream(new FileOutputStream(new File(this.payload), true));
                String payloadData = element.getElementsByTagName("payload").item(0).getTextContent();
                byte[] decoded = DatatypeConverter.parseBase64Binary((String)payloadData);
                Boolean isCompressed = Boolean.parseBoolean(element.getElementsByTagName("isCompressed").item(0).getTextContent());
                if (isCompressed.booleanValue()) {
                    byte[] bb = ZipUtils.UnzipBytes((byte[])decoded);
                    bout.write(bb);
                    this.marshaledSize += (long)bb.length;
                } else {
                    bout.write(decoded);
                    this.marshaledSize += (long)decoded.length;
                }
                this.record.markActivity();
                bout.flush();
                bout.close();
                this.marshaledCompleted = Boolean.parseBoolean(element.getElementsByTagName("marshaledCompleted").item(0).getTextContent());
                if (dir == IBuffer.TransportDirective.Full && !this.marshaledCompleted) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Partial transfer detected although full was retrieved");
                }
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to get record from xml", e);
        }
        finally {
            if (bout != null) {
                try {
                    bout.flush();
                }
                catch (Exception ex) {}
                try {
                    bout.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    @Override
    public void extendSendToXML(Document doc, Element element, IBuffer.TransportOverride override) throws GRS2RecordSerializationException {
        BufferedInputStream bin = null;
        try {
            IBuffer.TransportDirective dir = this.resolveTransportDirective();
            if (override == IBuffer.TransportOverride.Override) {
                dir = IBuffer.TransportDirective.Full;
            }
            if (this.marshaledCompleted) {
                throw new GRS2ProxyMirrorProtocolErrorException("More to marshal requested but full payload is already provided");
            }
            this.record.markActivity();
            Element elm = null;
            boolean firstMarshal = false;
            if (!this.marshaledFile) {
                firstMarshal = true;
                this.marshaledSize = 0L;
                this.marshaledFile = true;
                firstMarshal = true;
                if (this.originalPayload != null) {
                    elm = doc.createElement("originalPayload");
                    elm.setTextContent(this.originalPayload.toString());
                    element.appendChild(elm);
                    this.record.markActivity();
                }
            }
            URI payloadFiUri = this.originalPayload;
            if (this.payload != null) {
                payloadFiUri = this.payload;
            }
            bin = new BufferedInputStream(new FileInputStream(new File(payloadFiUri)));
            for (long toSkip = this.marshaledSize; toSkip != 0L; toSkip -= bin.skip(toSkip)) {
            }
            int localBufferSize = this.getFieldDefinition().getLocalBuffer();
            int chunkSize = this.getFieldDefinition().getChunkSize();
            if (dir == IBuffer.TransportDirective.Full) {
                int read;
                byte[] buf = new byte[localBufferSize];
                StringBuffer strBuf = new StringBuffer();
                while ((read = bin.read(buf)) >= 0) {
                    this.record.markActivity();
                    if (this.getFieldDefinition().isCompress()) {
                        byte[] bb = ZipUtils.ZipBytes((byte[])buf, (int)read);
                        strBuf.append(DatatypeConverter.printBase64Binary((byte[])bb));
                        continue;
                    }
                    byte[] bbb = Arrays.copyOf(buf, read);
                    strBuf.append(DatatypeConverter.printBase64Binary((byte[])bbb));
                }
                this.record.markActivity();
                this.marshaledSize += (long)strBuf.length();
                elm = doc.createElement("payload");
                elm.setTextContent(strBuf.toString());
                element.appendChild(elm);
                this.marshaledCompleted = true;
                elm = doc.createElement("marshaledCompleted");
                elm.setTextContent(String.valueOf(this.marshaledCompleted));
                element.appendChild(elm);
                elm = doc.createElement("isCompressed");
                elm.setTextContent(String.valueOf(this.getFieldDefinition().isCompress()));
                element.appendChild(elm);
            } else if (dir == IBuffer.TransportDirective.Partial && !firstMarshal) {
                int read;
                boolean endOfFile = false;
                StringBuffer strBuf = new StringBuffer();
                for (int send = 0; send < chunkSize; send += read) {
                    byte[] buf = new byte[Math.min(chunkSize - send, localBufferSize)];
                    read = bin.read(buf);
                    if (read < 0) {
                        endOfFile = true;
                        break;
                    }
                    this.record.markActivity();
                    if (this.getFieldDefinition().isCompress()) {
                        byte[] bb = ZipUtils.ZipBytes((byte[])buf, (int)read);
                        strBuf.append(DatatypeConverter.printBase64Binary((byte[])bb));
                    } else {
                        byte[] bbb = Arrays.copyOf(buf, read);
                        strBuf.append(DatatypeConverter.printBase64Binary((byte[])bbb));
                    }
                    if (read < 0) {
                        endOfFile = true;
                        break;
                    }
                    this.marshaledSize += (long)read;
                }
                this.marshaledCompleted = endOfFile;
                elm = doc.createElement("marshaledCompleted");
                elm.setTextContent(String.valueOf(this.marshaledCompleted));
                element.appendChild(elm);
                elm = doc.createElement("payload");
                elm.setTextContent(strBuf.toString());
                element.appendChild(elm);
                elm = doc.createElement("isCompressed");
                elm.setTextContent(String.valueOf(this.getFieldDefinition().isCompress()));
                element.appendChild(elm);
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to marshal field", e);
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Exception ex) {}
            }
        }
    }
}

