/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.tcp.mirror;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.compressedstream.CompressedObjectStream;
import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorDisposedException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.IMirror;
import gr.uoa.di.madgik.grs.proxy.mirror.PartialRequestEntry;
import gr.uoa.di.madgik.grs.proxy.mirror.PartialRequestManager;
import gr.uoa.di.madgik.grs.proxy.tcp.mirror.BufferConfig;
import gr.uoa.di.madgik.grs.proxy.tcp.mirror.PartialRequest;
import gr.uoa.di.madgik.grs.proxy.tcp.mirror.Request;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileField;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPReaderMirror
extends Thread
implements IMirror {
    private static Logger logger = Logger.getLogger(TCPReaderMirror.class.getName());
    public static final long LongMirrorPeriod = 100L;
    public static final long ShortMirrorPeriod = 50L;
    private String hostname = null;
    private int port = -1;
    private String key = null;
    private boolean overrideBufferCapacity = false;
    private int bufferCapacity = -1;
    private IMirror.MirroringState state = IMirror.MirroringState.Open;
    private Socket socket = null;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private IBuffer buffer = null;
    private GRS2ProxyMirrorProtocolErrorException initializationException = null;
    private final Object initializationLock = new Object();
    private boolean initializationCompleted = false;
    private long lastIterationRecords = 0L;
    private long lastIterationNeeded = 0L;
    private long lastPartialFields = 0L;
    private long lastAvailableRecords = 0L;
    private boolean consequentNoNeeds = false;
    private OutputStream outputStream;
    private InputStream inputStream;
    private PartialRequestManager manager = new PartialRequestManager();

    public void setInputStream(ObjectInputStream ois) {
        this.in = ois;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void overrideBufferCapacity(int capacity) {
        this.overrideBufferCapacity = true;
        this.bufferCapacity = capacity;
    }

    @Override
    public IBuffer getBuffer() {
        return this.buffer;
    }

    public void handle() throws GRS2ProxyMirrorInvalidOperationException {
        if (this.state != IMirror.MirroringState.Open) {
            throw new GRS2ProxyMirrorInvalidOperationException("Invalid mirroring state");
        }
        if (this.key == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("No key defined");
        }
        if (this.hostname == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("No hostname defined");
        }
        if (this.port <= 0) {
            throw new GRS2ProxyMirrorInvalidOperationException("No port defined");
        }
        this.setDaemon(true);
        this.setName("reader mirror (" + this.key + ")");
        this.start();
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean purge) {
        if (this.state == IMirror.MirroringState.Purged) {
            return;
        }
        this.state = purge ? IMirror.MirroringState.Purged : IMirror.MirroringState.Close;
        if (purge) {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.buffer != null) {
                    logger.log(Level.FINER, "Disposing buffer");
                    this.buffer.dispose();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.manager != null) {
                    this.manager.dispose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitInitialization() {
        Object object = this.initializationLock;
        synchronized (object) {
            while (!this.initializationCompleted) {
                try {
                    this.initializationLock.wait();
                }
                catch (Exception exception) {}
            }
            return this.initializationException == null;
            {
            }
        }
    }

    public GRS2ProxyMirrorProtocolErrorException getInitializationError() {
        return this.initializationException;
    }

    @Override
    public boolean pollPartial(long recordIndex, int fieldIndex) throws GRS2ProxyMirrorDisposedException {
        if (this.state != IMirror.MirroringState.Open) {
            return true;
        }
        if (this.manager == null) {
            return true;
        }
        return !this.manager.requestExists(recordIndex, fieldIndex);
    }

    @Override
    public long requestPartial(long recordIndex, int fieldIndex, IBuffer.TransportOverride override, Object notify) throws GRS2ProxyMirrorInvalidOperationException, GRS2ProxyMirrorDisposedException {
        if (this.state != IMirror.MirroringState.Open) {
            throw new GRS2ProxyMirrorInvalidOperationException("Mirroring is closing. No additional request accepted");
        }
        if (this.manager == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("Mirroring is closing. No additional request accepted");
        }
        this.manager.block(recordIndex, fieldIndex, override, notify);
        return 50L;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean readerRequests() throws Exception {
        boolean teardown = true;
        teardown = this.flushRequest();
        this.flushEvents();
        this.out.flush();
        return teardown;
    }

    private Integer retrieve() throws Exception {
        logger.log(Level.FINEST, "HTTPReaderMirror : retrievePartialRequests....");
        this.retrievePartialRequests();
        logger.log(Level.FINEST, "HTTPReaderMirror : retrievePartialRequests....OK");
        logger.log(Level.FINEST, "HTTPReaderMirror : retrieveRecords....");
        this.retrieveRecords();
        logger.log(Level.FINEST, "HTTPReaderMirror : retrieveRecords....OK");
        logger.log(Level.FINEST, "HTTPReaderMirror : retrieveEvents....");
        this.retrieveEvents();
        logger.log(Level.FINEST, "HTTPReaderMirror : retrieveEvents....OK");
        logger.log(Level.FINEST, "HTTPReaderMirror : retrieveStatus....");
        Integer isClosed = this.retrieveStatus();
        logger.log(Level.FINEST, "HTTPReaderMirror : retrieveStatus....OK");
        return isClosed;
    }

    private Integer retrieveStatus() throws Exception {
        Integer isClosed = this.in.readInt();
        return isClosed;
    }

    private void retrievePartialRequests() throws IOException, GRS2Exception, ClassNotFoundException {
        ArrayList partialRequests = (ArrayList)CompressedObjectStream.readObject(this.in);
        for (PartialRequest pr : partialRequests) {
            long recordIndex = pr.partRecordIndex;
            int fieldIndex = pr.fieldIndex;
            IBuffer.TransportOverride override = pr.override;
            Record rec = this.buffer.locate(recordIndex);
            if (rec == null) {
                throw new GRS2ProxyMirrorInvalidOperationException("Invalid record index provided");
            }
            Field[] fields = rec.getFields();
            if (fields == null) {
                throw new GRS2ProxyMirrorInvalidOperationException("No fields to update");
            }
            if (fieldIndex < 0 || fieldIndex >= fields.length) {
                throw new GRS2ProxyMirrorInvalidOperationException("Invalid field index provided");
            }
            Field f = fields[fieldIndex];
            FileField ff = (FileField)f;
            ff.extendReadObject(this.in, override);
            this.manager.unblock(recordIndex, fieldIndex);
        }
    }

    private void retrieveRecords() throws IOException, GRS2Exception, InstantiationException, IllegalAccessException, ClassNotFoundException {
        ArrayList records = (ArrayList)this.in.readObject();
        this.lastIterationRecords = 0L;
        for (Record rec : records) {
            rec.prebind(this.buffer);
            rec.setRemoteCopy(true);
            this.buffer.put(rec);
            ++this.lastIterationRecords;
        }
    }

    private void retrieveEvents() throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, GRS2RecordSerializationException, GRS2BufferException {
        ArrayList events = (ArrayList)CompressedObjectStream.readObject(this.in);
        for (BufferEvent event : events) {
            this.buffer.emit(event);
        }
    }

    private void flushEvents() throws IOException, GRS2BufferException, GRS2RecordSerializationException {
        BufferEvent event;
        ArrayList<BufferEvent> events = new ArrayList<BufferEvent>();
        while ((event = this.buffer.receive(BufferEvent.EventSource.Reader)) != null) {
            events.add(event);
        }
        CompressedObjectStream.writeObject(events, this.out);
    }

    private boolean flushRequest() throws IOException {
        boolean doDispose = false;
        int needed = 0;
        int availableRecords = -1;
        try {
            if (this.state != IMirror.MirroringState.Open || this.buffer.getStatus() == IBuffer.Status.Dispose) {
                doDispose = true;
            } else {
                availableRecords = this.buffer.availableRecords();
                needed = this.buffer.getCapacity() - availableRecords;
            }
        }
        catch (Exception ex) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Could not check for needed state flushing info. Setting to dispose", ex);
            }
            doDispose = true;
        }
        long consumed = this.lastAvailableRecords - (long)availableRecords;
        if (consumed < 0L) {
            consumed *= -1L;
        }
        this.lastAvailableRecords = availableRecords;
        if (this.lastAvailableRecords > 0L && needed > 0 && (int)consumed < needed) {
            needed = (int)consumed;
        }
        this.consequentNoNeeds = this.lastIterationNeeded == 0L && needed == 0;
        this.lastIterationNeeded = needed;
        boolean simulateActivity = this.buffer.getSimulateActivity();
        Request request = new Request();
        request.doDispose = doDispose;
        request.needed = needed;
        request.simulateActivity = simulateActivity;
        if (this.manager != null && !doDispose) {
            request.entries = new ArrayList<PartialRequestEntry>(Arrays.asList(this.manager.getEntries()));
        }
        CompressedObjectStream.writeObject(request, this.out);
        logger.log(Level.FINEST, "Flush request doDispose=" + doDispose + " mirroring state=" + (Object)((Object)this.state));
        return doDispose;
    }

    private void connectToWriter() throws UnknownHostException, IOException {
        this.socket = new Socket(this.hostname, this.port);
        this.outputStream = this.socket.getOutputStream();
        DataOutputStream dos = new DataOutputStream(this.outputStream);
        dos.writeUTF(ITCPConnectionManagerEntry.NamedEntry.gRS2.toString());
        this.out = new ObjectOutputStream(new BufferedOutputStream(this.outputStream));
        dos.flush();
        this.out.writeUTF(this.key);
        this.out.flush();
        this.inputStream = this.socket.getInputStream();
        this.in = new ObjectInputStream(new BufferedInputStream(this.inputStream));
    }

    private void initializeBuffer() throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, GRS2Exception {
        BufferConfig bufferConfig = (BufferConfig)CompressedObjectStream.readObject(this.in);
        this.buffer = (IBuffer)Class.forName(bufferConfig.bufferClassName).newInstance();
        if (this.overrideBufferCapacity && this.bufferCapacity < bufferConfig.capacity) {
            this.buffer.setCapacity(this.bufferCapacity);
        } else {
            this.buffer.setCapacity(bufferConfig.capacity);
        }
        this.buffer.setConcurrentPartialCapacity(bufferConfig.capacity);
        this.buffer.setInactivityTimeout(bufferConfig.inactivityTimeout);
        this.buffer.setInactivityTimeUnit(bufferConfig.inactivityTimeoutUnit);
        this.buffer.setTransportDirective(bufferConfig.transportDirective);
        RecordDefinition[] definitions = new RecordDefinition[bufferConfig.recordDefinitions.size()];
        int i = 0;
        Iterator<RecordDefinition> i$ = bufferConfig.recordDefinitions.iterator();
        while (i$.hasNext()) {
            RecordDefinition rd;
            definitions[i] = rd = i$.next();
            ++i;
        }
        this.buffer.setRecordDefinitions(definitions);
        this.buffer.initialize();
    }
}

