/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.contrib.poibrowser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.poi.hpsf.ClassID;

public class Codec {
    protected static final byte[] hexval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static String hexEncode(String s) {
        return Codec.hexEncode(s.getBytes());
    }

    public static String hexEncode(byte[] s) {
        return Codec.hexEncode(s, 0, s.length);
    }

    public static String hexEncode(byte[] s, int offset, int length) {
        StringBuffer b = new StringBuffer(length * 2);
        for (int i = offset; i < offset + length; ++i) {
            byte c = s[i];
            b.append((char)hexval[(c & 0xF0) >> 4]);
            b.append((char)hexval[(c & 0xF) >> 0]);
        }
        return b.toString();
    }

    public static String hexEncode(byte b) {
        StringBuffer sb = new StringBuffer(2);
        sb.append((char)hexval[(b & 0xF0) >> 4]);
        sb.append((char)hexval[(b & 0xF) >> 0]);
        return sb.toString();
    }

    public static String hexEncode(short s) {
        StringBuffer sb = new StringBuffer(4);
        sb.append((char)hexval[(s & 0xF000) >> 12]);
        sb.append((char)hexval[(s & 0xF00) >> 8]);
        sb.append((char)hexval[(s & 0xF0) >> 4]);
        sb.append((char)hexval[(s & 0xF) >> 0]);
        return sb.toString();
    }

    public static String hexEncode(int i) {
        StringBuffer sb = new StringBuffer(8);
        sb.append((char)hexval[(i & 0xF0000000) >> 28]);
        sb.append((char)hexval[(i & 0xF000000) >> 24]);
        sb.append((char)hexval[(i & 0xF00000) >> 20]);
        sb.append((char)hexval[(i & 0xF0000) >> 16]);
        sb.append((char)hexval[(i & 0xF000) >> 12]);
        sb.append((char)hexval[(i & 0xF00) >> 8]);
        sb.append((char)hexval[(i & 0xF0) >> 4]);
        sb.append((char)hexval[(i & 0xF) >> 0]);
        return sb.toString();
    }

    public static String hexEncode(long l) {
        StringBuffer sb = new StringBuffer(16);
        sb.append(Codec.hexEncode((int)(l & 0xFFFFFFFF00000000L) >> 32));
        sb.append(Codec.hexEncode((int)(l & 0xFFFFFFFFL) >> 0));
        return sb.toString();
    }

    public static String hexEncode(ClassID classID) {
        return Codec.hexEncode(classID.getBytes());
    }

    public static byte[] hexDecode(String s) {
        int length = s.length();
        if (length % 2 == 1) {
            throw new IllegalArgumentException("String has odd length " + length);
        }
        byte[] b = new byte[length / 2];
        char[] c = new char[length];
        s.toUpperCase().getChars(0, length, c, 0);
        for (int i = 0; i < length; i += 2) {
            b[i / 2] = (byte)(Codec.decodeNibble(c[i]) << 4 & 0xF0 | Codec.decodeNibble(c[i + 1]) & 0xF);
        }
        return b;
    }

    protected static byte decodeNibble(char c) {
        for (byte i = 0; i < hexval.length; i = (byte)(i + 1)) {
            if ((byte)c != hexval[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("\"" + c + "\"" + " does not represent a nibble.");
    }

    public static void main(String[] args) throws IOException {
        String s;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        do {
            if ((s = in.readLine()) == null) continue;
            String bytes = Codec.hexEncode(s);
            System.out.print("Hex encoded (String): ");
            System.out.println(bytes);
            System.out.print("Hex encoded (byte[]): ");
            System.out.println(Codec.hexEncode(s.getBytes()));
            System.out.print("Re-decoded (byte[]):  ");
            System.out.println(new String(Codec.hexDecode(bytes)));
        } while (s != null);
    }
}

