/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.spi;

import de.schlichtherle.io.ChainableIOException;
import de.schlichtherle.io.File;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.OutputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.spi.RfsEntry;
import de.schlichtherle.io.archive.tar.TarEntry;
import de.schlichtherle.io.archive.zip.ZipEntry;
import de.schlichtherle.io.util.Temps;
import de.schlichtherle.util.JointEnumeration;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MultiplexedOutputArchive
implements OutputArchive {
    static final String TEMP_FILE_PREFIX = "tzp-mux";
    private final OutputArchive target;
    private final Map temps = new LinkedHashMap();
    private boolean targetBusy;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MultiplexedOutputArchive(OutputArchive target) {
        if (target == null) {
            throw new NullPointerException();
        }
        this.target = target;
    }

    public int getNumArchiveEntries() {
        return this.target.getNumArchiveEntries() + this.temps.size();
    }

    public Enumeration getArchiveEntries() {
        return new JointEnumeration(this.target.getArchiveEntries(), new TempEntriesEnumeration());
    }

    public ArchiveEntry getArchiveEntry(String entryName) {
        ArchiveEntry entry = this.target.getArchiveEntry(entryName);
        if (entry != null) {
            return entry;
        }
        TempEntryOutputStream tempOut = (TempEntryOutputStream)this.temps.get(entryName);
        return tempOut != null ? tempOut.entry : null;
    }

    public OutputStream getOutputStream(ArchiveEntry entry, ArchiveEntry srcEntry) throws IOException {
        if (srcEntry != null) {
            this.setSize(entry, srcEntry.getSize());
        }
        if (this.isTargetBusy()) {
            java.io.File temp = Temps.createTempFile(TEMP_FILE_PREFIX);
            return new TempEntryOutputStream(entry, srcEntry, temp);
        }
        return new EntryOutputStream(entry, srcEntry);
    }

    public boolean isTargetBusy() {
        return this.targetBusy;
    }

    private void setSize(ArchiveEntry entry, long size) {
        if (entry instanceof ZipEntry) {
            ((ZipEntry)entry).setSize(size);
        } else if (entry instanceof TarEntry) {
            ((TarEntry)entry).setSize(size);
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Unknown archive entry type: File.length() may return 0 while the temp file hasn't yet been saved to the output archive.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTempEntries() throws IOException {
        if (this.isTargetBusy()) {
            return;
        }
        ChainableIOException exception = null;
        Iterator i = this.temps.values().iterator();
        while (i.hasNext()) {
            TempEntryOutputStream tempOut = (TempEntryOutputStream)i.next();
            if (!tempOut.closed) continue;
            try {
                ArchiveEntry entry = tempOut.entry;
                ArchiveEntry srcEntry = tempOut.srcEntry;
                java.io.File temp = tempOut.temp;
                try {
                    FileInputStream in = new FileInputStream(temp);
                    try {
                        OutputStream out = this.target.getOutputStream(entry, srcEntry);
                        try {
                            File.cat(in, out);
                        }
                        finally {
                            out.close();
                        }
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                finally {
                    if (temp.delete()) continue;
                    temp.deleteOnExit();
                }
            }
            catch (FileNotFoundException ex) {
                exception = new ChainableIOException(exception, ex);
            }
            catch (InputIOException ex) {
                exception = new ChainableIOException(exception, ex);
            }
            catch (IOException ex) {
                throw new ChainableIOException(exception, ex);
            }
            finally {
                i.remove();
            }
        }
        if (exception != null) {
            throw exception.sortPriority();
        }
    }

    public final void storeDirectory(ArchiveEntry entry) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Since TrueZIP 6.5, this is not used anymore!");
        }
        if (!entry.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.getOutputStream(entry, null).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!$assertionsDisabled && this.isTargetBusy()) {
            throw new AssertionError();
        }
        try {
            this.storeTempEntries();
            if (!$assertionsDisabled && !this.temps.isEmpty()) {
                throw new AssertionError();
            }
        }
        finally {
            this.target.close();
        }
    }

    public OutputArchiveMetaData getMetaData() {
        return this.target.getMetaData();
    }

    public void setMetaData(OutputArchiveMetaData metaData) {
        this.target.setMetaData(metaData);
    }

    static {
        $assertionsDisabled = !MultiplexedOutputArchive.class.desiredAssertionStatus();
    }

    private class TempEntryOutputStream
    extends FileOutputStream {
        private final ArchiveEntry entry;
        private final ArchiveEntry srcEntry;
        private final java.io.File temp;
        private boolean closed;

        private TempEntryOutputStream(ArchiveEntry entry, ArchiveEntry srcEntry, java.io.File temp) throws IOException {
            super(temp);
            this.entry = entry;
            this.srcEntry = srcEntry != null ? srcEntry : new RfsEntry(temp);
            this.temp = temp;
            MultiplexedOutputArchive.this.temps.put(entry.getName(), this);
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            super.close();
            if (this.entry.getSize() == -1L) {
                MultiplexedOutputArchive.this.setSize(this.entry, this.temp.length());
            }
            if (this.entry.getTime() == -1L) {
                this.entry.setTime(this.temp.lastModified());
            }
            MultiplexedOutputArchive.this.storeTempEntries();
        }
    }

    private class EntryOutputStream
    extends FilterOutputStream {
        private boolean closed;

        private EntryOutputStream(ArchiveEntry entry, ArchiveEntry srcEntry) throws IOException {
            super(MultiplexedOutputArchive.this.target.getOutputStream(entry, srcEntry));
            MultiplexedOutputArchive.this.targetBusy = true;
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            MultiplexedOutputArchive.this.targetBusy = false;
            super.close();
            MultiplexedOutputArchive.this.storeTempEntries();
        }
    }

    private class TempEntriesEnumeration
    implements Enumeration {
        private final Iterator i;

        private TempEntriesEnumeration() {
            this.i = MultiplexedOutputArchive.this.temps.values().iterator();
        }

        public boolean hasMoreElements() {
            return this.i.hasNext();
        }

        public Object nextElement() {
            return ((TempEntryOutputStream)this.i.next()).entry;
        }
    }
}

