/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring.web.mvc;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.compass.spring.web.mvc.AbstractCompassGpsCommandController;
import org.compass.spring.web.mvc.CompassIndexCommand;
import org.compass.spring.web.mvc.CompassIndexResults;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;

public class CompassIndexController
extends AbstractCompassGpsCommandController {
    private String indexView;
    private String indexResultsView;
    private String indexResultsName = "indexResults";

    public CompassIndexController() {
        this.setCommandClass(CompassIndexCommand.class);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.indexView == null) {
            throw new IllegalArgumentException("Must set the indexView property");
        }
        if (this.indexResultsView == null) {
            throw new IllegalArgumentException("Must set the indexResultsView property");
        }
    }

    protected ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        CompassIndexCommand indexCommand = (CompassIndexCommand)command;
        if (!StringUtils.hasText((String)indexCommand.getDoIndex()) || !indexCommand.getDoIndex().equalsIgnoreCase("true")) {
            return new ModelAndView(this.getIndexView(), this.getCommandName(), (Object)indexCommand);
        }
        long time = System.currentTimeMillis();
        this.getCompassGps().index();
        time = System.currentTimeMillis() - time;
        CompassIndexResults indexResults = new CompassIndexResults(time);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(this.getCommandName(), indexCommand);
        data.put(this.getIndexResultsName(), indexResults);
        return new ModelAndView(this.getIndexResultsView(), data);
    }

    public String getIndexView() {
        return this.indexView;
    }

    public void setIndexView(String indexView) {
        this.indexView = indexView;
    }

    public String getIndexResultsName() {
        return this.indexResultsName;
    }

    public void setIndexResultsName(String indexResultsName) {
        this.indexResultsName = indexResultsName;
    }

    public String getIndexResultsView() {
        return this.indexResultsView;
    }

    public void setIndexResultsView(String indexResultsView) {
        this.indexResultsView = indexResultsView;
    }
}

