/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.analyzer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.analyzer.CoreAnalyzerBuilderDelegate;
import org.compass.core.lucene.engine.analyzer.ExtendedAnalyzerBuilderDelegate;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerFactory;
import org.compass.core.lucene.engine.analyzer.SnowballAnalyzerBuilderDelegate;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.StringUtils;

public class DefaultLuceneAnalyzerFactory
implements LuceneAnalyzerFactory {
    private static final Log log = LogFactory.getLog(DefaultLuceneAnalyzerFactory.class);
    private static final Set<String> extednedAnalyzers;
    private static final Set<String> coreAnalyzers;

    public Analyzer createAnalyzer(String analyzerName, CompassSettings settings) throws SearchEngineException {
        Analyzer analyzer;
        Object obj = settings.getSettingAsObject("type");
        if (obj instanceof Analyzer) {
            if (obj instanceof CompassConfigurable) {
                ((CompassConfigurable)obj).configure(settings);
            }
            return (Analyzer)obj;
        }
        String analyzerSetting = settings.getSetting("type", "standard");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Analyzer [" + analyzerName + "] uses Lucene analyzer [" + analyzerSetting + "]"));
        }
        if (coreAnalyzers.contains(analyzerSetting.toLowerCase())) {
            CoreAnalyzerBuilderDelegate analyzerBuilderDelegate = new CoreAnalyzerBuilderDelegate();
            analyzer = analyzerBuilderDelegate.buildAnalyzer(analyzerName, settings, this);
        } else if ("snowball".equalsIgnoreCase(analyzerSetting)) {
            SnowballAnalyzerBuilderDelegate analyzerBuilderDelegate = new SnowballAnalyzerBuilderDelegate();
            analyzer = analyzerBuilderDelegate.buildAnalyzer(analyzerName, settings, this);
        } else if (extednedAnalyzers.contains(analyzerSetting.toLowerCase())) {
            ExtendedAnalyzerBuilderDelegate analyzerBuilderDelegate = new ExtendedAnalyzerBuilderDelegate();
            analyzer = analyzerBuilderDelegate.buildAnalyzer(analyzerName, settings, this);
        } else {
            try {
                analyzer = (Analyzer)ClassUtils.forName(analyzerSetting, settings.getClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new SearchEngineException("Cannot instantiate Lucene Analyzer [" + analyzerSetting + "] for analyzer [" + analyzerName + "]. Please verify the analyzer setting at [" + "type" + "]", e);
            }
            if (analyzer instanceof CompassConfigurable) {
                ((CompassConfigurable)analyzer).configure(settings);
            }
        }
        return analyzer;
    }

    public String[] parseStopWords(String analyzerName, CompassSettings settings, String[] defaultStopWords) {
        String stopWords = settings.getSetting("stopwords");
        if (stopWords == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Anayzer [" + analyzerName + "] uses default stop words [" + StringUtils.arrayToCommaDelimitedString(defaultStopWords) + "]"));
            }
            return defaultStopWords;
        }
        boolean addStopWords = false;
        if (stopWords.startsWith("+")) {
            addStopWords = true;
            stopWords = stopWords.substring(1);
        }
        StringTokenizer st = new StringTokenizer(stopWords, ",");
        ArrayList<String> listStopWords = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String stopword = st.nextToken().trim();
            if (!StringUtils.hasLength(stopword)) continue;
            listStopWords.add(stopword);
        }
        Object[] arrStopWords = listStopWords.toArray(new String[listStopWords.size()]);
        if (addStopWords) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Analyzer [" + analyzerName + "] uses default stop words [" + StringUtils.arrayToCommaDelimitedString(defaultStopWords) + "]"));
                log.trace((Object)("Analyzer [" + analyzerName + "] and uses user stop words [" + StringUtils.arrayToCommaDelimitedString(arrStopWords) + "]"));
            }
            Object[] tempStopWords = arrStopWords;
            arrStopWords = new String[tempStopWords.length + defaultStopWords.length];
            System.arraycopy(defaultStopWords, 0, arrStopWords, 0, defaultStopWords.length);
            System.arraycopy(tempStopWords, 0, arrStopWords, defaultStopWords.length, tempStopWords.length);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Analyzer [" + analyzerName + "] uses user stop words [" + StringUtils.arrayToCommaDelimitedString(arrStopWords) + "]"));
        }
        return arrStopWords;
    }

    static {
        coreAnalyzers = new HashSet<String>();
        coreAnalyzers.add("whitespace");
        coreAnalyzers.add("standard");
        coreAnalyzers.add("simple");
        coreAnalyzers.add("stop");
        extednedAnalyzers = new HashSet<String>();
        extednedAnalyzers.add("brazilian");
        extednedAnalyzers.add("cjk");
        extednedAnalyzers.add("chinese");
        extednedAnalyzers.add("czech");
        extednedAnalyzers.add("german");
        extednedAnalyzers.add("greek");
        extednedAnalyzers.add("french");
        extednedAnalyzers.add("dutch");
        extednedAnalyzers.add("russian");
    }
}

