/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.model;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.ByteSerializer;
import com.netflix.astyanax.serializers.BytesArraySerializer;
import com.netflix.astyanax.serializers.DateSerializer;
import com.netflix.astyanax.serializers.DoubleSerializer;
import com.netflix.astyanax.serializers.FloatSerializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.ShortSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;

public class ThriftColumnImpl<C>
implements Column<C> {
    private final C name;
    private final org.apache.cassandra.thrift.Column column;

    public ThriftColumnImpl(C name, org.apache.cassandra.thrift.Column column) {
        this.name = name;
        this.column = column;
    }

    @Override
    public C getName() {
        return this.name;
    }

    @Override
    public <V> V getValue(Serializer<V> valSer) {
        return valSer.fromBytes(this.column.getValue());
    }

    @Override
    public String getStringValue() {
        return (String)StringSerializer.get().fromBytes(this.column.getValue());
    }

    @Override
    public byte getByteValue() {
        return (Byte)ByteSerializer.get().fromBytes(this.column.getValue());
    }

    @Override
    public short getShortValue() {
        return (Short)ShortSerializer.get().fromBytes(this.column.getValue());
    }

    @Override
    public int getIntegerValue() {
        return IntegerSerializer.get().fromBytes(this.column.getValue());
    }

    @Override
    public long getLongValue() {
        return (Long)LongSerializer.get().fromBytes(this.column.getValue());
    }

    @Override
    public <C2> ColumnList<C2> getSubColumns(Serializer<C2> ser) {
        throw new UnsupportedOperationException("SimpleColumn '" + this.name + "' has no children");
    }

    @Override
    public boolean isParentColumn() {
        return false;
    }

    @Override
    public byte[] getByteArrayValue() {
        return (byte[])BytesArraySerializer.get().fromBytes(this.column.getValue());
    }

    @Override
    public boolean getBooleanValue() {
        return (Boolean)BooleanSerializer.get().fromBytes(this.column.getValue());
    }

    @Override
    public ByteBuffer getByteBufferValue() {
        return (ByteBuffer)ByteBufferSerializer.get().fromBytes(this.column.getValue());
    }

    @Override
    public Date getDateValue() {
        return (Date)DateSerializer.get().fromBytes(this.column.getValue());
    }

    @Override
    public UUID getUUIDValue() {
        return (UUID)UUIDSerializer.get().fromBytes(this.column.getValue());
    }

    @Override
    public float getFloatValue() {
        return ((Float)FloatSerializer.get().fromBytes(this.column.getValue())).floatValue();
    }

    @Override
    public double getDoubleValue() {
        return (Double)DoubleSerializer.get().fromBytes(this.column.getValue());
    }

    @Override
    public long getTimestamp() {
        return this.column.getTimestamp();
    }

    @Override
    public ByteBuffer getRawName() {
        return ByteBuffer.wrap(this.column.getName());
    }

    @Override
    public int getTtl() {
        return this.column.isSetTtl() ? this.column.getTtl() : 0;
    }

    @Override
    public boolean hasValue() {
        return this.column.value != null && this.column.value.remaining() != 0;
    }
}

