/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.ColumnMutation;
import com.netflix.astyanax.Execution;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.KeyspaceTracerFactory;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.SerializerPackage;
import com.netflix.astyanax.WriteAheadEntry;
import com.netflix.astyanax.WriteAheadLog;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.OperationException;
import com.netflix.astyanax.connectionpool.impl.TokenRangeImpl;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.ddl.SchemaChangeResult;
import com.netflix.astyanax.ddl.impl.SchemaChangeResponseImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.query.ColumnFamilyQuery;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.retry.RunOnce;
import com.netflix.astyanax.serializers.SerializerPackageImpl;
import com.netflix.astyanax.serializers.UnknownComparatorException;
import com.netflix.astyanax.thrift.AbstractKeyspaceOperationImpl;
import com.netflix.astyanax.thrift.AbstractOperationImpl;
import com.netflix.astyanax.thrift.AbstractThriftColumnMutationImpl;
import com.netflix.astyanax.thrift.AbstractThriftMutationBatchImpl;
import com.netflix.astyanax.thrift.ThriftColumnFamilyQueryImpl;
import com.netflix.astyanax.thrift.ThriftConverter;
import com.netflix.astyanax.thrift.ddl.ThriftColumnFamilyDefinitionImpl;
import com.netflix.astyanax.thrift.ddl.ThriftKeyspaceDefinitionImpl;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.EndpointDetails;

public final class ThriftKeyspaceImpl
implements Keyspace {
    private final ConnectionPool<Cassandra.Client> connectionPool;
    private final AstyanaxConfiguration config;
    private final String ksName;
    private final ExecutorService executor;
    private final KeyspaceTracerFactory tracerFactory;
    private final Cache<String, Object> cache;

    public ThriftKeyspaceImpl(String ksName, ConnectionPool<Cassandra.Client> pool, AstyanaxConfiguration config, KeyspaceTracerFactory tracerFactory) {
        this.connectionPool = pool;
        this.config = config;
        this.ksName = ksName;
        this.executor = config.getAsyncExecutor();
        this.tracerFactory = tracerFactory;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    }

    @Override
    public String getKeyspaceName() {
        return this.ksName;
    }

    @Override
    public MutationBatch prepareMutationBatch() {
        return new AbstractThriftMutationBatchImpl(this.config.getClock(), this.config.getDefaultWriteConsistencyLevel(), this.config.getRetryPolicy().duplicate()){

            @Override
            public OperationResult<Void> execute() throws ConnectionException {
                WriteAheadLog wal = this.getWriteAheadLog();
                WriteAheadEntry walEntry = null;
                if (wal != null) {
                    walEntry = wal.createEntry();
                    walEntry.writeMutation(this);
                }
                try {
                    OperationResult result = ThriftKeyspaceImpl.this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(ThriftKeyspaceImpl.this.tracerFactory.newTracer(CassandraOperationType.BATCH_MUTATE), this.getPinnedHost(), ThriftKeyspaceImpl.this.getKeyspaceName()){

                        @Override
                        public Void internalExecute(Cassandra.Client client) throws Exception {
                            client.batch_mutate(this.getMutationMap(), ThriftConverter.ToThriftConsistencyLevel(this.getConsistencyLevel()));
                            this.discardMutations();
                            return null;
                        }

                        @Override
                        public ByteBuffer getRowKey() {
                            if (this.getMutationMap().size() == 1) {
                                return this.getMutationMap().keySet().iterator().next();
                            }
                            return null;
                        }
                    }, this.getRetryPolicy());
                    if (walEntry != null) {
                        wal.removeEntry(walEntry);
                    }
                    return result;
                }
                catch (ConnectionException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    throw ThriftConverter.ToConnectionPoolException(exception);
                }
            }

            @Override
            public Future<OperationResult<Void>> executeAsync() throws ConnectionException {
                return ThriftKeyspaceImpl.this.executor.submit(new Callable<OperationResult<Void>>(){

                    @Override
                    public OperationResult<Void> call() throws Exception {
                        return this.execute();
                    }
                });
            }
        };
    }

    @Override
    public List<TokenRange> describeRing() throws ConnectionException {
        return this.describeRing(null, null);
    }

    @Override
    public List<TokenRange> describeRing(String dc) throws ConnectionException {
        return this.describeRing(dc, null);
    }

    @Override
    public List<TokenRange> describeRing(final String dc, final String rack) throws ConnectionException {
        return this.executeOperation(new AbstractKeyspaceOperationImpl<List<TokenRange>>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_RING), this.getKeyspaceName()){

            @Override
            public List<TokenRange> internalExecute(Cassandra.Client client) throws Exception {
                List trs = client.describe_ring(ThriftKeyspaceImpl.this.getKeyspaceName());
                ArrayList range = Lists.newArrayList();
                for (org.apache.cassandra.thrift.TokenRange tr : trs) {
                    ArrayList endpoints = Lists.newArrayList();
                    for (EndpointDetails ed : tr.getEndpoint_details()) {
                        if (dc != null && !ed.getDatacenter().equals(dc) || rack != null && !ed.getRack().equals(dc)) continue;
                        endpoints.add(ed.getHost());
                    }
                    if (endpoints.isEmpty()) continue;
                    range.add(new TokenRangeImpl(tr.getStart_token(), tr.getEnd_token(), endpoints));
                }
                return range;
            }
        }, this.getConfig().getRetryPolicy().duplicate()).getResult();
    }

    @Override
    public List<TokenRange> describeRing(boolean cached) throws ConnectionException {
        if (cached) {
            try {
                return (List)this.cache.get((Object)CassandraOperationType.DESCRIBE_RING.name(), (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ThriftKeyspaceImpl.this.describeRing();
                    }
                });
            }
            catch (ExecutionException e) {
                throw ThriftConverter.ToConnectionPoolException(e);
            }
        }
        return this.describeRing();
    }

    @Override
    public KeyspaceDefinition describeKeyspace() throws ConnectionException {
        return this.executeOperation(new AbstractKeyspaceOperationImpl<KeyspaceDefinition>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_KEYSPACE), this.getKeyspaceName()){

            @Override
            public KeyspaceDefinition internalExecute(Cassandra.Client client) throws Exception {
                return new ThriftKeyspaceDefinitionImpl(client.describe_keyspace(ThriftKeyspaceImpl.this.getKeyspaceName()));
            }
        }, this.getConfig().getRetryPolicy().duplicate()).getResult();
    }

    @Override
    public <K, C> ColumnFamilyQuery<K, C> prepareQuery(ColumnFamily<K, C> cf) {
        return new ThriftColumnFamilyQueryImpl<K, C>(this.executor, this.tracerFactory, this, this.connectionPool, cf, this.config.getDefaultReadConsistencyLevel(), this.config.getRetryPolicy());
    }

    @Override
    public <K, C> ColumnMutation prepareColumnMutation(final ColumnFamily<K, C> columnFamily, final K rowKey, C column) {
        return new AbstractThriftColumnMutationImpl(columnFamily.getKeySerializer().toByteBuffer(rowKey), columnFamily.getColumnSerializer().toByteBuffer(column), this.config){

            @Override
            public Execution<Void> incrementCounterColumn(final long amount) {
                return new Execution<Void>(){

                    @Override
                    public OperationResult<Void> execute() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(ThriftKeyspaceImpl.this.tracerFactory.newTracer(CassandraOperationType.COUNTER_MUTATE), ThriftKeyspaceImpl.this.getKeyspaceName()){

                            @Override
                            public Void internalExecute(Cassandra.Client client) throws Exception {
                                client.add(key, ThriftConverter.getColumnParent(columnFamily, null), new CounterColumn().setValue(amount).setName(column), ThriftConverter.ToThriftConsistencyLevel(writeConsistencyLevel));
                                return null;
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return columnFamily.getKeySerializer().toByteBuffer(rowKey);
                            }
                        }, retry);
                    }

                    @Override
                    public Future<OperationResult<Void>> executeAsync() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executor.submit(new Callable<OperationResult<Void>>(){

                            @Override
                            public OperationResult<Void> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }

            @Override
            public Execution<Void> deleteColumn() {
                return new Execution<Void>(){

                    @Override
                    public OperationResult<Void> execute() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(ThriftKeyspaceImpl.this.tracerFactory.newTracer(CassandraOperationType.COLUMN_DELETE), ThriftKeyspaceImpl.this.getKeyspaceName()){

                            @Override
                            public Void internalExecute(Cassandra.Client client) throws Exception {
                                client.remove(key, new ColumnPath().setColumn_family(columnFamily.getName()).setColumn(column), ThriftKeyspaceImpl.this.config.getClock().getCurrentTime(), ThriftConverter.ToThriftConsistencyLevel(writeConsistencyLevel));
                                return null;
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return columnFamily.getKeySerializer().toByteBuffer(rowKey);
                            }
                        }, retry);
                    }

                    @Override
                    public Future<OperationResult<Void>> executeAsync() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executor.submit(new Callable<OperationResult<Void>>(){

                            @Override
                            public OperationResult<Void> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }

            @Override
            public Execution<Void> insertValue(final ByteBuffer value, final Integer ttl) {
                return new Execution<Void>(){

                    @Override
                    public OperationResult<Void> execute() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(ThriftKeyspaceImpl.this.tracerFactory.newTracer(CassandraOperationType.COLUMN_INSERT), ThriftKeyspaceImpl.this.getKeyspaceName()){

                            @Override
                            public Void internalExecute(Cassandra.Client client) throws Exception {
                                Column c = new Column();
                                c.setName(column).setValue(value).setTimestamp(clock.getCurrentTime());
                                if (ttl != null) {
                                    c.setTtl(ttl.intValue());
                                }
                                client.insert(key, ThriftConverter.getColumnParent(columnFamily, null), c, ThriftConverter.ToThriftConsistencyLevel(writeConsistencyLevel));
                                return null;
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return columnFamily.getKeySerializer().toByteBuffer(rowKey);
                            }
                        }, retry);
                    }

                    @Override
                    public Future<OperationResult<Void>> executeAsync() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executor.submit(new Callable<OperationResult<Void>>(){

                            @Override
                            public OperationResult<Void> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }

            @Override
            public Execution<Void> deleteCounterColumn() {
                return new Execution<Void>(){

                    @Override
                    public OperationResult<Void> execute() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(ThriftKeyspaceImpl.this.tracerFactory.newTracer(CassandraOperationType.COLUMN_DELETE), ThriftKeyspaceImpl.this.getKeyspaceName()){

                            @Override
                            public Void internalExecute(Cassandra.Client client) throws Exception {
                                client.remove_counter(key, new ColumnPath().setColumn_family(columnFamily.getName()).setColumn(column), ThriftConverter.ToThriftConsistencyLevel(writeConsistencyLevel));
                                return null;
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return columnFamily.getKeySerializer().toByteBuffer(rowKey);
                            }
                        }, retry);
                    }

                    @Override
                    public Future<OperationResult<Void>> executeAsync() throws ConnectionException {
                        return ThriftKeyspaceImpl.this.executor.submit(new Callable<OperationResult<Void>>(){

                            @Override
                            public OperationResult<Void> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }
        };
    }

    @Override
    public AstyanaxConfiguration getConfig() {
        return this.config;
    }

    @Override
    public SerializerPackage getSerializerPackage(String cfName, boolean ignoreErrors) throws ConnectionException, UnknownComparatorException {
        return new SerializerPackageImpl(this.describeKeyspace().getColumnFamily(cfName), ignoreErrors);
    }

    @Override
    public OperationResult<Void> testOperation(Operation<?, ?> operation) throws ConnectionException {
        return this.testOperation(operation, this.config.getRetryPolicy().duplicate());
    }

    @Override
    public OperationResult<Void> testOperation(final Operation<?, ?> operation, RetryPolicy retry) throws ConnectionException {
        return this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(this.tracerFactory.newTracer(CassandraOperationType.TEST), operation.getPinnedHost(), this.getKeyspaceName()){

            @Override
            public Void internalExecute(Cassandra.Client client) throws Exception {
                operation.execute(null);
                return null;
            }
        }, retry);
    }

    ConnectionPool<Cassandra.Client> getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public <K, C> OperationResult<Void> truncateColumnFamily(ColumnFamily<K, C> columnFamily) throws OperationException, ConnectionException {
        return this.truncateColumnFamily(columnFamily.getName());
    }

    @Override
    public OperationResult<Void> truncateColumnFamily(final String columnFamily) throws ConnectionException {
        return this.executeOperation(new AbstractKeyspaceOperationImpl<Void>(this.tracerFactory.newTracer(CassandraOperationType.TRUNCATE), this.getKeyspaceName()){

            @Override
            public Void internalExecute(Cassandra.Client client) throws Exception {
                client.truncate(columnFamily);
                return null;
            }
        }, this.config.getRetryPolicy().duplicate());
    }

    private <R> OperationResult<R> executeOperation(Operation<Cassandra.Client, R> operation, RetryPolicy retry) throws OperationException, ConnectionException {
        return this.connectionPool.executeWithFailover(operation, retry);
    }

    @Override
    public String describePartitioner() throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractOperationImpl<String>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_PARTITIONER)){

            @Override
            public String internalExecute(Cassandra.Client client) throws Exception {
                return client.describe_partitioner();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    @Override
    public <K, C> OperationResult<SchemaChangeResult> createColumnFamily(final Map<String, Object> options) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_COLUMN_FAMILY), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client) throws Exception {
                ThriftColumnFamilyDefinitionImpl def = new ThriftColumnFamilyDefinitionImpl();
                HashMap internalOptions = Maps.newHashMap();
                if (options != null) {
                    internalOptions.putAll(options);
                }
                internalOptions.put("keyspace", ThriftKeyspaceImpl.this.getKeyspaceName());
                def.setFields(internalOptions);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_add_column_family(def.getThriftColumnFamilyDefinition()));
            }
        }, RunOnce.get());
    }

    @Override
    public <K, C> OperationResult<SchemaChangeResult> createColumnFamily(final ColumnFamily<K, C> columnFamily, final Map<String, Object> options) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_COLUMN_FAMILY), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client) throws Exception {
                ThriftColumnFamilyDefinitionImpl def = new ThriftColumnFamilyDefinitionImpl();
                HashMap internalOptions = Maps.newHashMap();
                if (options != null) {
                    internalOptions.putAll(options);
                }
                internalOptions.put("name", columnFamily.getName());
                internalOptions.put("keyspace", ThriftKeyspaceImpl.this.getKeyspaceName());
                if (!internalOptions.containsKey("comparator_type")) {
                    internalOptions.put("comparator_type", columnFamily.getColumnSerializer().getComparatorType().getTypeName());
                }
                if (!internalOptions.containsKey("key_validation_class")) {
                    internalOptions.put("key_validation_class", columnFamily.getKeySerializer().getComparatorType().getTypeName());
                }
                if (columnFamily.getDefaultValueSerializer() != null && !internalOptions.containsKey("default_validation_class")) {
                    internalOptions.put("default_validation_class", columnFamily.getDefaultValueSerializer().getComparatorType().getTypeName());
                }
                def.setFields(internalOptions);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_add_column_family(def.getThriftColumnFamilyDefinition()));
            }
        }, RunOnce.get());
    }

    @Override
    public <K, C> OperationResult<SchemaChangeResult> updateColumnFamily(final ColumnFamily<K, C> columnFamily, final Map<String, Object> options) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.UPDATE_COLUMN_FAMILY), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client) throws Exception {
                ThriftColumnFamilyDefinitionImpl def = new ThriftColumnFamilyDefinitionImpl();
                HashMap internalOptions = Maps.newHashMap();
                if (options != null) {
                    internalOptions.putAll(options);
                }
                internalOptions.put("name", columnFamily.getName());
                internalOptions.put("keyspace", ThriftKeyspaceImpl.this.getKeyspaceName());
                if (!internalOptions.containsKey("key_validation_class")) {
                    internalOptions.put("key_validation_class", columnFamily.getKeySerializer().getComparatorType().getTypeName());
                }
                def.setFields(internalOptions);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_update_column_family(def.getThriftColumnFamilyDefinition()));
            }
        }, RunOnce.get());
    }

    @Override
    public OperationResult<SchemaChangeResult> dropColumnFamily(final String columnFamilyName) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.DROP_COLUMN_FAMILY), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client) throws Exception {
                return new SchemaChangeResponseImpl().setSchemaId(client.system_drop_column_family(columnFamilyName));
            }
        }, RunOnce.get());
    }

    @Override
    public <K, C> OperationResult<SchemaChangeResult> dropColumnFamily(final ColumnFamily<K, C> columnFamily) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.DROP_COLUMN_FAMILY), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client) throws Exception {
                return new SchemaChangeResponseImpl().setSchemaId(client.system_drop_column_family(columnFamily.getName()));
            }
        }, RunOnce.get());
    }

    @Override
    public OperationResult<SchemaChangeResult> createKeyspace(final Map<String, Object> options) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_KEYSPACE)){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client) throws Exception {
                ThriftKeyspaceDefinitionImpl def = new ThriftKeyspaceDefinitionImpl();
                HashMap internalOptions = Maps.newHashMap();
                if (options != null) {
                    internalOptions.putAll(options);
                }
                internalOptions.put("name", ThriftKeyspaceImpl.this.getKeyspaceName());
                def.setFields(internalOptions);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_add_keyspace(def.getThriftKeyspaceDefinition()));
            }
        }, RunOnce.get());
    }

    @Override
    public OperationResult<SchemaChangeResult> updateKeyspace(final Map<String, Object> options) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.UPDATE_KEYSPACE), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client) throws Exception {
                ThriftKeyspaceDefinitionImpl def = new ThriftKeyspaceDefinitionImpl();
                HashMap internalOptions = Maps.newHashMap();
                if (options != null) {
                    internalOptions.putAll(options);
                }
                internalOptions.put("name", ThriftKeyspaceImpl.this.getKeyspaceName());
                def.setFields(internalOptions);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_update_keyspace(def.getThriftKeyspaceDefinition()));
            }
        }, RunOnce.get());
    }

    @Override
    public OperationResult<SchemaChangeResult> dropKeyspace() throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.DROP_KEYSPACE), this.getKeyspaceName()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client) throws Exception {
                return new SchemaChangeResponseImpl().setSchemaId(client.system_drop_keyspace(ThriftKeyspaceImpl.this.getKeyspaceName()));
            }
        }, RunOnce.get());
    }
}

