/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.KeyspaceTracerFactory;
import com.netflix.astyanax.RowCallback;
import com.netflix.astyanax.RowCopier;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.impl.OperationResultImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.query.AllRowsQuery;
import com.netflix.astyanax.query.ColumnCountQuery;
import com.netflix.astyanax.query.ColumnFamilyQuery;
import com.netflix.astyanax.query.ColumnQuery;
import com.netflix.astyanax.query.CqlQuery;
import com.netflix.astyanax.query.IndexQuery;
import com.netflix.astyanax.query.RowQuery;
import com.netflix.astyanax.query.RowSliceColumnCountQuery;
import com.netflix.astyanax.query.RowSliceQuery;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.shallows.EmptyColumnList;
import com.netflix.astyanax.shallows.EmptyRowsImpl;
import com.netflix.astyanax.thrift.AbstractIndexQueryImpl;
import com.netflix.astyanax.thrift.AbstractKeyspaceOperationImpl;
import com.netflix.astyanax.thrift.AbstractRowQueryImpl;
import com.netflix.astyanax.thrift.AbstractRowSliceQueryImpl;
import com.netflix.astyanax.thrift.AbstractThriftAllRowsQueryImpl;
import com.netflix.astyanax.thrift.ThriftAllRowsImpl;
import com.netflix.astyanax.thrift.ThriftConverter;
import com.netflix.astyanax.thrift.model.ThriftColumnImpl;
import com.netflix.astyanax.thrift.model.ThriftColumnOrSuperColumnListImpl;
import com.netflix.astyanax.thrift.model.ThriftCounterColumnImpl;
import com.netflix.astyanax.thrift.model.ThriftCounterSuperColumnImpl;
import com.netflix.astyanax.thrift.model.ThriftCqlResultImpl;
import com.netflix.astyanax.thrift.model.ThriftCqlRowsImpl;
import com.netflix.astyanax.thrift.model.ThriftRowsListImpl;
import com.netflix.astyanax.thrift.model.ThriftRowsSliceImpl;
import com.netflix.astyanax.thrift.model.ThriftSuperColumnImpl;
import com.netflix.astyanax.util.TokenGenerator;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.dht.BigIntegerToken;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftColumnFamilyQueryImpl<K, C>
implements ColumnFamilyQuery<K, C> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftColumnFamilyQueryImpl.class);
    private final ConnectionPool<Cassandra.Client> connectionPool;
    private final ColumnFamily<K, C> columnFamily;
    private final KeyspaceTracerFactory tracerFactory;
    private final Keyspace keyspace;
    private ConsistencyLevel consistencyLevel;
    private final ExecutorService executor;
    private Host pinnedHost;
    private RetryPolicy retry;

    public ThriftColumnFamilyQueryImpl(ExecutorService executor, KeyspaceTracerFactory tracerFactory, Keyspace keyspace, ConnectionPool<Cassandra.Client> cp, ColumnFamily<K, C> columnFamily, ConsistencyLevel consistencyLevel, RetryPolicy retry) {
        this.keyspace = keyspace;
        this.connectionPool = cp;
        this.consistencyLevel = consistencyLevel;
        this.columnFamily = columnFamily;
        this.tracerFactory = tracerFactory;
        this.executor = executor;
        this.retry = retry;
    }

    @Override
    public RowQuery<K, C> getKey(final K rowKey) {
        return new AbstractRowQueryImpl<K, C>(this.columnFamily.getColumnSerializer()){
            private boolean firstPage;
            {
                super(x0);
                this.firstPage = true;
            }

            @Override
            public ColumnQuery<C> getColumn(final C column) {
                return new ColumnQuery<C>(){

                    @Override
                    public OperationResult<com.netflix.astyanax.model.Column<C>> execute() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<com.netflix.astyanax.model.Column<C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_COLUMN, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                            @Override
                            public com.netflix.astyanax.model.Column<C> internalExecute(Cassandra.Client client) throws Exception {
                                ColumnOrSuperColumn cosc = client.get(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey), new ColumnPath().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()).setColumn(ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer().toByteBuffer(column)), ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                                if (cosc.isSetColumn()) {
                                    Column c = cosc.getColumn();
                                    return new ThriftColumnImpl(ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer().fromBytes(c.getName()), c);
                                }
                                if (cosc.isSetSuper_column()) {
                                    SuperColumn sc = cosc.getSuper_column();
                                    return new ThriftSuperColumnImpl(ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer().fromBytes(sc.getName()), sc);
                                }
                                if (cosc.isSetCounter_column()) {
                                    CounterColumn c = cosc.getCounter_column();
                                    return new ThriftCounterColumnImpl(ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer().fromBytes(c.getName()), c);
                                }
                                if (cosc.isSetCounter_super_column()) {
                                    CounterSuperColumn sc = cosc.getCounter_super_column();
                                    return new ThriftCounterSuperColumnImpl(ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer().fromBytes(sc.getName()), sc);
                                }
                                throw new RuntimeException("Unknown column type in response");
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey);
                            }
                        }, ThriftColumnFamilyQueryImpl.this.retry);
                    }

                    @Override
                    public Future<OperationResult<com.netflix.astyanax.model.Column<C>>> executeAsync() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<com.netflix.astyanax.model.Column<C>>>(){

                            @Override
                            public OperationResult<com.netflix.astyanax.model.Column<C>> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }

            @Override
            public OperationResult<ColumnList<C>> execute() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<ColumnList<C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROW, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                    @Override
                    public ColumnList<C> execute(Cassandra.Client client) throws ConnectionException {
                        if (isPaginating && paginateNoMore) {
                            return new EmptyColumnList();
                        }
                        return (ColumnList)super.execute(client);
                    }

                    @Override
                    public ColumnList<C> internalExecute(Cassandra.Client client) throws Exception {
                        List columnList = client.get_slice(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                        if (isPaginating && predicate.isSetSlice_range()) {
                            ColumnOrSuperColumn last;
                            if (columnList.size() != predicate.getSlice_range().getCount()) {
                                paginateNoMore = true;
                            }
                            if (firstPage) {
                                firstPage = false;
                                if (predicate.getSlice_range().getCount() != Integer.MAX_VALUE) {
                                    predicate.getSlice_range().setCount(predicate.getSlice_range().getCount() + 1);
                                }
                            } else if (!columnList.isEmpty()) {
                                columnList.remove(0);
                            }
                            if (!columnList.isEmpty() && (last = (ColumnOrSuperColumn)Iterables.getLast((Iterable)columnList)).isSetColumn()) {
                                predicate.getSlice_range().setStart(last.getColumn().getName());
                            }
                        }
                        ThriftColumnOrSuperColumnListImpl result = new ThriftColumnOrSuperColumnListImpl(columnList, ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer());
                        return result;
                    }

                    @Override
                    public ByteBuffer getRowKey() {
                        return ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey);
                    }
                }, ThriftColumnFamilyQueryImpl.this.retry);
            }

            @Override
            public ColumnCountQuery getCount() {
                return new ColumnCountQuery(){

                    @Override
                    public OperationResult<Integer> execute() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<Integer>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_COLUMN_COUNT, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                            @Override
                            public Integer internalExecute(Cassandra.Client client) throws Exception {
                                return client.get_count(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey);
                            }
                        }, ThriftColumnFamilyQueryImpl.this.retry);
                    }

                    @Override
                    public Future<OperationResult<Integer>> executeAsync() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Integer>>(){

                            @Override
                            public OperationResult<Integer> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }

            @Override
            public Future<OperationResult<ColumnList<C>>> executeAsync() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<ColumnList<C>>>(){

                    @Override
                    public OperationResult<ColumnList<C>> call() throws Exception {
                        return this.execute();
                    }
                });
            }

            @Override
            public RowCopier<K, C> copyTo(final ColumnFamily<K, C> otherColumnFamily, final K otherRowKey) {
                return new RowCopier<K, C>(){
                    private boolean useOriginalTimestamp = true;

                    @Override
                    public OperationResult<Void> execute() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<Void>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.COPY_TO, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                            @Override
                            public Void internalExecute(Cassandra.Client client) throws Exception {
                                long currentTime = ThriftColumnFamilyQueryImpl.this.keyspace.getConfig().getClock().getCurrentTime();
                                List columnList = client.get_slice(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(rowKey), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                                ArrayList<Mutation> mutationList = new ArrayList<Mutation>();
                                for (ColumnOrSuperColumn sosc : columnList) {
                                    ColumnOrSuperColumn cosc;
                                    if (sosc.isSetColumn()) {
                                        cosc = new ColumnOrSuperColumn().setColumn(sosc.getColumn());
                                        if (!useOriginalTimestamp) {
                                            cosc.getColumn().setTimestamp(currentTime);
                                        }
                                    } else if (sosc.isSetSuper_column()) {
                                        cosc = new ColumnOrSuperColumn().setSuper_column(sosc.getSuper_column());
                                        if (!useOriginalTimestamp) {
                                            for (Column subColumn : sosc.getSuper_column().getColumns()) {
                                                subColumn.setTimestamp(currentTime);
                                                subColumn.setTimestamp(currentTime);
                                            }
                                        }
                                    } else if (sosc.isSetCounter_column()) {
                                        cosc = new ColumnOrSuperColumn().setCounter_column(sosc.getCounter_column());
                                    } else {
                                        if (!sosc.isSetCounter_super_column()) continue;
                                        cosc = new ColumnOrSuperColumn().setCounter_super_column(sosc.getCounter_super_column());
                                    }
                                    mutationList.add(new Mutation().setColumn_or_supercolumn(cosc));
                                }
                                HashMap mutationMap = new HashMap();
                                HashMap<String, ArrayList<Mutation>> cfmap = new HashMap<String, ArrayList<Mutation>>();
                                cfmap.put(otherColumnFamily.getName(), mutationList);
                                mutationMap.put(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(otherRowKey), cfmap);
                                client.batch_mutate(mutationMap, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                                return null;
                            }
                        }, ThriftColumnFamilyQueryImpl.this.retry);
                    }

                    @Override
                    public Future<OperationResult<Void>> executeAsync() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Void>>(){

                            @Override
                            public OperationResult<Void> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }

                    @Override
                    public RowCopier<K, C> withOriginalTimestamp(boolean useOriginalTimestamp) {
                        this.useOriginalTimestamp = useOriginalTimestamp;
                        return this;
                    }
                };
            }
        };
    }

    @Override
    public RowSliceQuery<K, C> getKeyRange(final K startKey, final K endKey, final String startToken, final String endToken, final int count) {
        return new AbstractRowSliceQueryImpl<K, C>(this.columnFamily.getColumnSerializer()){

            @Override
            public OperationResult<Rows<K, C>> execute() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<Rows<K, C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_RANGE, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                    @Override
                    public Rows<K, C> internalExecute(Cassandra.Client client) throws Exception {
                        KeyRange range = new KeyRange();
                        if (startKey != null) {
                            range.setStart_key(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(startKey));
                        }
                        if (endKey != null) {
                            range.setEnd_key(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(endKey));
                        }
                        range.setCount(count).setStart_token(startToken).setEnd_token(endToken);
                        List keySlices = client.get_range_slices(new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, range, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                        if (keySlices == null || keySlices.isEmpty()) {
                            return new EmptyRowsImpl();
                        }
                        return new ThriftRowsSliceImpl(keySlices, ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer(), ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer());
                    }

                    @Override
                    public ByteBuffer getRowKey() {
                        if (startKey != null) {
                            return ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toByteBuffer(startKey);
                        }
                        return null;
                    }
                }, ThriftColumnFamilyQueryImpl.this.retry);
            }

            @Override
            public Future<OperationResult<Rows<K, C>>> executeAsync() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Rows<K, C>>>(){

                    @Override
                    public OperationResult<Rows<K, C>> call() throws Exception {
                        return this.execute();
                    }
                });
            }

            @Override
            public RowSliceColumnCountQuery<K> getColumnCounts() {
                throw new RuntimeException("Not supported yet");
            }
        };
    }

    @Override
    public RowSliceQuery<K, C> getKeySlice(final Iterable<K> keys) {
        return new AbstractRowSliceQueryImpl<K, C>(this.columnFamily.getColumnSerializer()){

            @Override
            public OperationResult<Rows<K, C>> execute() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<Rows<K, C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_SLICE, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                    @Override
                    public Rows<K, C> internalExecute(Cassandra.Client client) throws Exception {
                        Map cfmap = client.multiget_slice(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toBytesList(keys), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                        if (cfmap == null || cfmap.isEmpty()) {
                            return new EmptyRowsImpl();
                        }
                        return new ThriftRowsListImpl(cfmap, ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer(), ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer());
                    }
                }, ThriftColumnFamilyQueryImpl.this.retry);
            }

            @Override
            public Future<OperationResult<Rows<K, C>>> executeAsync() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Rows<K, C>>>(){

                    @Override
                    public OperationResult<Rows<K, C>> call() throws Exception {
                        return this.execute();
                    }
                });
            }

            @Override
            public RowSliceColumnCountQuery<K> getColumnCounts() {
                return new RowSliceColumnCountQuery<K>(){

                    @Override
                    public OperationResult<Map<K, Integer>> execute() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<Map<K, Integer>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_SLICE, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                            @Override
                            public Map<K, Integer> internalExecute(Cassandra.Client client) throws Exception {
                                Map cfmap = client.multiget_count(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toBytesList(keys), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                                if (cfmap == null || cfmap.isEmpty()) {
                                    return Maps.newHashMap();
                                }
                                return ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().fromBytesMap(cfmap);
                            }
                        }, ThriftColumnFamilyQueryImpl.this.retry);
                    }

                    @Override
                    public Future<OperationResult<Map<K, Integer>>> executeAsync() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Map<K, Integer>>>(){

                            @Override
                            public OperationResult<Map<K, Integer>> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }
        };
    }

    @Override
    public RowSliceQuery<K, C> getKeySlice(K[] keys) {
        return this.getKeySlice((Collection<K>)Arrays.asList(keys));
    }

    @Override
    public RowSliceQuery<K, C> getKeySlice(final Collection<K> keys) {
        return new AbstractRowSliceQueryImpl<K, C>(this.columnFamily.getColumnSerializer()){

            @Override
            public OperationResult<Rows<K, C>> execute() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<Rows<K, C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_SLICE, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                    @Override
                    public Rows<K, C> internalExecute(Cassandra.Client client) throws Exception {
                        Map cfmap = client.multiget_slice(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toBytesList(keys), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                        if (cfmap == null || cfmap.isEmpty()) {
                            return new EmptyRowsImpl();
                        }
                        return new ThriftRowsListImpl(cfmap, ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer(), ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer());
                    }

                    @Override
                    public ByteBuffer getRowKey() {
                        return null;
                    }
                }, ThriftColumnFamilyQueryImpl.this.retry);
            }

            @Override
            public Future<OperationResult<Rows<K, C>>> executeAsync() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Rows<K, C>>>(){

                    @Override
                    public OperationResult<Rows<K, C>> call() throws Exception {
                        return this.execute();
                    }
                });
            }

            @Override
            public RowSliceColumnCountQuery<K> getColumnCounts() {
                return new RowSliceColumnCountQuery<K>(){

                    @Override
                    public OperationResult<Map<K, Integer>> execute() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<Map<K, Integer>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_SLICE, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                            @Override
                            public Map<K, Integer> internalExecute(Cassandra.Client client) throws Exception {
                                Map cfmap = client.multiget_count(ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().toBytesList(keys), new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                                if (cfmap == null || cfmap.isEmpty()) {
                                    return Maps.newHashMap();
                                }
                                return ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer().fromBytesMap(cfmap);
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                return null;
                            }
                        }, ThriftColumnFamilyQueryImpl.this.retry);
                    }

                    @Override
                    public Future<OperationResult<Map<K, Integer>>> executeAsync() throws ConnectionException {
                        return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Map<K, Integer>>>(){

                            @Override
                            public OperationResult<Map<K, Integer>> call() throws Exception {
                                return this.execute();
                            }
                        });
                    }
                };
            }
        };
    }

    @Override
    public ColumnFamilyQuery<K, C> setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    @Override
    public IndexQuery<K, C> searchWithIndex() {
        return new AbstractIndexQueryImpl<K, C>(this.columnFamily){

            @Override
            public OperationResult<Rows<K, C>> execute() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<Rows<K, C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_BY_INDEX, this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                    @Override
                    public Rows<K, C> execute(Cassandra.Client client) throws ConnectionException {
                        if (isPaginating && paginateNoMore) {
                            return new EmptyRowsImpl();
                        }
                        return (Rows)super.execute(client);
                    }

                    @Override
                    public Rows<K, C> internalExecute(Cassandra.Client client) throws Exception {
                        List cfmap = client.get_indexed_slices(new ColumnParent().setColumn_family(columnFamily.getName()), indexClause, predicate, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                        if (cfmap == null) {
                            return new EmptyRowsImpl();
                        }
                        if (isPaginating) {
                            if (!firstPage) {
                                cfmap.remove(0);
                            }
                            try {
                                if (!cfmap.isEmpty()) {
                                    this.setNextStartKey(ByteBuffer.wrap(((KeySlice)Iterables.getLast((Iterable)cfmap)).getKey()));
                                } else {
                                    paginateNoMore = true;
                                }
                            }
                            catch (ArithmeticException e) {
                                paginateNoMore = true;
                            }
                        }
                        return new ThriftRowsSliceImpl(cfmap, columnFamily.getKeySerializer(), columnFamily.getColumnSerializer());
                    }
                }, ThriftColumnFamilyQueryImpl.this.retry);
            }

            @Override
            public Future<OperationResult<Rows<K, C>>> executeAsync() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<Rows<K, C>>>(){

                    @Override
                    public OperationResult<Rows<K, C>> call() throws Exception {
                        return this.execute();
                    }
                });
            }
        };
    }

    @Override
    public CqlQuery<K, C> withCql(final String cql) {
        return new CqlQuery<K, C>(){
            private boolean useCompression = false;

            @Override
            public OperationResult<com.netflix.astyanax.model.CqlResult<K, C>> execute() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<com.netflix.astyanax.model.CqlResult<K, C>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.CQL, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                    @Override
                    public com.netflix.astyanax.model.CqlResult<K, C> internalExecute(Cassandra.Client client) throws Exception {
                        CqlResult res = client.execute_cql_query(StringSerializer.get().toByteBuffer(cql), useCompression ? Compression.GZIP : Compression.NONE);
                        switch (res.getType()) {
                            case ROWS: {
                                return new ThriftCqlResultImpl(new ThriftCqlRowsImpl(res.getRows(), ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer(), ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer()));
                            }
                            case INT: {
                                return new ThriftCqlResultImpl(res.getNum());
                            }
                        }
                        return null;
                    }
                }, ThriftColumnFamilyQueryImpl.this.retry);
            }

            @Override
            public Future<OperationResult<com.netflix.astyanax.model.CqlResult<K, C>>> executeAsync() throws ConnectionException {
                return ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<OperationResult<com.netflix.astyanax.model.CqlResult<K, C>>>(){

                    @Override
                    public OperationResult<com.netflix.astyanax.model.CqlResult<K, C>> call() throws Exception {
                        return this.execute();
                    }
                });
            }

            @Override
            public CqlQuery<K, C> useCompression() {
                this.useCompression = true;
                return this;
            }
        };
    }

    @Override
    public AllRowsQuery<K, C> getAllRows() {
        return new AbstractThriftAllRowsQueryImpl<K, C>(this.columnFamily){

            private AbstractThriftAllRowsQueryImpl<K, C> getThisQuery() {
                return this;
            }

            @Override
            protected List<KeySlice> getNextBlock(final KeyRange range) {
                while (true) {
                    try {
                        return ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<List<KeySlice>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_RANGE, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                            @Override
                            public List<KeySlice> internalExecute(Cassandra.Client client) throws Exception {
                                return client.get_range_slices(new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, range, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                            }

                            @Override
                            public ByteBuffer getRowKey() {
                                if (range.getStart_key() != null) {
                                    return range.start_key;
                                }
                                return null;
                            }
                        }, ThriftColumnFamilyQueryImpl.this.retry).getResult();
                    }
                    catch (ConnectionException e) {
                        if (this.getExceptionCallback() != null) continue;
                        throw new RuntimeException(e);
                        if (this.getExceptionCallback().onException(e)) continue;
                        return new ArrayList<KeySlice>();
                    }
                    break;
                }
            }

            @Override
            public OperationResult<Rows<K, C>> execute() throws ConnectionException {
                return new OperationResultImpl(Host.NO_HOST, new ThriftAllRowsImpl(this.getThisQuery(), ThriftColumnFamilyQueryImpl.this.columnFamily), 0L);
            }

            @Override
            public Future<OperationResult<Rows<K, C>>> executeAsync() throws ConnectionException {
                throw new UnsupportedOperationException("executeAsync not supported here.  Use execute()");
            }

            private boolean shouldIgnoreEmptyRows() {
                if (this.getIncludeEmptyRows() == null) {
                    return !this.getPredicate().isSetSlice_range() || this.getPredicate().getSlice_range().getCount() != 0;
                }
                return this.getIncludeEmptyRows() == false;
            }

            @Override
            public void executeWithCallback(final RowCallback<K, C> callback) throws ConnectionException {
                List<Pair> ranges;
                final RandomPartitioner partitioner = new RandomPartitioner();
                final AtomicReference error = new AtomicReference();
                final boolean bIgnoreTombstones = this.shouldIgnoreEmptyRows();
                if (this.getConcurrencyLevel() != null) {
                    ranges = Lists.newArrayList();
                    int nThreads = this.getConcurrencyLevel();
                    for (int i = 0; i < nThreads; ++i) {
                        BigIntegerToken start = new BigIntegerToken(TokenGenerator.initialToken(nThreads, i, this.getStartToken(), this.getEndToken()));
                        BigIntegerToken end = new BigIntegerToken(TokenGenerator.initialToken(nThreads, i + 1, this.getStartToken(), this.getEndToken()));
                        try {
                            Pair pair = Pair.create((Object)this.checkpointManager.getCheckpoint(start.toString()), (Object)end.toString());
                            if (pair.left == null) {
                                pair = Pair.create((Object)start.toString(), (Object)end.toString());
                                ranges.add(pair);
                                continue;
                            }
                            if (((String)pair.left).equals(pair.right)) continue;
                            ranges.add(pair);
                            continue;
                        }
                        catch (Exception e) {
                            throw ThriftConverter.ToConnectionPoolException(e);
                        }
                    }
                } else {
                    ranges = Lists.transform(ThriftColumnFamilyQueryImpl.this.keyspace.describeRing(true), (Function)new Function<TokenRange, Pair<String, String>>(){

                        public Pair<String, String> apply(TokenRange input) {
                            return Pair.create((Object)input.getStartToken(), (Object)input.getEndToken());
                        }
                    });
                }
                final CountDownLatch doneSignal = new CountDownLatch(ranges.size());
                for (final Pair tokenPair : ranges) {
                    final KeyRange range = new KeyRange().setCount(this.getBlockSize()).setStart_token((String)tokenPair.left).setEnd_token((String)tokenPair.right);
                    ThriftColumnFamilyQueryImpl.this.executor.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            if (error.get() == null && this.internalRun()) {
                                ThriftColumnFamilyQueryImpl.this.executor.submit(this);
                            } else {
                                doneSignal.countDown();
                            }
                            return null;
                        }

                        private boolean internalRun() throws Exception {
                            block10: {
                                try {
                                    List<KeySlice> ks = ThriftColumnFamilyQueryImpl.this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<List<KeySlice>>(ThriftColumnFamilyQueryImpl.this.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_RANGE, ThriftColumnFamilyQueryImpl.this.columnFamily), ThriftColumnFamilyQueryImpl.this.pinnedHost, ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName()){

                                        @Override
                                        public List<KeySlice> internalExecute(Cassandra.Client client) throws Exception {
                                            return client.get_range_slices(new ColumnParent().setColumn_family(ThriftColumnFamilyQueryImpl.this.columnFamily.getName()), predicate, range, ThriftConverter.ToThriftConsistencyLevel(ThriftColumnFamilyQueryImpl.this.consistencyLevel));
                                        }

                                        @Override
                                        public ByteBuffer getRowKey() {
                                            if (range.getStart_key() != null) {
                                                return ByteBuffer.wrap(range.getStart_key());
                                            }
                                            return null;
                                        }
                                    }, ThriftColumnFamilyQueryImpl.this.retry.duplicate()).getResult();
                                    if (!ks.isEmpty()) {
                                        boolean bContinue;
                                        KeySlice lastRow = (KeySlice)Iterables.getLast(ks);
                                        boolean bl = bContinue = ks.size() == this.getBlockSize();
                                        if (bIgnoreTombstones) {
                                            Iterator<KeySlice> iter = ks.iterator();
                                            while (iter.hasNext()) {
                                                if (iter.next().getColumnsSize() != 0) continue;
                                                iter.remove();
                                            }
                                        }
                                        ThriftRowsSliceImpl rows = new ThriftRowsSliceImpl(ks, ThriftColumnFamilyQueryImpl.this.columnFamily.getKeySerializer(), ThriftColumnFamilyQueryImpl.this.columnFamily.getColumnSerializer());
                                        try {
                                            callback.success(rows);
                                        }
                                        catch (Throwable t) {
                                            ConnectionException ce = ThriftConverter.ToConnectionPoolException(t);
                                            error.set(ce);
                                            return false;
                                        }
                                        if (bContinue) {
                                            String token = partitioner.getToken(lastRow.bufferForKey()).toString();
                                            checkpointManager.trackCheckpoint((String)tokenPair.left, token);
                                            if (this.getRepeatLastToken()) {
                                                BigInteger intToken = new BigInteger(token).subtract(new BigInteger("1"));
                                                range.setStart_token(intToken.toString());
                                            } else {
                                                range.setStart_token(token);
                                            }
                                            break block10;
                                        }
                                        checkpointManager.trackCheckpoint((String)tokenPair.left, (String)tokenPair.right);
                                        return false;
                                    }
                                    checkpointManager.trackCheckpoint((String)tokenPair.left, (String)tokenPair.right);
                                    return false;
                                }
                                catch (Exception e) {
                                    ConnectionException ce = ThriftConverter.ToConnectionPoolException(e);
                                    if (callback.failure(ce)) break block10;
                                    error.set(ce);
                                    return false;
                                }
                            }
                            return true;
                        }
                    });
                }
                try {
                    doneSignal.await();
                }
                catch (InterruptedException e) {
                    LOG.debug("Execution interrupted on get all rows for keyspace " + ThriftColumnFamilyQueryImpl.this.keyspace.getKeyspaceName());
                }
                if (error.get() != null) {
                    throw (ConnectionException)error.get();
                }
            }
        };
    }

    @Override
    public ColumnFamilyQuery<K, C> pinToHost(Host host) {
        this.pinnedHost = host;
        return this;
    }

    @Override
    public ColumnFamilyQuery<K, C> withRetryPolicy(RetryPolicy retry) {
        this.retry = retry;
        return this;
    }

    @Override
    public RowQuery<K, C> getRow(K rowKey) {
        return this.getKey(rowKey);
    }

    @Override
    public RowSliceQuery<K, C> getRowRange(K startKey, K endKey, String startToken, String endToken, int count) {
        return this.getKeyRange(startKey, endKey, startToken, endToken, count);
    }

    @Override
    public RowSliceQuery<K, C> getRowSlice(K ... keys) {
        return this.getKeySlice(keys);
    }

    @Override
    public RowSliceQuery<K, C> getRowSlice(Collection<K> keys) {
        return this.getKeySlice(keys);
    }

    @Override
    public RowSliceQuery<K, C> getRowSlice(Iterable<K> keys) {
        return this.getRowSlice(keys);
    }
}

