/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.netflix.astyanax.CassandraOperationTracer;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.thrift.ThriftConverter;
import java.nio.ByteBuffer;
import org.apache.cassandra.thrift.Cassandra;

public abstract class AbstractOperationImpl<R>
implements Operation<Cassandra.Client, R> {
    private final CassandraOperationTracer tracer;
    private final Host pinnedHost;

    public AbstractOperationImpl(CassandraOperationTracer tracer, Host host) {
        this.tracer = tracer;
        this.pinnedHost = host;
    }

    public AbstractOperationImpl(CassandraOperationTracer tracer) {
        this.tracer = tracer;
        this.pinnedHost = null;
    }

    @Override
    public ByteBuffer getRowKey() {
        return null;
    }

    @Override
    public String getKeyspace() {
        return null;
    }

    @Override
    public R execute(Cassandra.Client client) throws ConnectionException {
        try {
            this.tracer.start();
            R result = this.internalExecute(client);
            this.tracer.success();
            return result;
        }
        catch (Exception e) {
            ConnectionException ce = ThriftConverter.ToConnectionPoolException(e);
            this.tracer.failure(ce);
            throw ce;
        }
    }

    @Override
    public Host getPinnedHost() {
        return this.pinnedHost;
    }

    protected abstract R internalExecute(Cassandra.Client var1) throws Exception;
}

