/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.serializers.AsciiSerializer;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.CompositeSerializer;
import com.netflix.astyanax.serializers.DateSerializer;
import com.netflix.astyanax.serializers.DoubleSerializer;
import com.netflix.astyanax.serializers.DynamicCompositeSerializer;
import com.netflix.astyanax.serializers.FloatSerializer;
import com.netflix.astyanax.serializers.Int32Serializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.TimeUUIDSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;

public enum ComparatorType {
    ASCIITYPE("org.apache.cassandra.db.marshal.AsciiType", AsciiSerializer.get()),
    BYTESTYPE("org.apache.cassandra.db.marshal.BytesType", ByteBufferSerializer.get()),
    INTEGERTYPE("org.apache.cassandra.db.marshal.IntegerType", IntegerSerializer.get()),
    INT32TYPE("org.apache.cassandra.db.marshal.Int32Type", Int32Serializer.get()),
    LEXICALUUIDTYPE("org.apache.cassandra.db.marshal.LexicalUUIDType", UUIDSerializer.get()),
    LOCALBYPARTITIONERTYPE("org.apache.cassandra.db.marshal.LocalByPartionerType", ByteBufferSerializer.get()),
    LONGTYPE("org.apache.cassandra.db.marshal.LongType", LongSerializer.get()),
    TIMEUUIDTYPE("org.apache.cassandra.db.marshal.TimeUUIDType", TimeUUIDSerializer.get()),
    UTF8TYPE("org.apache.cassandra.db.marshal.UTF8Type", StringSerializer.get()),
    COMPOSITETYPE("org.apache.cassandra.db.marshal.CompositeType", CompositeSerializer.get()),
    DYNAMICCOMPOSITETYPE("org.apache.cassandra.db.marshal.DynamicCompositeType", DynamicCompositeSerializer.get()),
    UUIDTYPE("org.apache.cassandra.db.marshal.UUIDType", UUIDSerializer.get()),
    COUNTERTYPE("org.apache.cassandra.db.marshal.CounterColumnType", LongSerializer.get()),
    DOUBLETYPE("org.apache.cassandra.db.marshal.DoubleType", DoubleSerializer.get()),
    FLOATTYPE("org.apache.cassandra.db.marshal.FloatType", FloatSerializer.get()),
    BOOLEANTYPE("org.apache.cassandra.db.marshal.BooleanType", BooleanSerializer.get()),
    DATETYPE("org.apache.cassandra.db.marshal.DateType", DateSerializer.get());

    private final String className;
    private final String typeName;
    private final Serializer<?> serializer;

    private ComparatorType(String className, Serializer<?> serializer) {
        this.className = className;
        this.typeName = className.startsWith("org.apache.cassandra.db.marshal.") ? className.substring("org.apache.cassandra.db.marshal.".length()) : className;
        this.serializer = serializer;
    }

    public String getClassName() {
        return this.className;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    public static ComparatorType getByClassName(String className) {
        if (className == null) {
            return null;
        }
        for (ComparatorType type : ComparatorType.values()) {
            if (type.getClassName().equals(className)) {
                return type;
            }
            if (!type.getClassName().equals("org.apache.cassandra.db.marshal." + className)) continue;
            return type;
        }
        return null;
    }
}

