/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.scheduler;

import java.util.concurrent.TimeUnit;

public class TaskInfo {
    private String key;
    private String className;
    private boolean keepHistory;
    private Integer historyTtl;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isKeepHistory() {
        return this.keepHistory;
    }

    public void setKeepHistory(boolean keepHistory) {
        this.keepHistory = keepHistory;
    }

    public Integer getHistoryTtl() {
        return this.historyTtl;
    }

    public void setHistoryTtl(Integer historyTtl) {
        this.historyTtl = historyTtl;
    }

    public static class Builder {
        private TaskInfo info = new TaskInfo();

        public Builder withKey(String key) {
            this.info.setKey(key);
            return this;
        }

        public Builder withClassName(String className) {
            this.info.setClassName(className);
            return this;
        }

        public Builder withClass(Class<?> clazz) {
            this.info.setClassName(clazz.getCanonicalName());
            return this;
        }

        public Builder withHistoryTtl(long ttl, TimeUnit units) {
            this.info.historyTtl = (int)TimeUnit.SECONDS.convert(ttl, units);
            this.info.keepHistory = true;
            return this;
        }

        public Builder withHistory(boolean keepHistory) {
            this.info.keepHistory = keepHistory;
            return this;
        }

        public TaskInfo build() {
            return this.info;
        }
    }
}

