/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.queue;

import com.netflix.astyanax.annotations.Component;
import com.netflix.astyanax.recipes.queue.MessageQueueEntryState;
import com.netflix.astyanax.recipes.queue.MessageQueueEntryType;
import com.netflix.astyanax.util.TimeUUIDUtils;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class MessageQueueEntry {
    private static final String ID_DELIMITER = ":";
    @Component(ordinal=0)
    private Byte type;
    @Component(ordinal=1)
    private Byte priority;
    @Component(ordinal=2)
    private UUID timestamp;
    @Component(ordinal=3)
    private Byte state;

    public MessageQueueEntry() {
    }

    public MessageQueueEntry(String id) {
        String[] parts = StringUtils.split((String)id, (String)ID_DELIMITER);
        if (parts.length != 4) {
            throw new RuntimeException("Invalid message ID.  Expection <type>:<priority>:<timestamp>:<state> but got " + id);
        }
        this.type = Byte.parseByte(parts[0]);
        this.priority = Byte.parseByte(parts[1]);
        this.timestamp = UUID.fromString(parts[2]);
        this.state = Byte.parseByte(parts[3]);
    }

    private MessageQueueEntry(MessageQueueEntryType type, byte priority, UUID timestamp, MessageQueueEntryState state) {
        this.type = (byte)type.ordinal();
        this.priority = 0;
        this.timestamp = timestamp;
        this.state = (byte)state.ordinal();
    }

    public static MessageQueueEntry newLockEntry(MessageQueueEntryState state) {
        return new MessageQueueEntry(MessageQueueEntryType.Lock, 0, TimeUUIDUtils.getUniqueTimeUUIDinMicros(), state);
    }

    public static MessageQueueEntry newLockEntry(UUID timestamp, MessageQueueEntryState state) {
        return new MessageQueueEntry(MessageQueueEntryType.Lock, 0, timestamp, state);
    }

    public static MessageQueueEntry newMetadataEntry() {
        return new MessageQueueEntry(MessageQueueEntryType.Metadata, 0, null, MessageQueueEntryState.None);
    }

    public static MessageQueueEntry newMessageEntry(byte priority, UUID timestamp, MessageQueueEntryState state) {
        return new MessageQueueEntry(MessageQueueEntryType.Message, priority, timestamp, state);
    }

    public MessageQueueEntryType getType() {
        return MessageQueueEntryType.values()[this.type];
    }

    public UUID getTimestamp() {
        return this.timestamp;
    }

    public long getTimetsamp(TimeUnit units) {
        return units.convert(TimeUUIDUtils.getMicrosTimeFromUUID(this.timestamp), TimeUnit.MICROSECONDS);
    }

    public MessageQueueEntryState getState() {
        return MessageQueueEntryState.values()[this.state];
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public void setTimestamp(UUID timestamp) {
        this.timestamp = timestamp;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public void setPriorty(Byte priority) {
        this.priority = priority;
    }

    public String getMessageId() {
        return this.type + ID_DELIMITER + this.priority + ID_DELIMITER + this.timestamp.toString() + ID_DELIMITER + this.state;
    }

    public String toString() {
        return "MessageQueueEntry [" + (Object)((Object)this.getType()) + " " + this.priority + " " + this.timestamp + " " + (Object)((Object)this.getState()) + "]";
    }
}

