/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.astyanax.AuthenticationCredentials;
import com.netflix.astyanax.connectionpool.BadHostDetector;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.LatencyScoreStrategy;
import com.netflix.astyanax.connectionpool.OperationFilterFactory;
import com.netflix.astyanax.connectionpool.RetryBackoffStrategy;
import com.netflix.astyanax.connectionpool.SSLConnectionContext;
import com.netflix.astyanax.connectionpool.impl.BadHostDetectorImpl;
import com.netflix.astyanax.connectionpool.impl.ExponentialRetryBackoffStrategy;
import com.netflix.astyanax.partitioner.BigInteger127Partitioner;
import com.netflix.astyanax.partitioner.Partitioner;
import com.netflix.astyanax.shallows.EmptyBadHostDetectorImpl;
import com.netflix.astyanax.shallows.EmptyLatencyScoreStrategyImpl;
import com.netflix.astyanax.shallows.EmptyOperationFilterFactory;
import com.netflix.astyanax.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class ConnectionPoolConfigurationImpl
implements ConnectionPoolConfiguration {
    public static final int DEFAULT_MAX_TIME_WHEN_EXHAUSTED = 2000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 11000;
    public static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    public static final int DEFAULT_MAX_ACTIVE_PER_PARTITION = 3;
    public static final int DEFAULT_INIT_PER_PARTITION = 0;
    public static final int DEFAULT_PORT = 9160;
    public static final int DEFAULT_FAILOVER_COUNT = -1;
    public static final int DEFAULT_MAX_CONNS = 1;
    public static final int DEFAULT_LATENCY_AWARE_WINDOW_SIZE = 100;
    public static final float DEFAULT_LATENCY_AWARE_SENTINEL_COMPARE = 0.768f;
    public static final int DEFAULT_LATENCY_AWARE_UPDATE_INTERVAL = 10000;
    public static final int DEFAULT_LATENCY_AWARE_RESET_INTERVAL = 60000;
    public static final float DEFAULT_LATENCY_AWARE_BADNESS_THRESHOLD = 0.1f;
    public static final int DEFAULT_CONNECTION_LIMITER_WINDOW_SIZE = 2000;
    public static final int DEFAULT_CONNECTION_LIMITER_MAX_PENDING_COUNT = 50;
    public static final int DEFAULT_MAX_PENDING_CONNECTIONS_PER_HOST = 5;
    public static final int DEFAULT_MAX_BLOCKED_THREADS_PER_HOST = 25;
    public static final int DEFAULT_MAX_TIMEOUT_COUNT = 3;
    public static final int DEFAULT_TIMEOUT_WINDOW = 10000;
    public static final int DEFAULT_RETRY_SUSPEND_WINDOW = 20000;
    public static final int DEFAULT_RETRY_DELAY_SLICE = 1000;
    public static final int DEFAULT_RETRY_MAX_DELAY_SLICE = 10;
    public static final int DEFAULT_MAX_OPERATIONS_PER_CONNECTION = 10000;
    public static final float DEFAULT_MIN_HOST_IN_POOL_RATIO = 0.65f;
    public static final int DEFAULT_BLOCKED_THREAD_THRESHOLD = 10;
    public static final BadHostDetector DEFAULT_BAD_HOST_DETECTOR = EmptyBadHostDetectorImpl.getInstance();
    public static final Partitioner DEFAULT_PARTITIONER = BigInteger127Partitioner.get();
    private static final int DEFAULT_RECONNECT_THREAD_COUNT = 5;
    private static final int DEFAULT_MAINTAINANCE_THREAD_COUNT = 1;
    private final String name;
    private int maxConnsPerPartition = 3;
    private int initConnsPerPartition = 0;
    private int maxConns = 1;
    private int port = 9160;
    private int socketTimeout = 11000;
    private int connectTimeout = 2000;
    private int maxFailoverCount = -1;
    private int latencyAwareWindowSize = 100;
    private float latencyAwareSentinelCompare = 0.768f;
    private float latencyAwareBadnessThreshold = 0.1f;
    private int latencyAwareUpdateInterval = 10000;
    private int latencyAwareResetInterval = 60000;
    private int connectionLimiterWindowSize = 2000;
    private int connectionLimiterMaxPendingCount = 50;
    private int maxPendingConnectionsPerHost = 5;
    private int maxBlockedThreadsPerHost = 25;
    private int maxTimeoutCount = 3;
    private int timeoutWindow = 10000;
    private int retrySuspendWindow = 20000;
    private int retryDelaySlice = 1000;
    private int retryMaxDelaySlice = 10;
    private int maxOperationsPerConnection = 10000;
    private int maxTimeoutWhenExhausted = 2000;
    private float minHostInPoolRatio = 0.65f;
    private int blockedThreadThreshold = 10;
    private String seeds = null;
    private RetryBackoffStrategy hostRetryBackoffStrategy = null;
    private LatencyScoreStrategy latencyScoreStrategy = new EmptyLatencyScoreStrategyImpl();
    private BadHostDetector badHostDetector = DEFAULT_BAD_HOST_DETECTOR;
    private AuthenticationCredentials credentials = null;
    private OperationFilterFactory filterFactory = EmptyOperationFilterFactory.getInstance();
    private Partitioner partitioner = DEFAULT_PARTITIONER;
    private SSLConnectionContext sslCtx;
    private ScheduledExecutorService maintainanceExecutor;
    private ScheduledExecutorService reconnectExecutor;
    private boolean bOwnMaintainanceExecutor = false;
    private boolean bOwnReconnectExecutor = false;
    private String localDatacenter = null;

    public ConnectionPoolConfigurationImpl(String name) {
        this.name = name;
        this.badHostDetector = new BadHostDetectorImpl(this);
        this.hostRetryBackoffStrategy = new ExponentialRetryBackoffStrategy(this);
    }

    @Override
    public void initialize() {
        if (this.maintainanceExecutor == null) {
            this.maintainanceExecutor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).build());
            this.bOwnMaintainanceExecutor = true;
        }
        if (this.reconnectExecutor == null) {
            this.reconnectExecutor = Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).build());
            this.bOwnReconnectExecutor = true;
        }
    }

    @Override
    public void shutdown() {
        if (this.bOwnMaintainanceExecutor) {
            this.maintainanceExecutor.shutdownNow();
        }
        if (this.bOwnReconnectExecutor) {
            this.reconnectExecutor.shutdownNow();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public ConnectionPoolConfigurationImpl setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ConnectionPoolConfigurationImpl setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public String getSeeds() {
        return this.seeds;
    }

    public ConnectionPoolConfigurationImpl setSeeds(String seeds) {
        this.seeds = seeds;
        return this;
    }

    @Override
    public String getLocalDatacenter() {
        return this.localDatacenter;
    }

    public ConnectionPoolConfigurationImpl setLocalDatacenter(String localDatacenter) {
        this.localDatacenter = localDatacenter;
        return this;
    }

    @Override
    public int getMaxTimeoutWhenExhausted() {
        return this.maxTimeoutWhenExhausted;
    }

    public ConnectionPoolConfigurationImpl setMaxTimeoutWhenExhausted(int timeout) {
        this.maxTimeoutWhenExhausted = timeout;
        return this;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public ConnectionPoolConfigurationImpl setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public int getMaxConnsPerHost() {
        return this.maxConnsPerPartition;
    }

    public ConnectionPoolConfigurationImpl setMaxConnsPerHost(int maxConns) {
        Preconditions.checkArgument((maxConns > 0 ? 1 : 0) != 0, (Object)"maxConnsPerHost must be >0");
        this.maxConnsPerPartition = maxConns;
        return this;
    }

    @Override
    public int getInitConnsPerHost() {
        return this.initConnsPerPartition;
    }

    public ConnectionPoolConfigurationImpl setInitConnsPerHost(int initConns) {
        Preconditions.checkArgument((initConns >= 0 ? 1 : 0) != 0, (Object)"initConnsPerHost must be >0");
        this.initConnsPerPartition = initConns;
        return this;
    }

    @Override
    public RetryBackoffStrategy getRetryBackoffStrategy() {
        return this.hostRetryBackoffStrategy;
    }

    public ConnectionPoolConfigurationImpl setRetryBackoffStrategy(RetryBackoffStrategy hostRetryBackoffStrategy) {
        this.hostRetryBackoffStrategy = hostRetryBackoffStrategy;
        return this;
    }

    @Override
    public List<Host> getSeedHosts() {
        ArrayList<Host> hosts = new ArrayList<Host>();
        if (this.seeds != null) {
            for (String seed : this.seeds.split(",")) {
                if ((seed = seed.trim()).length() <= 0) continue;
                hosts.add(new Host(seed, this.port));
            }
        }
        return hosts;
    }

    @Override
    public int getMaxFailoverCount() {
        return this.maxFailoverCount;
    }

    public ConnectionPoolConfigurationImpl setMaxFailoverCount(int maxFailoverCount) {
        this.maxFailoverCount = maxFailoverCount;
        return this;
    }

    @Override
    public int getMaxConns() {
        return this.maxConns;
    }

    public ConnectionPoolConfigurationImpl setMaxConns(int maxConns) {
        this.maxConns = maxConns;
        return this;
    }

    @Override
    public int getLatencyAwareWindowSize() {
        return this.latencyAwareWindowSize;
    }

    public ConnectionPoolConfigurationImpl setLatencyAwareWindowSize(int latencyAwareWindowSize) {
        this.latencyAwareWindowSize = latencyAwareWindowSize;
        return this;
    }

    @Override
    public float getLatencyAwareSentinelCompare() {
        return this.latencyAwareSentinelCompare;
    }

    public ConnectionPoolConfigurationImpl setLatencyAwareSentinelCompare(float latencyAwareSentinelCompare) {
        this.latencyAwareSentinelCompare = latencyAwareSentinelCompare;
        return this;
    }

    @Override
    public float getLatencyAwareBadnessThreshold() {
        return this.latencyAwareBadnessThreshold;
    }

    public ConnectionPoolConfigurationImpl setLatencyAwareBadnessThreshold(float threshold) {
        this.latencyAwareBadnessThreshold = threshold;
        return this;
    }

    @Override
    public int getConnectionLimiterWindowSize() {
        return this.connectionLimiterWindowSize;
    }

    public ConnectionPoolConfigurationImpl setConnectionLimiterWindowSize(int pendingConnectionWindowSize) {
        this.connectionLimiterWindowSize = pendingConnectionWindowSize;
        return this;
    }

    @Override
    public int getConnectionLimiterMaxPendingCount() {
        return this.connectionLimiterMaxPendingCount;
    }

    public ConnectionPoolConfigurationImpl setConnectionLimiterMaxPendingCount(int connectionLimiterMaxPendingCount) {
        this.connectionLimiterMaxPendingCount = connectionLimiterMaxPendingCount;
        return this;
    }

    @Override
    public int getMaxPendingConnectionsPerHost() {
        return this.maxPendingConnectionsPerHost;
    }

    public ConnectionPoolConfigurationImpl setMaxPendingConnectionsPerHost(int maxPendingConnectionsPerHost) {
        this.maxPendingConnectionsPerHost = maxPendingConnectionsPerHost;
        return this;
    }

    @Override
    public int getMaxBlockedThreadsPerHost() {
        return this.maxBlockedThreadsPerHost;
    }

    public ConnectionPoolConfigurationImpl setMaxBlockedThreadsPerHost(int maxBlockedThreadsPerHost) {
        this.maxBlockedThreadsPerHost = maxBlockedThreadsPerHost;
        return this;
    }

    @Override
    public int getTimeoutWindow() {
        return this.timeoutWindow;
    }

    public ConnectionPoolConfigurationImpl setTimeoutWindow(int timeoutWindow) {
        this.timeoutWindow = timeoutWindow;
        return this;
    }

    @Override
    public int getMaxTimeoutCount() {
        return this.maxTimeoutCount;
    }

    public ConnectionPoolConfigurationImpl setMaxTimeoutCount(int maxTimeoutCount) {
        this.maxTimeoutCount = maxTimeoutCount;
        return this;
    }

    @Override
    public int getLatencyAwareUpdateInterval() {
        return this.latencyAwareUpdateInterval;
    }

    public ConnectionPoolConfigurationImpl setLatencyAwareUpdateInterval(int latencyAwareUpdateInterval) {
        this.latencyAwareUpdateInterval = latencyAwareUpdateInterval;
        return this;
    }

    @Override
    public int getLatencyAwareResetInterval() {
        return this.latencyAwareResetInterval;
    }

    public ConnectionPoolConfigurationImpl setLatencyAwareResetInterval(int latencyAwareResetInterval) {
        this.latencyAwareResetInterval = latencyAwareResetInterval;
        return this;
    }

    @Override
    public int getRetrySuspendWindow() {
        return this.retrySuspendWindow;
    }

    public ConnectionPoolConfigurationImpl setRetrySuspendWindow(int retrySuspendWindow) {
        this.retrySuspendWindow = retrySuspendWindow;
        return this;
    }

    @Override
    public int getMaxOperationsPerConnection() {
        return this.maxOperationsPerConnection;
    }

    public ConnectionPoolConfigurationImpl setMaxOperationsPerConnection(int maxOperationsPerConnection) {
        this.maxOperationsPerConnection = maxOperationsPerConnection;
        return this;
    }

    @Override
    public LatencyScoreStrategy getLatencyScoreStrategy() {
        return this.latencyScoreStrategy;
    }

    public ConnectionPoolConfigurationImpl setLatencyScoreStrategy(LatencyScoreStrategy latencyScoreStrategy) {
        this.latencyScoreStrategy = latencyScoreStrategy;
        return this;
    }

    @Override
    public BadHostDetector getBadHostDetector() {
        return this.badHostDetector;
    }

    public ConnectionPoolConfigurationImpl setBadHostDetector(BadHostDetector badHostDetector) {
        this.badHostDetector = badHostDetector;
        return this;
    }

    @Override
    public int getRetryMaxDelaySlice() {
        return this.retryMaxDelaySlice;
    }

    public ConnectionPoolConfigurationImpl setRetryMaxDelaySlice(int retryMaxDelaySlice) {
        this.retryMaxDelaySlice = retryMaxDelaySlice;
        return this;
    }

    @Override
    public int getRetryDelaySlice() {
        return this.retryDelaySlice;
    }

    public ConnectionPoolConfigurationImpl setRetryDelaySlice(int retryDelaySlice) {
        this.retryDelaySlice = retryDelaySlice;
        return this;
    }

    public String toString() {
        return StringUtils.joinClassGettersValues(this, "CpConfig", ConnectionPoolConfigurationImpl.class);
    }

    @Override
    public AuthenticationCredentials getAuthenticationCredentials() {
        return this.credentials;
    }

    public ConnectionPoolConfigurationImpl setAuthenticationCredentials(AuthenticationCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Override
    public OperationFilterFactory getOperationFilterFactory() {
        return this.filterFactory;
    }

    public ConnectionPoolConfigurationImpl setOperationFilterFactory(OperationFilterFactory filterFactory) {
        this.filterFactory = filterFactory;
        return this;
    }

    @Override
    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    public ConnectionPoolConfigurationImpl setPartitioner(Partitioner partitioner) {
        this.partitioner = partitioner;
        return this;
    }

    @Override
    public int getBlockedThreadThreshold() {
        return this.blockedThreadThreshold;
    }

    public ConnectionPoolConfigurationImpl setBlockedThreadThreshold(int threshold) {
        this.blockedThreadThreshold = threshold;
        return this;
    }

    @Override
    public float getMinHostInPoolRatio() {
        return this.minHostInPoolRatio;
    }

    public ConnectionPoolConfigurationImpl setMinHostInPoolRatio(float ratio) {
        this.minHostInPoolRatio = ratio;
        return this;
    }

    @Override
    public SSLConnectionContext getSSLConnectionContext() {
        return this.sslCtx;
    }

    public ConnectionPoolConfigurationImpl setSSLConnectionContext(SSLConnectionContext sslCtx) {
        this.sslCtx = sslCtx;
        return this;
    }

    @Override
    public ScheduledExecutorService getMaintainanceScheduler() {
        return this.maintainanceExecutor;
    }

    public ConnectionPoolConfigurationImpl setMaintainanceScheduler(ScheduledExecutorService executor) {
        this.maintainanceExecutor = executor;
        this.bOwnMaintainanceExecutor = false;
        return this;
    }

    @Override
    public ScheduledExecutorService getHostReconnectExecutor() {
        return this.reconnectExecutor;
    }

    public ConnectionPoolConfigurationImpl setHostReconnectExecutor(ScheduledExecutorService executor) {
        this.reconnectExecutor = executor;
        this.bOwnReconnectExecutor = false;
        return this;
    }
}

