/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Map;
import org.jgroups.Address;
import org.jgroups.util.Digest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableDigest
extends Digest {
    private boolean sealed = false;

    public MutableDigest() {
    }

    public MutableDigest(int size) {
        super(size);
    }

    public MutableDigest(Map<Address, Digest.Entry> map) {
        super(map);
    }

    public MutableDigest(Digest digest) {
        super(digest.getSenders());
    }

    @Override
    public Map<Address, Digest.Entry> getSenders() {
        return this.senders;
    }

    public void add(Address sender, long low_seqno, long highest_delivered_seqno) {
        this.checkSealed();
        this.add(sender, low_seqno, highest_delivered_seqno, -1L);
    }

    public void add(Address sender, long low_seqno, long highest_delivered_seqno, long highest_received_seqno) {
        this.checkSealed();
        this.add(sender, new Digest.Entry(low_seqno, highest_delivered_seqno, highest_received_seqno));
    }

    private void add(Address sender, Digest.Entry entry) {
        if (sender == null || entry == null) {
            if (log.isErrorEnabled()) {
                log.error("sender (" + sender + ") or entry (" + entry + ")is null, will not add entry");
            }
            return;
        }
        this.checkSealed();
        this.senders.put(sender, entry);
    }

    public void add(Digest digest) {
        if (digest != null) {
            this.checkSealed();
            for (Map.Entry<Address, Digest.Entry> entry : digest.senders.entrySet()) {
                Address key = entry.getKey();
                Digest.Entry val = entry.getValue();
                this.add(key, val.getLow(), val.getHighestDeliveredSeqno(), val.getHighestReceivedSeqno());
            }
        }
    }

    public void replace(Digest d) {
        if (d != null) {
            this.clear();
            this.add(d);
        }
    }

    public boolean set(Address sender, long low_seqno, long highest_delivered_seqno, long highest_received_seqno) {
        this.checkSealed();
        Digest.Entry entry = this.senders.put(sender, new Digest.Entry(low_seqno, highest_delivered_seqno, highest_received_seqno));
        return entry == null;
    }

    public void merge(Digest digest) {
        if (digest == null) {
            if (log.isErrorEnabled()) {
                log.error("digest to be merged with is null");
            }
            return;
        }
        this.checkSealed();
        for (Map.Entry<Address, Digest.Entry> entry : digest.senders.entrySet()) {
            Address sender = entry.getKey();
            Digest.Entry val = entry.getValue();
            if (val == null) continue;
            this.merge(sender, val.getLow(), val.getHighestDeliveredSeqno(), val.getHighestReceivedSeqno());
        }
    }

    public void merge(Address sender, long low_seqno, long highest_delivered_seqno, long highest_received_seqno) {
        if (sender == null) {
            if (log.isErrorEnabled()) {
                log.error("sender == null");
            }
            return;
        }
        this.checkSealed();
        Digest.Entry entry = (Digest.Entry)this.senders.get(sender);
        if (entry == null) {
            this.add(sender, low_seqno, highest_delivered_seqno, highest_received_seqno);
        } else {
            Digest.Entry new_entry = new Digest.Entry(Math.min(entry.getLow(), low_seqno), Math.max(entry.getHighestDeliveredSeqno(), highest_delivered_seqno), Math.max(entry.getHighestReceivedSeqno(), highest_received_seqno));
            this.senders.put(sender, new_entry);
        }
    }

    public void incrementHighestDeliveredSeqno(Address sender) {
        Digest.Entry entry = (Digest.Entry)this.senders.get(sender);
        if (entry == null) {
            return;
        }
        this.checkSealed();
        Digest.Entry new_entry = new Digest.Entry(entry.getLow(), entry.getHighestDeliveredSeqno() + 1L, entry.getHighestReceivedSeqno());
        this.senders.put(sender, new_entry);
    }

    public void resetAt(Address sender) {
        Digest.Entry entry = (Digest.Entry)this.senders.get(sender);
        if (entry != null) {
            this.checkSealed();
        }
        this.senders.put(sender, new Digest.Entry());
    }

    public void clear() {
        this.checkSealed();
        this.senders.clear();
    }

    public void setHighestDeliveredAndSeenSeqnos(Address sender, long low_seqno, long highest_delivered_seqno, long highest_received_seqno) {
        Digest.Entry entry = (Digest.Entry)this.senders.get(sender);
        if (entry != null) {
            this.checkSealed();
            Digest.Entry new_entry = new Digest.Entry(low_seqno, highest_delivered_seqno, highest_received_seqno);
            this.senders.put(sender, new_entry);
        }
    }

    public boolean seal() {
        boolean retval = this.sealed;
        this.sealed = true;
        return retval;
    }

    private final void checkSealed() {
        if (this.sealed) {
            throw new IllegalAccessError("instance has been sealed and cannot be modified");
        }
    }
}

