/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;

@Experimental
@Unsupported
public class RATE_LIMITER
extends Protocol {
    @Property(description="Max number of bytes to be sent in time_period ms. Blocks the sender if exceeded until a new time period has started")
    protected long max_bytes = 500000L;
    @Property(description="Number of milliseconds during which max_bytes bytes can be sent")
    protected long time_period = 1000L;
    @ManagedAttribute
    protected long num_bytes_sent = 0L;
    protected long end_of_current_period = 0L;
    protected final Lock lock = new ReentrantLock();
    protected final Condition block = this.lock.newCondition();
    @ManagedAttribute
    protected int num_blockings = 0;
    @ManagedAttribute
    protected long total_block_time = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object down(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            int len = msg.getLength();
            this.lock.lock();
            try {
                if ((long)len > this.max_bytes) {
                    this.log.error("message length (" + len + " bytes) exceeded max_bytes (" + this.max_bytes + "); " + "adjusting max_bytes to " + len);
                    this.max_bytes = len;
                }
                while (true) {
                    boolean time_exceeded;
                    boolean size_exceeded = this.num_bytes_sent + (long)len >= this.max_bytes;
                    boolean bl = time_exceeded = System.currentTimeMillis() > this.end_of_current_period;
                    if (!size_exceeded && !time_exceeded) {
                        break;
                    }
                    if (time_exceeded) {
                        this.reset();
                        continue;
                    }
                    long block_time = this.end_of_current_period - System.currentTimeMillis();
                    if (block_time <= 0L) continue;
                    try {
                        this.block.await(block_time, TimeUnit.MILLISECONDS);
                        ++this.num_blockings;
                        this.total_block_time += block_time;
                    }
                    catch (InterruptedException e) {}
                }
            }
            finally {
                this.num_bytes_sent += (long)len;
                this.lock.unlock();
            }
            return this.down_prot.down(evt);
        }
        return this.down_prot.down(evt);
    }

    public void init() throws Exception {
        super.init();
        if (this.time_period <= 0L) {
            throw new IllegalArgumentException("time_period needs to be positive");
        }
    }

    public void stop() {
        super.stop();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        this.lock.lock();
        try {
            this.num_bytes_sent = 0L;
            this.end_of_current_period = System.currentTimeMillis() + this.time_period;
            this.block.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

