/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mozilla.javascript;

import com.liferay.mozilla.javascript.Callable;
import com.liferay.mozilla.javascript.Context;
import com.liferay.mozilla.javascript.Scriptable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class SecureCaller {
    private static final byte[] secureCallerImplBytecode = SecureCaller.loadBytecode();
    private static final Map callers = new WeakHashMap();
    static /* synthetic */ Class class$com$liferay$mozilla$javascript$SecureCaller;

    public abstract Object call(Callable var1, Context var2, Scriptable var3, Scriptable var4, Object[] var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object callSecurely(final CodeSource codeSource, Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        SecureCaller caller;
        WeakHashMap<ClassLoader, SoftReference<SecureCaller>> classLoaderMap;
        final Thread thread = Thread.currentThread();
        final ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return thread.getContextClassLoader();
            }
        });
        Map map = callers;
        synchronized (map) {
            classLoaderMap = (WeakHashMap<ClassLoader, SoftReference<SecureCaller>>)callers.get(codeSource);
            if (classLoaderMap == null) {
                classLoaderMap = new WeakHashMap<ClassLoader, SoftReference<SecureCaller>>();
                callers.put(codeSource, classLoaderMap);
            }
        }
        WeakHashMap<ClassLoader, SoftReference<SecureCaller>> weakHashMap = classLoaderMap;
        synchronized (weakHashMap) {
            SoftReference ref = (SoftReference)classLoaderMap.get(classLoader);
            caller = ref != null ? (SecureCaller)ref.get() : null;
            if (caller == null) {
                try {
                    caller = (SecureCaller)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Class<?> thisClass = this.getClass();
                            ClassLoader effectiveClassLoader = classLoader.loadClass(thisClass.getName()) != thisClass ? thisClass.getClassLoader() : classLoader;
                            SecureClassLoaderImpl secCl = new SecureClassLoaderImpl(effectiveClassLoader);
                            Class c = secCl.defineAndLinkClass((class$com$liferay$mozilla$javascript$SecureCaller == null ? (class$com$liferay$mozilla$javascript$SecureCaller = SecureCaller.class$("com.liferay.mozilla.javascript.SecureCaller")) : class$com$liferay$mozilla$javascript$SecureCaller).getName() + "Impl", secureCallerImplBytecode, codeSource);
                            return c.newInstance();
                        }
                    });
                    classLoaderMap.put(classLoader, new SoftReference<SecureCaller>(caller));
                }
                catch (PrivilegedActionException ex) {
                    throw new UndeclaredThrowableException(ex.getCause());
                }
            }
        }
        return caller.call(callable, cx, scope, thisObj, args);
    }

    private static byte[] loadBytecode() {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecureCaller.loadBytecodePrivileged();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] loadBytecodePrivileged() {
        URL url = (class$com$liferay$mozilla$javascript$SecureCaller == null ? (class$com$liferay$mozilla$javascript$SecureCaller = SecureCaller.class$("com.liferay.mozilla.javascript.SecureCaller")) : class$com$liferay$mozilla$javascript$SecureCaller).getResource("SecureCallerImpl.clazz");
        try {
            InputStream in = url.openStream();
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while (true) {
                    int r;
                    if ((r = in.read()) == -1) {
                        byte[] byArray = bout.toByteArray();
                        return byArray;
                    }
                    bout.write(r);
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SecureClassLoaderImpl
    extends SecureClassLoader {
        SecureClassLoaderImpl(ClassLoader parent) {
            super(parent);
        }

        Class defineAndLinkClass(String name, byte[] bytes, CodeSource cs) {
            Class<?> cl = this.defineClass(name, bytes, 0, bytes.length, cs);
            this.resolveClass(cl);
            return cl;
        }
    }
}

