/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.staging.server;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gcube.portal.custom.communitymanager.components.GCUBELayoutTab;
import org.gcube.portal.custom.communitymanager.components.GCUBEPortlet;
import org.gcube.portal.custom.communitymanager.components.GCUBESiteLayout;
import org.gcube.portal.custom.communitymanager.types.GCUBELayoutType;
import org.gcube.portal.staging.server.PortalStaging;

public class CommunityCreator {
    private static Log _log = LogFactoryUtil.getLog(PortalStaging.class);
    public static final String DEFAULT_COMPANY_WEB_ID = "liferay.com";
    public static final String USERNAME = "test";
    private static CommunityCreator instance = null;
    public static final String DEFAULT_COMMUNITY_NAME = "Data e-Infrastructure gateway";

    protected CommunityCreator() {
    }

    public static CommunityCreator getInstance() {
        if (instance == null) {
            instance = new CommunityCreator();
        }
        return instance;
    }

    private User validateUser(String email) throws PortalException, SystemException {
        Company company = CommunityCreator.getCompany();
        return UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)email);
    }

    public static Company getCompany() throws PortalException, SystemException {
        return CompanyLocalServiceUtil.getCompanyByWebId((String)CommunityCreator.getDefaultCompanyWebId());
    }

    public static String getDefaultCompanyWebId() {
        String defaultWebId = "";
        try {
            defaultWebId = GetterUtil.getString((String)PropsUtil.get((String)"company.default.web.id"));
        }
        catch (NullPointerException e) {
            _log.info((Object)"Cound not find property company.default.web.id in portal.ext file returning default web id: liferay.com");
            return DEFAULT_COMPANY_WEB_ID;
        }
        return defaultWebId;
    }

    protected Group createDefaultCommunity() throws PortalException, SystemException {
        ServiceContext ctx = new ServiceContext();
        _log.info((Object)"Creating Default Community Data e-Infrastructure gateway");
        Group toReturn = GroupServiceUtil.addGroup((String)DEFAULT_COMMUNITY_NAME, (String)"Default Community", (int)1, (String)"/data-e-infrastructure-gateway", (boolean)true, (ServiceContext)ctx);
        _log.info((Object)("GROUP created  id:" + toReturn.getGroupId()));
        this.associateLayout(toReturn, DEFAULT_COMMUNITY_NAME, "desc", 0L);
        _log.info((Object)"Layout Associated correctly for Data e-Infrastructure gateway");
        return toReturn;
    }

    public long associateLayout(Group group, String communityName, String communityDesc, long parentID) throws PortalException, SystemException {
        String email = "test@" + CommunityCreator.getCompany().getWebId();
        GCUBESiteLayout siteLayout = new GCUBESiteLayout(communityName, email);
        siteLayout.addTab(new GCUBELayoutTab("Home", GCUBELayoutType.ONE_COL, this.getGCUBELoginPorlet()));
        this.createLayout(group, this.validateUser(email), siteLayout);
        return 1L;
    }

    private List<GCUBEPortlet> getGCUBELoginPorlet() {
        ArrayList<GCUBEPortlet> toReturn = new ArrayList<GCUBEPortlet>();
        toReturn.add(new GCUBEPortlet("gCube Login", this.getLPortletName("gCubeLogin")));
        return toReturn;
    }

    private String getLPortletName(String gCubePorletName) {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = String.valueOf(System.getenv("CATALINA_HOME")) + "/conf/gcube-portlets.properties";
            _log.info((Object)("Loading gCube-portlets list from " + propertyfile));
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty(gCubePorletName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private long createLayout(Group group, User user, GCUBESiteLayout siteLayout) throws PortalException, SystemException {
        Layout layout = null;
        for (GCUBELayoutTab tab : siteLayout.getTabs()) {
            String layoutName = siteLayout.getName().replaceAll(" ", "-");
            String friendlyURL = "/" + tab.getCaption().replaceAll(" ", "-");
            _log.debug((Object)("Trying creating layout " + layoutName + " url:" + friendlyURL + " userid:" + user.getUserId() + " groupid:" + group.getGroupId()));
            ServiceContext ctx = new ServiceContext();
            layout = LayoutLocalServiceUtil.addLayout((long)user.getUserId(), (long)group.getGroupId(), (boolean)true, (long)0L, (String)tab.getCaption(), (String)layoutName, (String)group.getDescription(), (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)ctx);
            _log.debug((Object)("Trying creating tab " + tab.getCaption()));
            String typeSettings = tab.getLayoutTypeSettings();
            layout.setTypeSettings(typeSettings);
            LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
            _log.debug((Object)("Added tab " + tab.getCaption() + " to layout for community: " + siteLayout.getName()));
            for (GCUBEPortlet gPortlet : tab.getPortlets()) {
                long companyId = CommunityCreator.getCompany().getCompanyId();
                Portlet lPortlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)gPortlet.getPortletId());
                long ownerId = 0L;
                int ownerType = 3;
                String portletPreferencesString = "<portlet-preferences><preference><name>lfr-wap-initial-window-state</name><value>NORMAL</value></preference><preference><name>portlet-setup-show-borders</name><value>false</value></preference><preference><name>\tportlet-setup-use-custom-title</name><value>false</value></preference></portlet-preferences>";
                PortletPreferencesLocalServiceUtil.addPortletPreferences((long)companyId, (long)ownerId, (int)ownerType, (long)layout.getPlid(), (String)lPortlet.getPortletId(), (Portlet)lPortlet, (String)portletPreferencesString);
                _log.debug((Object)("Added Preference for portlet " + lPortlet.getPortletName() + " for layout plid:" + layout.getPlid()));
            }
        }
        return layout.getLayoutId();
    }
}

