/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.jabsorb.serializer.FixUp;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONRPCResult {
    public static final int CODE_SUCCESS = 0;
    public static final int CODE_REMOTE_EXCEPTION = 490;
    public static final int CODE_ERR_PARSE = 590;
    public static final int CODE_ERR_NOCONSTRUCTOR = 594;
    public static final int CODE_ERR_NOMETHOD = 591;
    public static final int CODE_ERR_UNMARSHALL = 592;
    public static final int CODE_ERR_MARSHALL = 593;
    public static final int CODE_ERR_FIXUP = 594;
    public static final String MSG_ERR_PARSE = "couldn't parse request arguments";
    public static final String MSG_ERR_NOCONSTRUCTOR = "constructor not found";
    public static final String MSG_ERR_NOMETHOD = "method with the requested number of arguments not found (session may have timed out)";
    public static final String MSG_ERR_FIXUP = "invalid or unexpected data in fixups";
    private Object result;
    private Object id;
    private List fixUps;
    private int errorCode;

    public JSONRPCResult(int errorCode, Object id, Object o) {
        this.errorCode = errorCode;
        this.id = id;
        this.result = o;
    }

    public JSONRPCResult(int errorCode, Object id, Object o, List fixUps) {
        this.errorCode = errorCode;
        this.id = id;
        this.result = o;
        this.fixUps = fixUps;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Object getId() {
        return this.id;
    }

    public Object getResult() {
        return this.result;
    }

    public String toString() {
        JSONObject o = new JSONObject();
        try {
            if (this.errorCode == 0) {
                o.put("id", this.id);
                o.put("result", this.result);
                if (this.fixUps != null && this.fixUps.size() > 0) {
                    JSONArray fixups = new JSONArray();
                    Iterator i = this.fixUps.iterator();
                    while (i.hasNext()) {
                        FixUp fixup = (FixUp)i.next();
                        fixups.put(fixup.toJSONArray());
                    }
                    o.put("fixups", fixups);
                }
            } else if (this.errorCode == 490) {
                o.put("id", this.id);
                if (this.result instanceof Throwable) {
                    Throwable e = (Throwable)this.result;
                    CharArrayWriter caw = new CharArrayWriter();
                    e.printStackTrace(new PrintWriter(caw));
                    JSONObject err = new JSONObject();
                    err.put("code", new Integer(this.errorCode));
                    err.put("msg", e.getMessage());
                    err.put("trace", caw.toString());
                    o.put("error", err);
                } else {
                    o.put("error", this.result);
                }
            } else {
                JSONObject err = new JSONObject();
                err.put("code", new Integer(this.errorCode));
                err.put("msg", this.result);
                o.put("id", this.id);
                o.put("error", err);
            }
        }
        catch (JSONException e) {
            throw (RuntimeException)new RuntimeException(e.getMessage()).initCause(e);
        }
        return o.toString();
    }
}

