/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.pool.core;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import uk.org.primrose.Logger;
import uk.org.primrose.Util;
import uk.org.primrose.pool.core.ConnectionHolder;
import uk.org.primrose.pool.core.Pool;
import uk.org.primrose.pool.core.PoolConfigImpl;
import uk.org.primrose.pool.core.PoolMonitor;

public class PoolData
extends PoolConfigImpl {
    public static final int UNKNOWN_STATUS_CODE = -1;
    public static final int CONNECTION_ACTIVE = 1;
    public static final int CONNECTION_INACTIVE = 2;
    public static final int CONNECTION_DUMPED = 3;
    public static final int CONNECTION_CLOSING = 4;
    public static final int ON_CLOSE_SHOULD_DIE = 14;
    public static final int ON_CLOSE_SHOULD_REUSE = 15;
    protected long gid = 0L;
    Vector<ConnectionHolder> connections = null;
    boolean poolAccessLocked = false;
    protected PoolLock lock = null;
    protected int numberOfWaitingThreads = 0;
    protected int totalConnectionsHandedOut = 0;
    PoolMonitor monitor = null;
    protected Logger logger = null;
    Pool failoverPoolObj = null;
    FailoverCutBack failoverCutBackObj = null;
    boolean bPoolHasBeenShutdown = false;

    protected void setUpLogger() {
        this.logger = new Logger();
        if (this.log != null && this.log.length() > 0) {
            try {
                this.logger.setEmailDetails(this.emailEvents, this.adminEmail, this.smtpMailExchangeServer, this.smtpMailExchangeServerPort, this.poolName);
                this.logger.setLogLevel(this.logLevel);
                this.logger.setLogWriter(this.log);
            }
            catch (IOException ioe) {
                System.out.println("Primrose cannot write to log file : " + this.log);
                ioe.printStackTrace();
            }
        }
    }

    public int getNumberOfWaitingThreads() {
        return this.numberOfWaitingThreads;
    }

    public int getTotalConnectionsHandedOut() {
        return this.totalConnectionsHandedOut;
    }

    public static String getStringStatus(int i) {
        if (i == 1) {
            return "CONNECTION_ACTIVE";
        }
        if (i == 2) {
            return "CONNECTION_INACTIVE";
        }
        if (i == 3) {
            return "CONNECTION_DUMPED";
        }
        if (i == 4) {
            return "CONNECTION_CLOSING";
        }
        if (i == 14) {
            return "ON_CLOSE_SHOULD_DIE";
        }
        if (i == 15) {
            return "ON_CLOSE_SHOULD_REUSE";
        }
        if (i == -1) {
            return "UNKNOWN_STATUS_CODE";
        }
        return "UNKNOWN_STATUS_CODE";
    }

    public int numberOfFreeConnections() {
        this.logger.verbose("START");
        int n = 0;
        for (ConnectionHolder ch : this.connections) {
            if (ch.status != 2) continue;
            this.logger.verbose("INACTIVE");
            ++n;
        }
        return n;
    }

    public int numberOfActiveConnections() {
        int n = 0;
        for (ConnectionHolder ch : this.connections) {
            if (ch.status != 1) continue;
            ++n;
        }
        return n;
    }

    protected void setInternalConnectionTransactionIsolation(String sConnectionTransactionIsolation) {
        if (sConnectionTransactionIsolation == null) {
            try {
                Connection c = Util.getConnection(this.logger, this.driverClass, this.driverURL, this.user, this.password);
                if (c == null) {
                    this.logger.warn("[Pool@" + this.poolName + "] setConnectionTransactionIsolation() : DB is down/not reachable, and because the pool config variable 'connectionTransactionLevel' is not set, it will be set when the db comes back up and the next call for a connection is made.");
                    this.iConnectionTransactionIsolation = -1;
                    return;
                }
                this.iConnectionTransactionIsolation = c.getTransactionIsolation();
                c.close();
            }
            catch (Throwable t) {
                this.logger.printStackTrace(t);
            }
        } else if (sConnectionTransactionIsolation.equalsIgnoreCase("TRANSACTION_NONE")) {
            this.iConnectionTransactionIsolation = 0;
        } else if (sConnectionTransactionIsolation.equalsIgnoreCase("TRANSACTION_READ_COMMITTED")) {
            this.iConnectionTransactionIsolation = 2;
        } else if (sConnectionTransactionIsolation.equalsIgnoreCase("TRANSACTION_READ_UNCOMMITTED")) {
            this.iConnectionTransactionIsolation = 1;
        } else if (sConnectionTransactionIsolation.equalsIgnoreCase("TRANSACTION_REPEATABLE_READ")) {
            this.iConnectionTransactionIsolation = 4;
        } else if (sConnectionTransactionIsolation.equalsIgnoreCase("TRANSACTION_SERIALIZABLE")) {
            this.iConnectionTransactionIsolation = 8;
        } else {
            this.logger.warn("[Pool@" + this.poolName + "] setConnectionTransactionIsolation() : Do not recognize transaction level of '" + sConnectionTransactionIsolation + "', using driver default");
            try {
                Connection c = Util.getConnection(this.logger, this.driverClass, this.driverURL, this.user, this.password);
                this.iConnectionTransactionIsolation = c.getTransactionIsolation();
                c.close();
            }
            catch (Throwable t) {
                this.logger.printStackTrace(t);
            }
        }
        this.logger.verbose("[Pool@" + this.poolName + "] setConnectionTransactionIsolation() : Set connection transaction level to '" + this.getInternalConnectionTransactionIsolation() + "'");
    }

    protected String getInternalConnectionTransactionIsolation() {
        return this.getInternalConnectionTransactionIsolation(this.iConnectionTransactionIsolation);
    }

    protected String getInternalConnectionTransactionIsolation(int level) {
        String sLevel = "DRIVER_DEFAULT";
        switch (level) {
            case 0: {
                sLevel = "TRANSACTION_NONE";
                break;
            }
            case 2: {
                sLevel = "TRANSACTION_READ_COMMITTED";
                break;
            }
            case 1: {
                sLevel = "TRANSACTION_READ_UNCOMMITTED";
                break;
            }
            case 4: {
                sLevel = "TRANSACTION_REPEATABLE_READ";
                break;
            }
            case 8: {
                sLevel = "TRANSACTION_SERIALIZABLE";
            }
        }
        return sLevel;
    }

    class FailoverCutBack
    extends Thread {
        Pool pool = null;
        Logger logger = null;
        boolean bKeepRunning = true;

        public FailoverCutBack(Pool pool, Logger logger) {
            this.pool = pool;
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.bKeepRunning) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                Connection c = null;
                Statement s = null;
                ResultSet rs = null;
                try {
                    c = Util.getConnection(this.logger, PoolData.this.driverClass, PoolData.this.driverURL, PoolData.this.user, PoolData.this.password);
                    s = c.createStatement();
                    rs = s.executeQuery(PoolData.this.onExceptionCheckSQL);
                    this.logger.info("[FailoverCutBack@" + this.pool.getPoolName() + "] FailoverCutBack has determined that the original DB is back up ... informing pool to cut back");
                    this.pool.cutbackFromFailoverPool();
                    this.bKeepRunning = false;
                }
                catch (Throwable t) {}
                continue;
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException sqle2) {}
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    catch (SQLException sqle2) {}
                    try {
                        if (c == null) continue;
                        c.close();
                    }
                    catch (SQLException sqle2) {}
                }
            }
        }

        public void stopIt() {
            this.bKeepRunning = false;
        }
    }

    class PoolLock {
        PoolLock() {
        }
    }
}

