/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.filter;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import jodd.io.FastByteArrayOutputStream;

public class ByteArrayOutputStreamWrapper
extends ServletOutputStream {
    protected OutputStream intStream;
    protected FastByteArrayOutputStream baStream;
    protected boolean finallized;
    protected boolean flushOnFinalizeOnly = true;

    public ByteArrayOutputStreamWrapper(OutputStream outStream) {
        this.intStream = outStream;
        this.baStream = new FastByteArrayOutputStream();
    }

    public ByteArrayOutputStreamWrapper() {
        this.intStream = System.out;
        this.baStream = new FastByteArrayOutputStream();
    }

    public FastByteArrayOutputStream getByteArrayStream() {
        return this.baStream;
    }

    public void setFinallized() {
        this.finallized = true;
    }

    public boolean isFinallized() {
        return this.finallized;
    }

    public void write(int i) throws IOException {
        this.baStream.write(i);
    }

    public void close() throws IOException {
        if (this.finallized) {
            this.processStream();
            this.intStream.close();
        }
    }

    public void reset() {
        this.baStream.reset();
    }

    public void flush() throws IOException {
        if (this.baStream.size() != 0 && (!this.flushOnFinalizeOnly || this.finallized)) {
            this.processStream();
            this.baStream = new FastByteArrayOutputStream();
        }
    }

    protected void processStream() throws IOException {
        this.intStream.write(this.baStream.toByteArray());
        this.intStream.flush();
    }

    public void clear() {
        this.baStream = new FastByteArrayOutputStream();
    }
}

