/*
 * Decompiled with CFR 0.152.
 */
package jodd.datetime;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import jodd.datetime.DateTimeStamp;
import jodd.datetime.converter.CalendarConverter;
import jodd.datetime.converter.DateConverter;
import jodd.datetime.converter.DateTimeStampConverter;
import jodd.datetime.converter.GregorianCalendarConverter;
import jodd.datetime.converter.JdtConverter;
import jodd.datetime.converter.SqlDateConverter;
import jodd.datetime.converter.SqlTimestampConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtConverterManager {
    private static Map<Class, JdtConverter> converters = new HashMap<Class, JdtConverter>();

    public static void unregisterAll() {
        converters.clear();
    }

    public static void registerDefaults() {
        JdtConverterManager.register(DateTimeStamp.class, new DateTimeStampConverter());
        JdtConverterManager.register(Calendar.class, new CalendarConverter());
        JdtConverterManager.register(GregorianCalendar.class, new GregorianCalendarConverter());
        JdtConverterManager.register(Date.class, new DateConverter());
        JdtConverterManager.register(java.sql.Date.class, new SqlDateConverter());
        JdtConverterManager.register(Timestamp.class, new SqlTimestampConverter());
    }

    public static <T> void register(Class<T> type, JdtConverter<T> converter) {
        converters.put(type, converter);
    }

    public static void unregister(Class type) {
        converters.remove(type);
    }

    public static <T> JdtConverter<T> lookup(Class<T> type) {
        return converters.get(type);
    }

    public static JdtConverter lookup(Object source) {
        JdtConverter<Object> converter = JdtConverterManager.lookup(source.getClass());
        if (converter == null) {
            for (Class key : converters.keySet()) {
                if (!key.isInstance(source)) continue;
                converter = JdtConverterManager.lookup(key);
                break;
            }
        }
        return converter;
    }

    static {
        JdtConverterManager.registerDefaults();
    }
}

