/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.util.Properties;
import java.util.logging.Logger;
import net.sf.ehcache.distribution.jgroups.JGroupsCacheReplicator;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.util.PropertyUtil;

public class JGroupsCacheReplicatorFactory
extends CacheEventListenerFactory {
    private static final String ASYNCHRONOUS_REPLICATION_INTERVAL_MILLIS = "asynchronousReplicationIntervalMillis";
    private static final Logger LOG = Logger.getLogger(JGroupsCacheReplicatorFactory.class.getName());
    private static final String REPLICATE_PUTS = "replicatePuts";
    private static final String REPLICATE_UPDATES = "replicateUpdates";
    private static final String REPLICATE_UPDATES_VIA_COPY = "replicateUpdatesViaCopy";
    private static final String REPLICATE_REMOVALS = "replicateRemovals";
    private static final String REPLICATE_ASYNCHRONOUSLY = "replicateAsynchronously";

    public CacheEventListener createCacheEventListener(Properties properties) {
        LOG.fine("making new cache rep");
        boolean replicatePuts = this.extractBooleanProperty(properties, REPLICATE_PUTS, true);
        boolean replicateUpdates = this.extractBooleanProperty(properties, REPLICATE_UPDATES, true);
        boolean replicateUpdatesViaCopy = this.extractBooleanProperty(properties, REPLICATE_UPDATES_VIA_COPY, false);
        boolean replicateRemovals = this.extractBooleanProperty(properties, REPLICATE_REMOVALS, true);
        boolean replicateAsync = this.extractBooleanProperty(properties, REPLICATE_ASYNCHRONOUSLY, true);
        long asyncTime = this.extractAsynchronousReplicationIntervalMillis(properties, ASYNCHRONOUS_REPLICATION_INTERVAL_MILLIS, 1000L);
        JGroupsCacheReplicator r = new JGroupsCacheReplicator(replicatePuts, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals, replicateAsync);
        if (replicateAsync) {
            r.setAsynchronousReplicationInterval(asyncTime);
        }
        return r;
    }

    protected long extractAsynchronousReplicationIntervalMillis(Properties properties, String propertyName, long defaultValue) {
        String parsedString = PropertyUtil.extractAndLogProperty((String)propertyName, (Properties)properties);
        if (parsedString != null) {
            try {
                Long longValue = new Long(parsedString);
                return longValue;
            }
            catch (NumberFormatException e) {
                LOG.warning("Number format exception trying to set asynchronousReplicationIntervalMillis. Using the default instead. String value was: '" + parsedString + "'");
            }
        }
        return defaultValue;
    }

    protected boolean extractBooleanProperty(Properties properties, String propertyName, boolean defaultValue) {
        String booleanCandidate = PropertyUtil.extractAndLogProperty((String)propertyName, (Properties)properties);
        if (booleanCandidate != null) {
            return PropertyUtil.parseBoolean((String)booleanCandidate);
        }
        return defaultValue;
    }
}

