/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.activation.MimeType;
import org.apache.abdera.i18n.rfc4646.Lang;
import org.apache.abdera.i18n.text.CharUtils;
import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.i18n.text.UrlEncoding;
import org.apache.abdera.protocol.Request;
import org.apache.abdera.protocol.util.AbstractRequest;
import org.apache.abdera.protocol.util.CacheControlUtil;
import org.apache.abdera.protocol.util.EncodingUtil;
import org.apache.abdera.util.EntityTag;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestOptions
extends AbstractRequest
implements Request {
    private boolean noLocalCache = false;
    private boolean revalidateAuth = false;
    private boolean useChunked = false;
    private boolean usePostOverride = false;
    private boolean requestException4xx = false;
    private boolean requestException5xx = false;
    private boolean useExpectContinue = true;
    private boolean useConditional = true;
    private boolean followRedirects = true;
    private final Map<String, String[]> headers = new HashMap<String, String[]>();

    public RequestOptions() {
    }

    public RequestOptions(Date ifModifiedSince) {
        this();
        this.setIfModifiedSince(ifModifiedSince);
    }

    public RequestOptions(String ifNoneMatch) {
        this();
        this.setIfNoneMatch(ifNoneMatch);
    }

    public RequestOptions(String ... ifNoneMatch) {
        this();
        this.setIfNoneMatch(ifNoneMatch);
    }

    public RequestOptions(Date ifModifiedSince, String ifNoneMatch) {
        this();
        this.setIfModifiedSince(ifModifiedSince);
        this.setIfNoneMatch(ifNoneMatch);
    }

    public RequestOptions(Date ifModifiedSince, String ... ifNoneMatch) {
        this();
        this.setIfModifiedSince(ifModifiedSince);
        this.setIfNoneMatch(ifNoneMatch);
    }

    public RequestOptions(boolean no_cache) {
        this();
        this.setNoCache(no_cache);
    }

    private Map<String, String[]> getHeaders() {
        return this.headers;
    }

    private String combine(String ... values) {
        StringBuilder v = new StringBuilder();
        for (String val : values) {
            if (v.length() > 0) {
                v.append(", ");
            }
            v.append(val);
        }
        return v.toString();
    }

    public boolean getUseLocalCache() {
        return !this.noLocalCache;
    }

    public RequestOptions setUseLocalCache(boolean use_cache) {
        this.noLocalCache = !use_cache;
        return this;
    }

    public RequestOptions setContentType(String value) {
        return this.setHeader("Content-Type", value);
    }

    public RequestOptions setContentLocation(String iri) {
        return this.setHeader("Content-Location", iri);
    }

    public RequestOptions setContentType(MimeType value) {
        return this.setHeader("Content-Type", value.toString());
    }

    public RequestOptions setAuthorization(String auth) {
        return this.setHeader("Authorization", auth);
    }

    public RequestOptions setEncodedHeader(String header, String charset, String value) {
        return this.setHeader(header, EncodingUtil.encode(value, charset));
    }

    public RequestOptions setEncodedHeader(String header, String charset, String ... values) {
        if (values != null && values.length > 0) {
            for (int n = 0; n < values.length; ++n) {
                values[n] = EncodingUtil.encode(values[n], charset);
            }
            this.getHeaders().put(header, new String[]{this.combine(values)});
        } else {
            this.removeHeaders(header);
        }
        return this;
    }

    public RequestOptions setHeader(String header, String value) {
        return value != null ? this.setHeader(header, new String[]{value}) : this.removeHeaders(header);
    }

    public RequestOptions setHeader(String header, String ... values) {
        if (values != null && values.length > 0) {
            this.getHeaders().put(header, new String[]{this.combine(values)});
        } else {
            this.removeHeaders(header);
        }
        return this;
    }

    public RequestOptions setDateHeader(String header, Date value) {
        return value != null ? this.setHeader(header, DateUtil.formatDate((Date)value)) : this.removeHeaders(header);
    }

    public RequestOptions addEncodedHeader(String header, String charset, String value) {
        return this.addHeader(header, EncodingUtil.encode(value, charset));
    }

    public RequestOptions addEncodedHeader(String header, String charset, String ... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        for (int n = 0; n < values.length; ++n) {
            values[n] = EncodingUtil.encode(values[n], charset);
        }
        List<Object> list = Arrays.asList((Object[])this.getHeaders().get(header));
        String value = this.combine(values);
        if (list != null) {
            if (!list.contains(value)) {
                list.add(value);
            }
        } else {
            this.setHeader(header, new String[]{value});
        }
        return this;
    }

    public RequestOptions addHeader(String header, String value) {
        if (value != null) {
            this.addHeader(header, new String[]{value});
        }
        return this;
    }

    public RequestOptions addHeader(String header, String ... values) {
        if (values == null || values.length == 0) {
            return this;
        }
        List<Object> list = Arrays.asList((Object[])this.getHeaders().get(header));
        String value = this.combine(values);
        if (list != null) {
            if (!list.contains(value)) {
                list.add(value);
            }
        } else {
            this.setHeader(header, new String[]{value});
        }
        return this;
    }

    public RequestOptions addDateHeader(String header, Date value) {
        if (value == null) {
            return this;
        }
        return this.addHeader(header, DateUtil.formatDate((Date)value));
    }

    @Override
    public String getHeader(String header) {
        String[] list = this.getHeaders().get(header);
        return list != null && list.length > 0 ? list[0] : null;
    }

    public String[] getHeaders(String header) {
        return this.getHeaders().get(header);
    }

    @Override
    public Date getDateHeader(String header) {
        String val = this.getHeader(header);
        try {
            return val != null ? DateUtil.parseDate((String)val) : null;
        }
        catch (DateParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] getHeaderNames() {
        Set<String> names = this.getHeaders().keySet();
        return names.toArray(new String[names.size()]);
    }

    public RequestOptions setIfMatch(String entity_tag) {
        return this.setIfMatch(new EntityTag(entity_tag));
    }

    public RequestOptions setIfMatch(EntityTag entity_tag) {
        return this.setHeader("If-Match", entity_tag.toString());
    }

    public RequestOptions setIfMatch(EntityTag ... entity_tags) {
        return this.setHeader("If-Match", EntityTag.toString(entity_tags));
    }

    public RequestOptions setIfMatch(String ... entity_tags) {
        return this.setHeader("If-Match", EntityTag.toString(entity_tags));
    }

    public RequestOptions setIfNoneMatch(String entity_tag) {
        return this.setIfNoneMatch(new EntityTag(entity_tag));
    }

    public RequestOptions setIfNoneMatch(EntityTag entity_tag) {
        return this.setHeader("If-None-Match", entity_tag.toString());
    }

    public RequestOptions setIfNoneMatch(EntityTag ... entity_tags) {
        return this.setHeader("If-None-Match", EntityTag.toString(entity_tags));
    }

    public RequestOptions setIfNoneMatch(String ... entity_tags) {
        return this.setHeader("If-None-Match", EntityTag.toString(entity_tags));
    }

    public RequestOptions setIfModifiedSince(Date date) {
        return this.setDateHeader("If-Modified-Since", date);
    }

    public RequestOptions setIfUnmodifiedSince(Date date) {
        return this.setDateHeader("If-Unmodified-Since", date);
    }

    public RequestOptions setAccept(String accept) {
        return this.setAccept(new String[]{accept});
    }

    public RequestOptions setAccept(String ... accept) {
        return this.setHeader("Accept", this.combine(accept));
    }

    public RequestOptions setAcceptLanguage(Locale locale) {
        return this.setAcceptLanguage(Lang.fromLocale(locale));
    }

    public RequestOptions setAcceptLanguage(Locale ... locales) {
        String[] langs = new String[locales.length];
        for (int n = 0; n < locales.length; ++n) {
            langs[n] = Lang.fromLocale(locales[n]);
        }
        this.setAcceptLanguage(langs);
        return this;
    }

    public RequestOptions setAcceptLanguage(String accept) {
        return this.setAcceptLanguage(new String[]{accept});
    }

    public RequestOptions setAcceptLanguage(String ... accept) {
        return this.setHeader("Accept-Language", this.combine(accept));
    }

    public RequestOptions setAcceptCharset(String accept) {
        return this.setAcceptCharset(new String[]{accept});
    }

    public RequestOptions setAcceptCharset(String ... accept) {
        return this.setHeader("Accept-Charset", this.combine(accept));
    }

    public RequestOptions setAcceptEncoding(String accept) {
        return this.setAcceptEncoding(new String[]{accept});
    }

    public RequestOptions setAcceptEncoding(String ... accept) {
        return this.setHeader("Accept-Encoding", this.combine(accept));
    }

    public RequestOptions setSlug(String slug) {
        if (slug.indexOf(10) > -1 || slug.indexOf(13) > -1) {
            throw new IllegalArgumentException(Localizer.get("SLUG.BAD.CHARACTERS"));
        }
        return this.setHeader("Slug", UrlEncoding.encode((CharSequence)slug, CharUtils.Profile.ASCIISANSCRLF.filter()));
    }

    public RequestOptions setCacheControl(String cc) {
        CacheControlUtil.parseCacheControl(cc, this);
        return this;
    }

    public RequestOptions removeHeaders(String name) {
        this.getHeaders().remove(name);
        return this;
    }

    @Override
    public String getCacheControl() {
        return CacheControlUtil.buildCacheControl(this);
    }

    public boolean getRevalidateWithAuth() {
        return this.revalidateAuth;
    }

    public RequestOptions setRevalidateWithAuth(boolean revalidateAuth) {
        this.revalidateAuth = revalidateAuth;
        return this;
    }

    public boolean isUseChunked() {
        return this.useChunked;
    }

    public RequestOptions setUseChunked(boolean useChunked) {
        this.useChunked = useChunked;
        return this;
    }

    public RequestOptions setUsePostOverride(boolean useOverride) {
        this.usePostOverride = useOverride;
        return this;
    }

    public boolean isUsePostOverride() {
        return this.usePostOverride;
    }

    public RequestOptions set4xxRequestException(boolean v) {
        this.requestException4xx = v;
        return this;
    }

    public boolean is4xxRequestException() {
        return this.requestException4xx;
    }

    public RequestOptions set5xxRequestException(boolean v) {
        this.requestException5xx = v;
        return this;
    }

    public boolean is5xxRequestException() {
        return this.requestException5xx;
    }

    public RequestOptions setUseExpectContinue(boolean useExpect) {
        this.useExpectContinue = useExpect;
        return this;
    }

    public boolean isUseExpectContinue() {
        return this.useExpectContinue;
    }

    public boolean isConditionalPut() {
        return this.useConditional;
    }

    public RequestOptions setConditionalPut(boolean conditional) {
        this.useConditional = conditional;
        return this;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public RequestOptions setFollowRedirects(boolean followredirects) {
        this.followRedirects = followredirects;
        return this;
    }
}

