/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public class ServerDetector {
    public static final String GERONIMO_ID = "geronimo";
    public static final String GLASSFISH_ID = "glassfish";
    public static final String JBOSS_ID = "jboss";
    public static final String JETTY_ID = "jetty";
    public static final String JONAS_ID = "jonas";
    public static final String OC4J_ID = "oc4j";
    public static final String RESIN_ID = "resin";
    public static final String TOMCAT_ID = "tomcat";
    public static final String WEBLOGIC_ID = "weblogic";
    public static final String WEBSPHERE_ID = "websphere";
    private static Log _log = LogFactoryUtil.getLog(ServerDetector.class);
    private static ServerDetector _instance = new ServerDetector();
    private String _serverId;
    private boolean _geronimo;
    private boolean _glassfish;
    private boolean _jBoss;
    private boolean _jetty;
    private boolean _jonas;
    private boolean _oc4j;
    private boolean _resin;
    private boolean _supportsComet;
    private boolean _tomcat;
    private boolean _webLogic;
    private boolean _webSphere;

    public static String getServerId() {
        return ServerDetector._instance._serverId;
    }

    public static boolean isGeronimo() {
        return ServerDetector._instance._geronimo;
    }

    public static boolean isGlassfish() {
        return ServerDetector._instance._glassfish;
    }

    public static boolean isJBoss() {
        return ServerDetector._instance._jBoss;
    }

    public static boolean isJetty() {
        return ServerDetector._instance._jetty;
    }

    public static boolean isJOnAS() {
        return ServerDetector._instance._jonas;
    }

    public static boolean isOC4J() {
        return ServerDetector._instance._oc4j;
    }

    public static boolean isResin() {
        return ServerDetector._instance._resin;
    }

    public static boolean isSupportsComet() {
        return ServerDetector._instance._supportsComet;
    }

    public static boolean isTomcat() {
        return ServerDetector._instance._tomcat;
    }

    public static boolean isWebLogic() {
        return ServerDetector._instance._webLogic;
    }

    public static boolean isWebSphere() {
        return ServerDetector._instance._webSphere;
    }

    private ServerDetector() {
        if (this._isGeronimo()) {
            this._serverId = GERONIMO_ID;
            this._geronimo = true;
        } else if (this._isGlassfish()) {
            this._serverId = GLASSFISH_ID;
            this._glassfish = true;
        } else if (this._isJBoss()) {
            this._serverId = JBOSS_ID;
            this._jBoss = true;
        } else if (this._isJOnAS()) {
            this._serverId = JONAS_ID;
            this._jonas = true;
        } else if (this._isOC4J()) {
            this._serverId = OC4J_ID;
            this._oc4j = true;
        } else if (this._isResin()) {
            this._serverId = RESIN_ID;
            this._resin = true;
        } else if (this._isWebLogic()) {
            this._serverId = WEBLOGIC_ID;
            this._webLogic = true;
        } else if (this._isWebSphere()) {
            this._serverId = WEBSPHERE_ID;
            this._webSphere = true;
        }
        if (this._isJetty()) {
            if (this._serverId == null) {
                this._serverId = JETTY_ID;
                this._jetty = true;
            }
        } else if (this._isTomcat() && this._serverId == null) {
            this._serverId = TOMCAT_ID;
            this._tomcat = true;
        }
        if (System.getProperty("external-properties") == null && _log.isInfoEnabled()) {
            if (this._serverId != null) {
                _log.info("Detected server " + this._serverId);
            } else {
                _log.info("No server detected");
            }
        }
    }

    private boolean _detect(String className) {
        try {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            systemClassLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> classObj = this.getClass();
            return classObj.getResource(className) != null;
        }
    }

    private boolean _isGeronimo() {
        return this._detect("/org/apache/geronimo/system/main/Daemon.class");
    }

    private boolean _isGlassfish() {
        String value = System.getProperty("com.sun.aas.instanceRoot");
        return value != null;
    }

    private boolean _isJBoss() {
        return this._detect("/org/jboss/Main.class");
    }

    private boolean _isJetty() {
        return this._detect("/org/mortbay/jetty/Server.class");
    }

    private boolean _isJOnAS() {
        boolean jonas = this._detect("/org/objectweb/jonas/server/Server.class");
        if (!this._jonas && System.getProperty("jonas.root") != null) {
            jonas = true;
        }
        return jonas;
    }

    private boolean _isOC4J() {
        return this._detect("oracle.oc4j.util.ClassUtils");
    }

    private boolean _isResin() {
        return this._detect("/com/caucho/server/resin/Resin.class");
    }

    private boolean _isTomcat() {
        boolean tomcat = this._detect("/org/apache/catalina/startup/Bootstrap.class");
        if (!tomcat) {
            tomcat = this._detect("/org/apache/catalina/startup/Embedded.class");
        }
        return tomcat;
    }

    private boolean _isWebLogic() {
        return this._detect("/weblogic/Server.class");
    }

    private boolean _isWebSphere() {
        return this._detect("/com/ibm/websphere/product/VersionInfo.class");
    }
}

