/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBackedSet<E>
extends AbstractSet<E>
implements Serializable {
    private final Map<E, Boolean> _backedMap;
    private transient Set<E> _backedMapKeySet;

    public MapBackedSet(Map<E, Boolean> backedMap) {
        if (!backedMap.isEmpty()) {
            throw new IllegalArgumentException("Map is not empty");
        }
        this._backedMap = backedMap;
        this._backedMapKeySet = backedMap.keySet();
    }

    @Override
    public boolean add(E element) {
        return this._backedMap.put(element, Boolean.TRUE) == null;
    }

    @Override
    public void clear() {
        this._backedMap.clear();
    }

    @Override
    public boolean contains(Object obj) {
        return this._backedMap.containsKey(obj);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this._backedMapKeySet.containsAll(collection);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || this._backedMapKeySet.equals(obj);
    }

    @Override
    public int hashCode() {
        return this._backedMapKeySet.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this._backedMap.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this._backedMapKeySet.iterator();
    }

    @Override
    public boolean remove(Object obj) {
        return this._backedMap.remove(obj) != null;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this._backedMapKeySet.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this._backedMapKeySet.retainAll(collection);
    }

    @Override
    public int size() {
        return this._backedMap.size();
    }

    @Override
    public Object[] toArray() {
        return this._backedMapKeySet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this._backedMapKeySet.toArray(array);
    }

    @Override
    public String toString() {
        return this._backedMapKeySet.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this._backedMapKeySet = this._backedMap.keySet();
    }
}

