/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseOpenSearchImpl;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.ratings.model.RatingsStats;
import com.liferay.portlet.ratings.service.RatingsStatsLocalServiceUtil;
import java.util.Date;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public abstract class HitsOpenSearchImpl
extends BaseOpenSearchImpl {
    private static Log _log = LogFactoryUtil.getLog(HitsOpenSearchImpl.class);

    public abstract String getPortletId();

    public abstract String getSearchPath();

    public Summary getSummary(Indexer indexer, Document document, String snippet, PortletURL portletURL) {
        return indexer.getSummary(document, snippet, portletURL);
    }

    public abstract String getTitle(String var1);

    public String search(HttpServletRequest request, long groupId, long userId, String keywords, int startPage, int itemsPerPage, String format) throws SearchException {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            int start = startPage * itemsPerPage - itemsPerPage;
            int end = startPage * itemsPerPage;
            SearchContext searchContext = SearchContextFactory.getInstance(request);
            searchContext.setGroupIds(new long[]{groupId});
            searchContext.setEnd(end);
            searchContext.setKeywords(keywords);
            searchContext.setScopeStrict(false);
            searchContext.setStart(start);
            searchContext.setUserId(userId);
            this.addSearchAttributes(themeDisplay.getCompanyId(), searchContext, keywords);
            Portlet portlet = PortletLocalServiceUtil.getPortletById(themeDisplay.getCompanyId(), this.getPortletId());
            Indexer indexer = portlet.getIndexerInstance();
            Hits results = indexer.search(searchContext);
            String[] queryTerms = results.getQueryTerms();
            int total = results.getLength();
            Object[] values = this.addSearchResults(queryTerms, keywords, startPage, itemsPerPage, total, start, this.getTitle(keywords), this.getSearchPath(), format, themeDisplay);
            com.liferay.portal.kernel.xml.Document doc = (com.liferay.portal.kernel.xml.Document)values[0];
            Element root = (Element)values[1];
            int i = 0;
            while (i < results.getDocs().length) {
                Document result = results.doc(i);
                String portletId = result.get("portletId");
                String snippet = results.snippet(i);
                long resultGroupId = GetterUtil.getLong(result.get("groupId"));
                PortletURL portletURL = this.getPortletURL(request, portletId, resultGroupId);
                Summary summary = this.getSummary(indexer, result, snippet, portletURL);
                String title = summary.getTitle();
                String url = this.getURL(themeDisplay, resultGroupId, result, portletURL);
                Date modifedDate = result.getDate("modified");
                String content = summary.getContent();
                String[] tags = new String[]{};
                Field assetTagNamesField = result.getFields().get("assetTagNames");
                if (assetTagNamesField != null) {
                    tags = assetTagNamesField.getValues();
                }
                double ratings = 0.0;
                String entryClassName = result.get("entryClassName");
                long entryClassPK = GetterUtil.getLong(result.get("entryClassPK"));
                if (Validator.isNotNull(entryClassName) && entryClassPK > 0L) {
                    RatingsStats stats = RatingsStatsLocalServiceUtil.getStats(entryClassName, entryClassPK);
                    ratings = stats.getTotalScore();
                }
                double score = results.score(i);
                this.addSearchResult(root, resultGroupId, entryClassName, entryClassPK, title, url, modifedDate, content, tags, ratings, score, format);
                ++i;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Return\n" + doc.asXML());
            }
            return doc.asXML();
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    protected void addSearchAttributes(long companyId, SearchContext searchContext, String keywords) {
    }

    protected String getURL(ThemeDisplay themeDisplay, long groupId, Document result, PortletURL portletURL) throws Exception {
        return portletURL.toString();
    }
}

