/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.management;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.management.ManageAction;
import com.liferay.portal.kernel.management.ManageActionException;
import com.liferay.portal.kernel.management.PortalManagerUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.model.ClusterGroup;
import java.util.List;

public class ClusterManageActionWrapper
implements ManageAction {
    private ClusterGroup _clusterGroup;
    private ManageAction _manageAction;

    public ClusterManageActionWrapper(ClusterGroup clusterGroup, ManageAction manageAction) {
        this._clusterGroup = clusterGroup;
        this._manageAction = manageAction;
    }

    public void action() throws ManageActionException {
        try {
            this.doAction();
        }
        catch (SystemException se) {
            throw new ManageActionException("Failed to execute cluster manage action", se);
        }
    }

    private void doAction() throws ManageActionException, SystemException {
        MethodHandler manageActionMethodHandler = PortalManagerUtil.createManageActionMethodHandler(this._manageAction);
        ClusterRequest clusterRequest = null;
        if (this._clusterGroup.isWholeCluster()) {
            clusterRequest = ClusterRequest.createMulticastRequest(manageActionMethodHandler);
        } else {
            this.verifyClusterGroup();
            clusterRequest = ClusterRequest.createUnicastRequest(manageActionMethodHandler, this._clusterGroup.getClusterNodeIdsArray());
        }
        ClusterExecutorUtil.execute(clusterRequest);
    }

    private void verifyClusterGroup() throws ManageActionException {
        String[] requiredClusterNodesIds;
        List<ClusterNode> clusterNodes = ClusterExecutorUtil.getClusterNodes();
        String[] stringArray = requiredClusterNodesIds = this._clusterGroup.getClusterNodeIdsArray();
        if (requiredClusterNodesIds.length != 0) {
            String requiredClusterNodeId = stringArray[0];
            for (ClusterNode clusterNode : clusterNodes) {
                String clusterNodeId = clusterNode.getClusterNodeId();
                if (!clusterNodeId.equals(requiredClusterNodeId)) continue;
                clusterNodes.remove(clusterNode);
            }
            throw new ManageActionException("Cluster node " + requiredClusterNodeId + " is not available");
        }
    }
}

