/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Formatter;
import java.util.Locale;

public class UnsyncPrintWriter
extends PrintWriter {
    private static String _LINE_SEPARATOR = System.getProperty("line.separator");
    private boolean _autoFlush;
    private Formatter _formatter;
    private boolean _hasError;
    private Writer _writer;

    public UnsyncPrintWriter(File file) throws IOException {
        this(new FileWriter(file), false);
    }

    public UnsyncPrintWriter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file), csn), false);
    }

    public UnsyncPrintWriter(OutputStream outputStream) {
        this(outputStream, false);
    }

    public UnsyncPrintWriter(OutputStream outputStream, boolean autoFlush) {
        this(new OutputStreamWriter(outputStream), autoFlush);
    }

    public UnsyncPrintWriter(String fileName) throws IOException {
        this(new FileWriter(fileName), false);
    }

    public UnsyncPrintWriter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), csn), false);
    }

    public UnsyncPrintWriter(Writer writer) {
        this(writer, false);
    }

    public UnsyncPrintWriter(Writer writer, boolean autoFlush) {
        super(writer);
        this._writer = writer;
        this._autoFlush = autoFlush;
    }

    public PrintWriter append(char c) {
        this.write(c);
        return this;
    }

    public PrintWriter append(CharSequence charSequence) {
        if (charSequence == null) {
            this.write("null");
        } else {
            this.write(charSequence.toString());
        }
        return this;
    }

    public PrintWriter append(CharSequence charSequence, int start, int end) {
        if (charSequence == null) {
            charSequence = "null";
        }
        this.write(charSequence.subSequence(start, end).toString());
        return this;
    }

    public boolean checkError() {
        if (this._writer != null) {
            this.flush();
        }
        return this._hasError;
    }

    public void close() {
        try {
            if (this._writer == null) {
                return;
            }
            this._writer.close();
            this._writer = null;
        }
        catch (IOException iOException) {
            this._hasError = true;
        }
    }

    public void flush() {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                this._writer.flush();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
    }

    public PrintWriter format(Locale locale, String format, Object ... arguments) {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                if (this._formatter == null || this._formatter.locale() != locale) {
                    this._formatter = new Formatter(this, locale);
                }
                this._formatter.format(locale, format, arguments);
                if (this._autoFlush) {
                    this._writer.flush();
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread currentThread = Thread.currentThread();
                currentThread.interrupt();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
        return this;
    }

    public PrintWriter format(String format, Object ... arguments) {
        return this.format(Locale.getDefault(), format, arguments);
    }

    public void print(boolean b) {
        if (b) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(char[] charArray) {
        this.write(charArray);
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public PrintWriter printf(Locale locale, String format, Object ... arguments) {
        return this.format(locale, format, arguments);
    }

    public PrintWriter printf(String format, Object ... arguments) {
        return this.format(format, arguments);
    }

    public void println() {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                this._writer.write(_LINE_SEPARATOR);
                if (this._autoFlush) {
                    this._writer.flush();
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread currentThread = Thread.currentThread();
                currentThread.interrupt();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
    }

    public void println(boolean b) {
        this.print(b);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(char[] charArray) {
        this.print(charArray);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(int i) {
        this.print(i);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(Object object) {
        this.print(object);
        this.println();
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }

    public void write(char[] charArray) {
        this.write(charArray, 0, charArray.length);
    }

    public void write(char[] charArray, int offset, int length) {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                this._writer.write(charArray, offset, length);
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread currentThread = Thread.currentThread();
                currentThread.interrupt();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
    }

    public void write(int c) {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                this._writer.write(c);
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread currentThread = Thread.currentThread();
                currentThread.interrupt();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
    }

    public void write(String string) {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                this._writer.write(string);
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread currentThread = Thread.currentThread();
                currentThread.interrupt();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
    }

    public void write(String string, int offset, int length) {
        if (this._writer == null) {
            this._hasError = true;
        } else {
            try {
                this._writer.write(string, offset, length);
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread currentThread = Thread.currentThread();
                currentThread.interrupt();
            }
            catch (IOException iOException) {
                this._hasError = true;
            }
        }
    }
}

