/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CompeteLatch {
    private Sync _sync = new Sync();

    public void await() throws InterruptedException {
        this._sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this._sync.tryAcquireSharedNanos(1, timeUnit.toNanos(timeout));
    }

    public boolean compete() {
        return this._sync._tryInitAcquireShared();
    }

    public boolean done() {
        return this._sync.releaseShared(1);
    }

    public boolean isLocked() {
        return this._sync._isLocked();
    }

    private class Sync
    extends AbstractQueuedSynchronizer {
        private Sync() {
        }

        protected int tryAcquireShared(int arg) {
            if (this.getState() == 0) {
                return 1;
            }
            return -1;
        }

        protected boolean tryReleaseShared(int arg) {
            return this.compareAndSetState(1, 0);
        }

        private boolean _isLocked() {
            return this.getState() == 1;
        }

        private boolean _tryInitAcquireShared() {
            return this.compareAndSetState(0, 1);
        }
    }
}

