/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.documentlibrary.service.DLServiceUtil;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.persistence.WikiNodeUtil;
import com.liferay.portlet.wiki.service.persistence.WikiPageUtil;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import com.liferay.portlet.wiki.util.comparator.PageVersionComparator;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class WikiPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "wiki";
    private static PortletDataHandlerBoolean _attachments = new PortletDataHandlerBoolean("wiki", "attachments");
    private static PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("wiki", "categories");
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("wiki", "comments");
    private static PortletDataHandlerBoolean _nodesAndPages = new PortletDataHandlerBoolean("wiki", "wikis-and-pages", true, true);
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("wiki", "ratings");
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("wiki", "tags");

    public static void exportNode(PortletDataContext context, Element nodesElement, Element pagesElement, WikiNode node) throws Exception {
        String path;
        if (context.isWithinDateRange(node.getModifiedDate()) && context.isPathNotProcessed(path = WikiPortletDataHandlerImpl.getNodePath(context, node))) {
            Element nodeElement = nodesElement.addElement("node");
            nodeElement.addAttribute("path", path);
            node.setUserUuid(node.getUserUuid());
            context.addPermissions(WikiNode.class, node.getNodeId());
            context.addZipEntry(path, (Object)node);
        }
        List pages = WikiPageUtil.findByN_S((long)node.getNodeId(), (int)0, (int)-1, (int)-1, (OrderByComparator)new PageVersionComparator(true));
        for (WikiPage page : pages) {
            WikiPortletDataHandlerImpl.exportPage(context, nodesElement, pagesElement, page);
        }
    }

    public static void importNode(PortletDataContext context, WikiNode node) throws Exception {
        long userId = context.getUserId(node.getUserUuid());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(node.getCreateDate());
        serviceContext.setModifiedDate(node.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        WikiNode importedNode = null;
        if (context.isDataStrategyMirror()) {
            WikiNode existingNode = WikiNodeUtil.fetchByUUID_G((String)node.getUuid(), (long)context.getScopeGroupId());
            String nodeName = PropsUtil.get("wiki.initial.node.name");
            if (existingNode == null && node.getName().equals(nodeName)) {
                try {
                    WikiNodeUtil.removeByG_N((long)context.getScopeGroupId(), (String)node.getName());
                }
                catch (NoSuchNodeException noSuchNodeException) {}
            }
            if (existingNode == null) {
                serviceContext.setUuid(node.getUuid());
                importedNode = WikiNodeLocalServiceUtil.addNode((long)userId, (String)node.getName(), (String)node.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedNode = WikiNodeLocalServiceUtil.updateNode((long)existingNode.getNodeId(), (String)node.getName(), (String)node.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            String nodeName = PropsUtil.get("wiki.initial.node.name");
            if (node.getName().equals(nodeName)) {
                try {
                    WikiNodeUtil.removeByG_N((long)context.getScopeGroupId(), (String)node.getName());
                }
                catch (NoSuchNodeException noSuchNodeException) {}
            }
            importedNode = WikiNodeLocalServiceUtil.addNode((long)userId, (String)node.getName(), (String)node.getDescription(), (ServiceContext)serviceContext);
        }
        Map nodePKs = context.getNewPrimaryKeysMap(WikiNode.class);
        nodePKs.put(node.getNodeId(), importedNode.getNodeId());
        context.importPermissions(WikiNode.class, node.getNodeId(), importedNode.getNodeId());
    }

    public static void importPage(PortletDataContext context, Element pageElement, WikiPage page) throws Exception {
        long userId = context.getUserId(page.getUserUuid());
        Map nodePKs = context.getNewPrimaryKeysMap(WikiNode.class);
        long nodeId = MapUtil.getLong((Map)nodePKs, (long)page.getNodeId(), (long)page.getNodeId());
        long[] assetCategoryIds = null;
        String[] assetTagNames = null;
        if (context.getBooleanParameter(_NAMESPACE, "categories") && page.isHead()) {
            assetCategoryIds = context.getAssetCategoryIds(WikiPage.class, page.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags") && page.isHead()) {
            assetTagNames = context.getAssetTagNames(WikiPage.class, page.getResourcePrimKey());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setCreateDate(page.getCreateDate());
        serviceContext.setModifiedDate(page.getModifiedDate());
        if (page.getStatus() != 0) {
            serviceContext.setWorkflowAction(2);
        }
        WikiPage importedPage = null;
        if (context.isDataStrategyMirror()) {
            WikiPage existingPage = WikiPageUtil.fetchByUUID_G((String)page.getUuid(), (long)context.getScopeGroupId());
            if (existingPage == null) {
                try {
                    existingPage = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)page.getTitle());
                }
                catch (NoSuchPageException noSuchPageException) {}
            }
            if (existingPage == null) {
                serviceContext.setUuid(page.getUuid());
                importedPage = WikiPageLocalServiceUtil.addPage((long)userId, (long)nodeId, (String)page.getTitle(), (double)page.getVersion(), (String)page.getContent(), (String)page.getSummary(), (boolean)true, (String)page.getFormat(), (boolean)page.getHead(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext);
            } else {
                importedPage = WikiPageLocalServiceUtil.updatePage((long)userId, (long)nodeId, (String)existingPage.getTitle(), (double)0.0, (String)page.getContent(), (String)page.getSummary(), (boolean)true, (String)page.getFormat(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext);
            }
        } else {
            importedPage = WikiPageLocalServiceUtil.addPage((long)userId, (long)nodeId, (String)page.getTitle(), (double)page.getVersion(), (String)page.getContent(), (String)page.getSummary(), (boolean)true, (String)page.getFormat(), (boolean)page.getHead(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext);
        }
        if (context.getBooleanParameter(_NAMESPACE, "attachments") && page.isHead()) {
            for (Element attachmentElement : pageElement.elements("attachment")) {
                String name = attachmentElement.attributeValue("name");
                String binPath = attachmentElement.attributeValue("bin-path");
                InputStream inputStream = context.getZipEntryAsInputStream(binPath);
                WikiPageLocalServiceUtil.addPageAttachment((long)importedPage.getCompanyId(), (String)importedPage.getAttachmentsDir(), (Date)importedPage.getModifiedDate(), (String)name, (InputStream)inputStream);
            }
        }
        if (page.isHead()) {
            context.importPermissions(WikiPage.class, page.getResourcePrimKey(), importedPage.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "comments") && page.isHead()) {
            context.importComments(WikiPage.class, page.getResourcePrimKey(), importedPage.getResourcePrimKey(), context.getScopeGroupId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "ratings") && page.isHead()) {
            context.importRatingsEntries(WikiPage.class, page.getResourcePrimKey(), importedPage.getResourcePrimKey());
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_nodesAndPages, _attachments, _categories, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_nodesAndPages, _attachments, _categories, _comments, _ratings, _tags};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        WikiCacheThreadLocal.setClearCache(false);
        try {
            PortletPreferences portletPreferences = super.importData(context, portletId, preferences, data);
            return portletPreferences;
        }
        finally {
            WikiCacheThreadLocal.setClearCache(true);
        }
    }

    protected static void exportNode(PortletDataContext context, Element nodesElement, long nodeId) throws Exception {
        if (!context.hasDateRange()) {
            return;
        }
        WikiNode node = WikiNodeUtil.findByPrimaryKey((long)nodeId);
        String path = WikiPortletDataHandlerImpl.getNodePath(context, node);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element nodeElement = nodesElement.addElement("node");
        nodeElement.addAttribute("path", path);
        node.setUserUuid(node.getUserUuid());
        context.addPermissions(WikiNode.class, node.getNodeId());
        context.addZipEntry(path, (Object)node);
    }

    protected static void exportPage(PortletDataContext context, Element nodesElement, Element pagesElement, WikiPage page) throws Exception {
        if (!context.isWithinDateRange(page.getModifiedDate())) {
            return;
        }
        String path = WikiPortletDataHandlerImpl.getPagePath(context, page);
        if (context.isPathNotProcessed(path)) {
            Element pageElement = pagesElement.addElement("page");
            pageElement.addAttribute("path", path);
            page.setUserUuid(page.getUserUuid());
            context.addPermissions(WikiPage.class, page.getResourcePrimKey());
            if (context.getBooleanParameter(_NAMESPACE, "categories") && page.isHead()) {
                context.addAssetCategories(WikiPage.class, page.getResourcePrimKey());
            }
            if (context.getBooleanParameter(_NAMESPACE, "comments") && page.isHead()) {
                context.addComments(WikiPage.class, page.getResourcePrimKey());
            }
            if (context.getBooleanParameter(_NAMESPACE, "ratings") && page.isHead()) {
                context.addRatingsEntries(WikiPage.class, page.getResourcePrimKey());
            }
            if (context.getBooleanParameter(_NAMESPACE, "tags") && page.isHead()) {
                context.addAssetTags(WikiPage.class, page.getResourcePrimKey());
            }
            if (context.getBooleanParameter(_NAMESPACE, "attachments") && page.isHead()) {
                String[] stringArray = page.getAttachmentsFiles();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String attachment = stringArray[n2];
                    int pos = attachment.lastIndexOf(47);
                    String name = attachment.substring(pos + 1);
                    String binPath = WikiPortletDataHandlerImpl.getPageAttachementBinPath(context, page, name);
                    Element attachmentEl = pageElement.addElement("attachment");
                    attachmentEl.addAttribute("name", name);
                    attachmentEl.addAttribute("bin-path", binPath);
                    byte[] bytes = DLServiceUtil.getFile((long)context.getCompanyId(), (long)0L, (String)attachment);
                    context.addZipEntry(binPath, bytes);
                    ++n2;
                }
                page.setAttachmentsDir(page.getAttachmentsDir());
            }
            context.addZipEntry(path, (Object)page);
        }
        WikiPortletDataHandlerImpl.exportNode(context, nodesElement, page.getNodeId());
    }

    protected static String getNodePath(PortletDataContext context, WikiNode node) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("36"));
        sb.append("/nodes/");
        sb.append(node.getNodeId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getPageAttachementBinPath(PortletDataContext context, WikiPage page, String attachment) {
        StringBundler sb = new StringBundler(5);
        sb.append(context.getPortletPath("36"));
        sb.append("/bin/");
        sb.append(page.getPageId());
        sb.append("/");
        sb.append(attachment);
        return sb.toString();
    }

    protected static String getPagePath(PortletDataContext context, WikiPage page) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("36"));
        sb.append("/pages/");
        sb.append(page.getPageId());
        sb.append(".xml");
        return sb.toString();
    }

    protected PortletPreferences doDeleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        if (!context.addPrimaryKey(WikiPortletDataHandlerImpl.class, "deleteData")) {
            WikiNodeLocalServiceUtil.deleteNodes((long)context.getScopeGroupId());
        }
        return null;
    }

    protected String doExportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        context.addPermissions("com.liferay.portlet.wiki", context.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("wiki-data");
        rootElement.addAttribute("group-id", String.valueOf(context.getScopeGroupId()));
        Element nodesElement = rootElement.addElement("nodes");
        Element pagesElement = rootElement.addElement("pages");
        List nodes = WikiNodeUtil.findByGroupId((long)context.getScopeGroupId());
        for (WikiNode node : nodes) {
            WikiPortletDataHandlerImpl.exportNode(context, nodesElement, pagesElement, node);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws Exception {
        context.importPermissions("com.liferay.portlet.wiki", context.getSourceGroupId(), context.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element nodesElement = rootElement.element("nodes");
        for (Element nodeElement : nodesElement.elements("node")) {
            String path = nodeElement.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            WikiNode node = (WikiNode)context.getZipEntryAsObject(path);
            WikiPortletDataHandlerImpl.importNode(context, node);
        }
        Element pagesElement = rootElement.element("pages");
        for (Element pageElement : pagesElement.elements("page")) {
            String path = pageElement.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            WikiPage page = (WikiPage)context.getZipEntryAsObject(path);
            WikiPortletDataHandlerImpl.importPage(context, pageElement, page);
        }
        Map nodePKs = context.getNewPrimaryKeysMap(WikiNode.class);
        Iterator iterator = nodePKs.values().iterator();
        while (iterator.hasNext()) {
            long nodeId = (Long)iterator.next();
            WikiCacheUtil.clearCache(nodeId);
        }
        return null;
    }
}

