/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.wiki.DuplicateNodeNameException;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.NodeNameException;
import com.liferay.portlet.wiki.action.ActionUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditNodeAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateNode(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteNode(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeNode(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeNode(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.wiki.error");
            }
            if (e instanceof DuplicateNodeNameException || e instanceof NodeNameException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            long nodeId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"nodeId");
            if (nodeId > 0L) {
                ActionUtil.getNode((PortletRequest)renderRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.wiki.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.wiki.edit_node"));
    }

    protected void deleteNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String oldName = this.getNodeName(nodeId);
        WikiCacheThreadLocal.setClearCache(false);
        WikiNodeServiceUtil.deleteNode((long)nodeId);
        WikiCacheUtil.clearCache(nodeId);
        WikiCacheThreadLocal.setClearCache(true);
        this.updatePreferences(actionRequest, oldName, "");
    }

    protected String getNodeName(long nodeId) throws Exception {
        WikiNode node = WikiNodeServiceUtil.getNode((long)nodeId);
        return node.getName();
    }

    protected void subscribeNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        WikiNodeServiceUtil.subscribeNode((long)nodeId);
    }

    protected void unsubscribeNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        WikiNodeServiceUtil.unsubscribeNode((long)nodeId);
    }

    protected void updateNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiNode.class.getName(), (PortletRequest)actionRequest);
        if (nodeId <= 0L) {
            WikiNodeServiceUtil.addNode((String)name, (String)description, (ServiceContext)serviceContext);
        } else {
            String oldName = this.getNodeName(nodeId);
            WikiNodeServiceUtil.updateNode((long)nodeId, (String)name, (String)description, (ServiceContext)serviceContext);
            this.updatePreferences(actionRequest, oldName, name);
        }
    }

    protected void updatePreferences(ActionRequest actionRequest, String oldName, String newName) throws Exception {
        PortletPreferences preferences = actionRequest.getPreferences();
        String hiddenNodes = preferences.getValue("hidden-nodes", "");
        String visibleNodes = preferences.getValue("visible-nodes", "");
        String regex = String.valueOf(oldName) + ",?";
        preferences.setValue("hidden-nodes", hiddenNodes.replaceFirst(regex, newName));
        preferences.setValue("visible-nodes", visibleNodes.replaceFirst(regex, newName));
        preferences.store();
    }
}

