/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.messageboards.NoSuchMessageFlagException;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageFlag;
import com.liferay.portlet.messageboards.service.base.MBMessageFlagServiceBaseImpl;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import java.util.Date;

public class MBMessageFlagServiceImpl
extends MBMessageFlagServiceBaseImpl {
    public void addAnswerFlag(long messageId) throws PortalException, SystemException {
        MBMessageFlag messageFlag;
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        if (message.isRoot()) {
            return;
        }
        MBMessage rootMessage = this.mbMessagePersistence.findByPrimaryKey(message.getRootMessageId());
        MBMessagePermission.check(this.getPermissionChecker(), rootMessage.getMessageId(), "UPDATE");
        MBMessageFlag questionMessageFlag = this.mbMessageFlagPersistence.fetchByU_M_F(rootMessage.getUserId(), rootMessage.getMessageId(), 2);
        MBMessageFlag answerMessageFlag = this.mbMessageFlagPersistence.fetchByU_M_F(rootMessage.getUserId(), rootMessage.getMessageId(), 3);
        if (questionMessageFlag != null && answerMessageFlag == null) {
            questionMessageFlag.setFlag(3);
            this.mbMessageFlagPersistence.update((BaseModel)questionMessageFlag, false);
        }
        if ((messageFlag = this.mbMessageFlagPersistence.fetchByU_M_F(message.getUserId(), message.getMessageId(), 3)) == null) {
            long messageFlagId = this.counterLocalService.increment();
            messageFlag = this.mbMessageFlagPersistence.create(messageFlagId);
            messageFlag.setUserId(message.getUserId());
            messageFlag.setModifiedDate(new Date());
            messageFlag.setThreadId(message.getThreadId());
            messageFlag.setMessageId(message.getMessageId());
            messageFlag.setFlag(3);
            this.mbMessageFlagPersistence.update((BaseModel)messageFlag, false);
        }
    }

    public void deleteAnswerFlag(long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        if (message.isRoot()) {
            return;
        }
        MBMessage rootMessage = this.mbMessagePersistence.findByPrimaryKey(message.getRootMessageId());
        MBMessagePermission.check(this.getPermissionChecker(), rootMessage.getMessageId(), "UPDATE");
        try {
            this.mbMessageFlagPersistence.removeByU_M_F(message.getUserId(), message.getMessageId(), 3);
        }
        catch (NoSuchMessageFlagException noSuchMessageFlagException) {}
        MBMessageFlag answerMessageFlag = this.mbMessageFlagPersistence.fetchByU_M_F(rootMessage.getUserId(), rootMessage.getMessageId(), 3);
        if (answerMessageFlag == null) {
            return;
        }
        int answerFlagsCount = this.mbMessageFlagPersistence.countByT_F(message.getThreadId(), 3);
        if (answerFlagsCount == 1) {
            answerMessageFlag.setFlag(2);
            this.mbMessageFlagPersistence.update((BaseModel)answerMessageFlag, false);
        }
    }
}

