/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.ImageUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.lar.DLPortletDataHandlerImpl;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryUtil;
import com.liferay.portlet.imagegallery.lar.IGPortletDataHandlerImpl;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import com.liferay.portlet.imagegallery.service.persistence.IGImageUtil;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.lar.JournalCreationStrategy;
import com.liferay.portlet.journal.lar.JournalCreationStrategyFactory;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleImage;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFeedLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleImageUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleUtil;
import com.liferay.portlet.journal.service.persistence.JournalFeedUtil;
import com.liferay.portlet.journal.service.persistence.JournalStructureUtil;
import com.liferay.portlet.journal.service.persistence.JournalTemplateUtil;
import com.liferay.portlet.journal.util.comparator.ArticleIDComparator;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;

public class JournalPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "journal";
    private static Log _log = LogFactoryUtil.getLog(JournalPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("journal", "categories");
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("journal", "comments");
    private static PortletDataHandlerBoolean _embeddedAssets = new PortletDataHandlerBoolean("journal", "embedded-assets");
    private static PortletDataHandlerBoolean _images = new PortletDataHandlerBoolean("journal", "images");
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("journal", "ratings");
    private static PortletDataHandlerBoolean _structuresTemplatesAndFeeds = new PortletDataHandlerBoolean("journal", "structures-templates-and-feeds", true, true);
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("journal", "tags");
    private static PortletDataHandlerBoolean _articles = new PortletDataHandlerBoolean("journal", "articles", true, false, new PortletDataHandlerControl[]{_images, _comments, _ratings, _tags});

    protected static void exportArticle(PortletDataContext context, Element articlesElement, Element structuresElement, Element templatesElement, Element dlFoldersElement, Element dlFileEntriesElement, Element dlFileRanksElement, Element igFoldersElement, Element igImagesElement, JournalArticle article, boolean checkDateRange) throws Exception {
        if (checkDateRange && !context.isWithinDateRange(article.getModifiedDate())) {
            return;
        }
        if (article.getStatus() != 0) {
            return;
        }
        String path = JournalPortletDataHandlerImpl.getArticlePath(context, article);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        article = (JournalArticle)article.clone();
        Element articleElement = (Element)articlesElement.selectSingleNode("//article[@path='".concat(path).concat("']"));
        if (articleElement == null) {
            articleElement = articlesElement.addElement("article");
        }
        articleElement.addAttribute("path", path);
        articleElement.addAttribute("article-resource-uuid", article.getArticleResourceUuid());
        article.setUserUuid(article.getUserUuid());
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)article.getCompanyId());
        if (Validator.isNotNull((String)article.getStructureId())) {
            JournalStructure structure = null;
            try {
                structure = JournalStructureLocalServiceUtil.getStructure((long)article.getGroupId(), (String)article.getStructureId());
            }
            catch (NoSuchStructureException noSuchStructureException) {
                structure = JournalStructureLocalServiceUtil.getStructure((long)companyGroup.getGroupId(), (String)article.getStructureId());
            }
            articleElement.addAttribute("structure-uuid", structure.getUuid());
            if (structure.getGroupId() == companyGroup.getGroupId()) {
                JournalPortletDataHandlerImpl.exportStructure(context, structuresElement, structure);
            }
        }
        if (Validator.isNotNull((String)article.getTemplateId())) {
            JournalTemplate template = null;
            try {
                template = JournalTemplateLocalServiceUtil.getTemplate((long)context.getScopeGroupId(), (String)article.getTemplateId());
            }
            catch (NoSuchTemplateException noSuchTemplateException) {
                template = JournalTemplateLocalServiceUtil.getTemplate((long)companyGroup.getGroupId(), (String)article.getTemplateId());
            }
            articleElement.addAttribute("template-uuid", template.getUuid());
            if (template.getGroupId() == companyGroup.getGroupId()) {
                JournalPortletDataHandlerImpl.exportTemplate(context, templatesElement, dlFoldersElement, dlFileEntriesElement, dlFileRanksElement, igFoldersElement, igImagesElement, template, checkDateRange);
            }
        }
        Image smallImage = ImageUtil.fetchByPrimaryKey((long)article.getSmallImageId());
        if (article.isSmallImage() && smallImage != null) {
            String smallImagePath = JournalPortletDataHandlerImpl.getArticleSmallImagePath(context, article);
            articleElement.addAttribute("small-image-path", smallImagePath);
            article.setSmallImageType(smallImage.getType());
            context.addZipEntry(smallImagePath, smallImage.getTextObj());
        }
        if (context.getBooleanParameter(_NAMESPACE, "images")) {
            String imagePath = JournalPortletDataHandlerImpl.getArticleImagePath(context, article);
            articleElement.addAttribute("image-path", imagePath);
            List articleImages = JournalArticleImageUtil.findByG_A_V((long)article.getGroupId(), (String)article.getArticleId(), (double)article.getVersion());
            for (JournalArticleImage articleImage : articleImages) {
                Image image = null;
                try {
                    image = ImageUtil.findByPrimaryKey((long)articleImage.getArticleImageId());
                }
                catch (NoSuchImageException noSuchImageException) {
                    continue;
                }
                String articleImagePath = JournalPortletDataHandlerImpl.getArticleImagePath(context, article, articleImage, image);
                if (!context.isPathNotProcessed(articleImagePath)) continue;
                context.addZipEntry(articleImagePath, image.getTextObj());
            }
        }
        article.setStatusByUserUuid(article.getStatusByUserUuid());
        context.addPermissions(JournalArticle.class, article.getResourcePrimKey());
        if (context.getBooleanParameter(_NAMESPACE, "categories")) {
            context.addAssetCategories(JournalArticle.class, article.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "comments")) {
            context.addComments(JournalArticle.class, article.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
            context.addRatingsEntries(JournalArticle.class, article.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            context.addAssetTags(JournalArticle.class, article.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "embedded-assets")) {
            String content = article.getContent();
            content = JournalPortletDataHandlerImpl.exportDLFileEntries(context, dlFoldersElement, dlFileEntriesElement, dlFileRanksElement, articleElement, content, checkDateRange);
            content = JournalPortletDataHandlerImpl.exportIGImages(context, igFoldersElement, igImagesElement, articleElement, content, checkDateRange);
            content = JournalPortletDataHandlerImpl.exportLayoutFriendlyURLs(context, content);
            article.setContent(content);
        }
        context.addZipEntry(path, (Object)article);
    }

    protected static String exportDLFileEntries(PortletDataContext context, Element foldersElement, Element fileEntriesElement, Element fileRanksElement, Element entityElement, String content, boolean checkDateRange) {
        StringBuilder sb = new StringBuilder(content);
        int beginPos = content.length();
        int currentLocation = -1;
        while (true) {
            block22: {
                if ((currentLocation = content.lastIndexOf("/c/document_library/get_file?", beginPos)) == -1) {
                    currentLocation = content.lastIndexOf("/documents/", beginPos);
                }
                if (currentLocation == -1) {
                    return sb.toString();
                }
                beginPos = currentLocation;
                int endPos1 = content.indexOf(39, beginPos);
                int endPos2 = content.indexOf(93, beginPos);
                int endPos3 = content.indexOf(41, beginPos);
                int endPos4 = content.indexOf(60, beginPos);
                int endPos5 = content.indexOf(34, beginPos);
                int endPos6 = content.indexOf(32, beginPos);
                int endPos = endPos1;
                if (endPos == -1 || endPos2 != -1 && endPos2 < endPos) {
                    endPos = endPos2;
                }
                if (endPos == -1 || endPos3 != -1 && endPos3 < endPos) {
                    endPos = endPos3;
                }
                if (endPos == -1 || endPos4 != -1 && endPos4 < endPos) {
                    endPos = endPos4;
                }
                if (endPos == -1 || endPos5 != -1 && endPos5 < endPos) {
                    endPos = endPos5;
                }
                if (endPos == -1 || endPos6 != -1 && endPos6 < endPos) {
                    endPos = endPos6;
                }
                if (beginPos == -1 || endPos == -1) break;
                try {
                    String oldParameters = content.substring(beginPos, endPos);
                    while (oldParameters.contains("&amp;")) {
                        oldParameters = oldParameters.replace("&amp;", "&");
                    }
                    LinkedHashMap map = new HashMap();
                    if (oldParameters.startsWith("/documents/")) {
                        String[] pathArray = oldParameters.split("/");
                        map.put("groupId", pathArray[2]);
                        if (pathArray.length == 4) {
                            map.put("uuid", pathArray[3]);
                        } else if (pathArray.length > 4) {
                            map.put("folderId", pathArray[3]);
                            map.put("name", pathArray[4]);
                        }
                    } else {
                        oldParameters = oldParameters.substring(oldParameters.indexOf(63) + 1);
                        map = MapUtil.toLinkedHashMap((String[])oldParameters.split("&"), (String)"=");
                    }
                    DLFileEntry fileEntry = null;
                    if (map.containsKey("uuid")) {
                        String uuid = (String)map.get("uuid");
                        String groupIdString = (String)map.get("groupId");
                        long groupId = GetterUtil.getLong((String)groupIdString);
                        if (groupIdString.equals("@group_id@")) {
                            groupId = context.getScopeGroupId();
                        }
                        fileEntry = DLFileEntryLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                    } else if (map.containsKey("folderId")) {
                        long folderId = GetterUtil.getLong((String)((String)map.get("folderId")));
                        String name = (String)map.get("name");
                        String groupIdString = (String)map.get("groupId");
                        long groupId = GetterUtil.getLong((String)groupIdString);
                        if (groupIdString.equals("@group_id@")) {
                            groupId = context.getScopeGroupId();
                        }
                        fileEntry = DLFileEntryLocalServiceUtil.getFileEntryByTitle((long)groupId, (long)folderId, (String)name);
                    }
                    if (fileEntry == null) {
                        --beginPos;
                        continue;
                    }
                    String path = DLPortletDataHandlerImpl.getFileEntryPath(context, fileEntry);
                    Element dlReferenceElement = entityElement.addElement("dl-reference");
                    dlReferenceElement.addAttribute("path", path);
                    DLPortletDataHandlerImpl.exportFileEntry(context, foldersElement, fileEntriesElement, fileRanksElement, fileEntry, checkDateRange);
                    String dlReference = "[$dl-reference=" + path + "$]";
                    sb.replace(beginPos, endPos, dlReference);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block22;
                    _log.warn((Throwable)e);
                }
            }
            --beginPos;
        }
        return sb.toString();
    }

    protected static void exportFeed(PortletDataContext context, Element feedsElement, JournalFeed feed) throws Exception {
        if (!context.isWithinDateRange(feed.getModifiedDate())) {
            return;
        }
        String path = JournalPortletDataHandlerImpl.getFeedPath(context, feed);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element feedElement = feedsElement.addElement("feed");
        feedElement.addAttribute("path", path);
        feed.setUserUuid(feed.getUserUuid());
        context.addPermissions(JournalFeed.class, feed.getId());
        context.addZipEntry(path, (Object)feed);
    }

    protected static String exportIGImages(PortletDataContext context, Element foldersElement, Element imagesElement, Element entityElement, String content, boolean checkDateRange) {
        StringBuilder sb = new StringBuilder(content);
        int beginPos = content.length();
        while (true) {
            block18: {
                if ((beginPos = content.lastIndexOf("/image/image_gallery?", beginPos)) == -1) {
                    return sb.toString();
                }
                int endPos1 = content.indexOf(39, beginPos);
                int endPos2 = content.indexOf(93, beginPos);
                int endPos3 = content.indexOf(41, beginPos);
                int endPos4 = content.indexOf(60, beginPos);
                int endPos5 = content.indexOf(34, beginPos);
                int endPos6 = content.indexOf(32, beginPos);
                int endPos = endPos1;
                if (endPos == -1 || endPos2 != -1 && endPos2 < endPos) {
                    endPos = endPos2;
                }
                if (endPos == -1 || endPos3 != -1 && endPos3 < endPos) {
                    endPos = endPos3;
                }
                if (endPos == -1 || endPos4 != -1 && endPos4 < endPos) {
                    endPos = endPos4;
                }
                if (endPos == -1 || endPos5 != -1 && endPos5 < endPos) {
                    endPos = endPos5;
                }
                if (endPos == -1 || endPos6 != -1 && endPos6 < endPos) {
                    endPos = endPos6;
                }
                if (beginPos == -1 || endPos == -1) break;
                try {
                    String oldParameters = content.substring(beginPos, endPos);
                    oldParameters = oldParameters.substring(oldParameters.indexOf("?") + 1);
                    while (oldParameters.contains("&amp;")) {
                        oldParameters = oldParameters.replace("&amp;", "&");
                    }
                    LinkedHashMap map = MapUtil.toLinkedHashMap((String[])oldParameters.split("&"), (String)"=");
                    IGImage image = null;
                    if (map.containsKey("uuid")) {
                        String uuid = (String)map.get("uuid");
                        String groupIdString = (String)map.get("groupId");
                        long groupId = GetterUtil.getLong((String)groupIdString);
                        if (groupIdString.equals("@group_id@")) {
                            groupId = context.getScopeGroupId();
                        }
                        image = IGImageLocalServiceUtil.getImageByUuidAndGroupId((String)uuid, (long)groupId);
                    } else if (map.containsKey("image_id") || map.containsKey("img_id") || map.containsKey("i_id")) {
                        long imageId = GetterUtil.getLong((String)((String)map.get("image_id")));
                        if (imageId <= 0L && (imageId = GetterUtil.getLong((String)((String)map.get("img_id")))) <= 0L) {
                            imageId = GetterUtil.getLong((String)((String)map.get("i_id")));
                        }
                        try {
                            image = IGImageLocalServiceUtil.getImageByLargeImageId((long)imageId);
                        }
                        catch (Exception exception) {
                            image = IGImageLocalServiceUtil.getImageBySmallImageId((long)imageId);
                        }
                    }
                    if (image == null) {
                        --beginPos;
                        continue;
                    }
                    String path = IGPortletDataHandlerImpl.getImagePath(context, image);
                    Element igReferenceElement = entityElement.addElement("ig-reference");
                    igReferenceElement.addAttribute("path", path);
                    IGPortletDataHandlerImpl.exportImage(context, foldersElement, imagesElement, image, checkDateRange);
                    String igReference = "[$ig-reference=" + path + "$]";
                    sb.replace(beginPos, endPos, igReference);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block18;
                    _log.warn((Throwable)e);
                }
            }
            --beginPos;
        }
        return sb.toString();
    }

    protected static String exportLayoutFriendlyURLs(PortletDataContext context, String content) {
        Group group = null;
        try {
            group = GroupLocalServiceUtil.getGroup((long)context.getScopeGroupId());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)e);
            }
            return content;
        }
        StringBuilder sb = new StringBuilder(content);
        String friendlyURLPrivateGroupPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
        String friendlyURLPrivateUserPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
        String friendlyURLPublicPath = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
        String href = "href=";
        int beginPos = content.length();
        while (true) {
            int hrefLength = href.length();
            if ((beginPos = content.lastIndexOf(href, beginPos)) == -1) break;
            char c = content.charAt(beginPos + hrefLength);
            if (c == '\'' || c == '\"') {
                ++hrefLength;
            }
            int endPos1 = content.indexOf(39, beginPos + hrefLength);
            int endPos2 = content.indexOf(93, beginPos + hrefLength);
            int endPos3 = content.indexOf(41, beginPos + hrefLength);
            int endPos4 = content.indexOf(60, beginPos + hrefLength);
            int endPos5 = content.indexOf(34, beginPos + hrefLength);
            int endPos6 = content.indexOf(32, beginPos + hrefLength);
            int endPos = endPos1;
            if (endPos == -1 || endPos2 != -1 && endPos2 < endPos) {
                endPos = endPos2;
            }
            if (endPos == -1 || endPos3 != -1 && endPos3 < endPos) {
                endPos = endPos3;
            }
            if (endPos == -1 || endPos4 != -1 && endPos4 < endPos) {
                endPos = endPos4;
            }
            if (endPos == -1 || endPos5 != -1 && endPos5 < endPos) {
                endPos = endPos5;
            }
            if (endPos == -1 || endPos6 != -1 && endPos6 < endPos) {
                endPos = endPos6;
            }
            if (endPos == -1) {
                --beginPos;
                continue;
            }
            String url = content.substring(beginPos + hrefLength, endPos);
            if (!(url.startsWith(friendlyURLPrivateGroupPath) || url.startsWith(friendlyURLPrivateUserPath) || url.startsWith(friendlyURLPublicPath))) {
                --beginPos;
                continue;
            }
            int beginGroupPos = content.indexOf(47, beginPos + hrefLength + 1);
            if (beginGroupPos == -1) {
                --beginPos;
                continue;
            }
            int endGroupPos = content.indexOf(47, beginGroupPos + 1);
            if (endGroupPos == -1) {
                --beginPos;
                continue;
            }
            String groupFriendlyURL = content.substring(beginGroupPos, endGroupPos);
            if (groupFriendlyURL.equals(group.getFriendlyURL())) {
                sb.replace(beginGroupPos, endGroupPos, "@data_handler_group_friendly_url@");
            }
            --beginPos;
        }
        return sb.toString();
    }

    protected static void exportStructure(PortletDataContext context, Element structuresElement, JournalStructure structure) throws Exception {
        String path = JournalPortletDataHandlerImpl.getStructurePath(context, structure);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element structureElement = structuresElement.addElement("structure");
        structureElement.addAttribute("path", path);
        structure.setUserUuid(structure.getUserUuid());
        context.addPermissions(JournalStructure.class, structure.getId());
        context.addZipEntry(path, (Object)structure);
    }

    protected static void exportTemplate(PortletDataContext context, Element templatesElement, Element dlFoldersElement, Element dlFileEntriesElement, Element dlFileRanksElement, Element igFoldersElement, Element igImagesElement, JournalTemplate template, boolean checkDateRange) throws Exception {
        String path = JournalPortletDataHandlerImpl.getTemplatePath(context, template);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        template = (JournalTemplate)template.clone();
        Element templateElement = templatesElement.addElement("template");
        templateElement.addAttribute("path", path);
        if (template.isSmallImage()) {
            String smallImagePath = JournalPortletDataHandlerImpl.getTemplateSmallImagePath(context, template);
            templateElement.addAttribute("small-image-path", smallImagePath);
            Image smallImage = ImageUtil.fetchByPrimaryKey((long)template.getSmallImageId());
            template.setSmallImageType(smallImage.getType());
            context.addZipEntry(smallImagePath, smallImage.getTextObj());
        }
        if (context.getBooleanParameter(_NAMESPACE, "embedded-assets")) {
            String content = template.getXsl();
            content = JournalPortletDataHandlerImpl.exportDLFileEntries(context, dlFoldersElement, dlFileEntriesElement, dlFileRanksElement, templateElement, content, checkDateRange);
            content = JournalPortletDataHandlerImpl.exportIGImages(context, igFoldersElement, igImagesElement, templateElement, content, checkDateRange);
            content = JournalPortletDataHandlerImpl.exportLayoutFriendlyURLs(context, content);
            content = StringUtil.replace((String)content, (String)"&amp;", (String)"&");
            template.setXsl(content);
        }
        template.setUserUuid(template.getUserUuid());
        context.addPermissions(JournalTemplate.class, template.getId());
        context.addZipEntry(path, (Object)template);
    }

    protected static String getArticleImagePath(PortletDataContext context, JournalArticle article) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append(context.getPortletPath("15"));
        sb.append("/articles/");
        sb.append(article.getArticleResourceUuid());
        sb.append("/");
        sb.append(article.getVersion());
        sb.append("/");
        return sb.toString();
    }

    protected static String getArticleImagePath(PortletDataContext context, JournalArticle article, JournalArticleImage articleImage, Image image) throws Exception {
        StringBundler sb = new StringBundler(13);
        sb.append(context.getPortletPath("15"));
        sb.append("/articles/");
        sb.append(article.getArticleResourceUuid());
        sb.append("/");
        sb.append(article.getVersion());
        sb.append("/");
        sb.append(articleImage.getElInstanceId());
        sb.append("_");
        sb.append(articleImage.getElName());
        if (Validator.isNotNull((String)articleImage.getLanguageId())) {
            sb.append("_");
            sb.append(articleImage.getLanguageId());
        }
        sb.append(".");
        sb.append(image.getType());
        return sb.toString();
    }

    protected static String getArticlePath(PortletDataContext context, JournalArticle article) throws Exception {
        StringBundler sb = new StringBundler(8);
        sb.append(context.getPortletPath("15"));
        sb.append("/articles/");
        sb.append(article.getArticleResourceUuid());
        sb.append("/");
        sb.append(article.getVersion());
        sb.append("/");
        sb.append("article.xml");
        return sb.toString();
    }

    protected static String getArticleSmallImagePath(PortletDataContext context, JournalArticle article) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append(context.getPortletPath("15"));
        sb.append("/articles/");
        sb.append(article.getArticleResourceUuid());
        sb.append("/thumbnail");
        sb.append(".");
        sb.append(article.getSmallImageType());
        return sb.toString();
    }

    protected static String getFeedPath(PortletDataContext context, JournalFeed feed) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("15"));
        sb.append("/feeds/");
        sb.append(feed.getUuid());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getStructurePath(PortletDataContext context, JournalStructure structure) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("15"));
        sb.append("/structures/");
        sb.append(structure.getUuid());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getTemplatePath(PortletDataContext context, JournalTemplate template) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("15"));
        sb.append("/templates/");
        sb.append(template.getUuid());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getTemplateSmallImagePath(PortletDataContext context, JournalTemplate template) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append(context.getPortletPath("15"));
        sb.append("/templates/thumbnail-");
        sb.append(template.getUuid());
        sb.append(".");
        sb.append(template.getSmallImageType());
        return sb.toString();
    }

    protected static void importArticle(PortletDataContext context, Element articleElement) throws Exception {
        String newContent;
        JournalCreationStrategy creationStrategy;
        long authorId;
        Map articleIds;
        String newArticleId;
        String path = articleElement.attributeValue("path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        JournalArticle article = (JournalArticle)context.getZipEntryAsObject(path);
        long userId = context.getUserId(article.getUserUuid());
        User user = UserLocalServiceUtil.getUser((long)userId);
        String articleId = article.getArticleId();
        boolean autoArticleId = false;
        if (Validator.isNumber((String)articleId) || JournalArticleUtil.fetchByG_A_V((long)context.getScopeGroupId(), (String)articleId, (double)1.0) != null) {
            autoArticleId = true;
        }
        if (Validator.isNotNull((String)(newArticleId = (String)(articleIds = context.getNewPrimaryKeysMap(JournalArticle.class)).get(articleId)))) {
            articleId = newArticleId;
            autoArticleId = false;
        }
        String content = article.getContent();
        content = JournalPortletDataHandlerImpl.importDLFileEntries(context, articleElement, content);
        content = JournalPortletDataHandlerImpl.importIGImages(context, articleElement, content);
        Group group = GroupLocalServiceUtil.getGroup((long)context.getScopeGroupId());
        content = StringUtil.replace((String)content, (String)"@data_handler_group_friendly_url@", (String)group.getFriendlyURL());
        article.setContent(content);
        Map structureIds = context.getNewPrimaryKeysMap(JournalStructure.class);
        String parentStructureId = MapUtil.getString((Map)structureIds, (String)article.getStructureId(), (String)article.getStructureId());
        Map templateIds = context.getNewPrimaryKeysMap(JournalTemplate.class);
        String parentTemplateId = MapUtil.getString((Map)templateIds, (String)article.getTemplateId(), (String)article.getTemplateId());
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        if (Validator.isNotNull((String)article.getStructureId())) {
            String structureUuid = articleElement.attributeValue("structure-uuid");
            JournalStructure existingStructure = JournalStructureUtil.fetchByUUID_G((String)structureUuid, (long)context.getScopeGroupId());
            if (existingStructure == null) {
                String newStructureId = (String)structureIds.get(article.getStructureId());
                if (Validator.isNotNull((String)newStructureId)) {
                    existingStructure = JournalStructureUtil.fetchByG_S((long)context.getScopeGroupId(), (String)String.valueOf(newStructureId));
                }
                if (existingStructure == null) {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler();
                        sb.append("Structure ");
                        sb.append(article.getStructureId());
                        sb.append(" is missing for article ");
                        sb.append(article.getArticleId());
                        sb.append(", skipping this article.");
                        _log.warn((Object)sb.toString());
                    }
                    return;
                }
            }
            parentStructureId = existingStructure.getStructureId();
        }
        if (Validator.isNotNull((String)article.getTemplateId())) {
            String templateUuid = articleElement.attributeValue("template-uuid");
            JournalTemplate existingTemplate = JournalTemplateUtil.fetchByUUID_G((String)templateUuid, (long)context.getScopeGroupId());
            if (existingTemplate == null) {
                String newTemplateId = (String)templateIds.get(article.getTemplateId());
                if (Validator.isNotNull((String)newTemplateId)) {
                    existingTemplate = JournalTemplateUtil.fetchByG_T((long)context.getScopeGroupId(), (String)newTemplateId);
                }
                if (existingTemplate == null) {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler();
                        sb.append("Template ");
                        sb.append(article.getTemplateId());
                        sb.append(" is missing for article ");
                        sb.append(article.getArticleId());
                        sb.append(", skipping this article.");
                        _log.warn((Object)sb.toString());
                    }
                    return;
                }
            }
            parentTemplateId = existingTemplate.getTemplateId();
        }
        File smallFile = null;
        String smallImagePath = articleElement.attributeValue("small-image-path");
        if (article.isSmallImage() && Validator.isNotNull((String)smallImagePath)) {
            byte[] bytes = context.getZipEntryAsByteArray(smallImagePath);
            smallFile = File.createTempFile(String.valueOf(article.getSmallImageId()), "." + article.getSmallImageType());
            FileUtil.write((File)smallFile, (byte[])bytes);
        }
        HashMap<String, byte[]> images = new HashMap<String, byte[]>();
        String imagePath = articleElement.attributeValue("image-path");
        if (context.getBooleanParameter(_NAMESPACE, "images") && Validator.isNotNull((String)imagePath)) {
            List imageFiles = context.getZipFolderEntries(imagePath);
            for (String imageFile : imageFiles) {
                String fileName = imageFile;
                if (fileName.contains("/")) {
                    fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                }
                if (fileName.endsWith(".xml")) continue;
                int pos = fileName.lastIndexOf(46);
                if (pos != -1) {
                    fileName = fileName.substring(0, pos);
                }
                images.put(fileName, context.getZipEntryAsByteArray(imageFile));
            }
        }
        String articleURL = null;
        long[] assetCategoryIds = null;
        String[] assetTagNames = null;
        if (context.getBooleanParameter(_NAMESPACE, "categories")) {
            assetCategoryIds = context.getAssetCategoryIds(JournalArticle.class, article.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            assetTagNames = context.getAssetTagNames(JournalArticle.class, article.getResourcePrimKey());
        }
        if ((authorId = (creationStrategy = JournalCreationStrategyFactory.getInstance()).getAuthorUserId(context, article)) != 0L) {
            userId = authorId;
        }
        if ((newContent = creationStrategy.getTransformedContent(context, article)) != JournalCreationStrategy.ARTICLE_CONTENT_UNCHANGED) {
            article.setContent(newContent);
        }
        boolean addCommunityPermissions = creationStrategy.addCommunityPermissions(context, article);
        boolean addGuestPermissions = creationStrategy.addGuestPermissions(context, article);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(addCommunityPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setAttribute("imported", (Serializable)((Object)Boolean.TRUE.toString()));
        serviceContext.setCreateDate(article.getCreateDate());
        serviceContext.setModifiedDate(article.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        if (article.getStatus() != 0) {
            serviceContext.setWorkflowAction(2);
        }
        JournalArticle importedArticle = null;
        String articleResourceUuid = articleElement.attributeValue("article-resource-uuid");
        if (context.isDataStrategyMirror()) {
            long resourcePrimKey = JournalArticleResourceLocalServiceUtil.getArticleResourcePrimKey((String)articleResourceUuid, (long)context.getScopeGroupId(), (String)newArticleId);
            serviceContext.setUuid(articleResourceUuid);
            JournalArticle existingArticle = null;
            try {
                existingArticle = JournalArticleLocalServiceUtil.getLatestArticle((long)resourcePrimKey);
            }
            catch (NoSuchArticleException noSuchArticleException) {
                existingArticle = JournalArticleUtil.fetchByG_A_V((long)context.getScopeGroupId(), (String)newArticleId, (double)article.getVersion());
            }
            importedArticle = existingArticle == null ? JournalArticleLocalServiceUtil.addArticle((long)userId, (long)context.getScopeGroupId(), (String)articleId, (boolean)autoArticleId, (double)article.getVersion(), (String)article.getTitle(), (String)article.getDescription(), (String)article.getContent(), (String)article.getType(), (String)parentStructureId, (String)parentTemplateId, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.isIndexable(), (boolean)article.isSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext) : JournalArticleLocalServiceUtil.updateArticle((long)userId, (long)existingArticle.getGroupId(), (String)existingArticle.getArticleId(), (double)existingArticle.getVersion(), (String)article.getTitle(), (String)article.getDescription(), (String)article.getContent(), (String)article.getType(), (String)parentStructureId, (String)parentTemplateId, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.isIndexable(), (boolean)article.isSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext);
        } else {
            importedArticle = JournalArticleLocalServiceUtil.addArticle((long)userId, (long)context.getScopeGroupId(), (String)articleId, (boolean)autoArticleId, (double)article.getVersion(), (String)article.getTitle(), (String)article.getDescription(), (String)article.getContent(), (String)article.getType(), (String)parentStructureId, (String)parentTemplateId, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.isIndexable(), (boolean)article.isSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext);
        }
        context.importPermissions(JournalArticle.class, article.getResourcePrimKey(), importedArticle.getResourcePrimKey());
        if (context.getBooleanParameter(_NAMESPACE, "comments")) {
            context.importComments(JournalArticle.class, article.getResourcePrimKey(), importedArticle.getResourcePrimKey(), context.getScopeGroupId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
            context.importRatingsEntries(JournalArticle.class, article.getResourcePrimKey(), importedArticle.getResourcePrimKey());
        }
        articleIds.put(articleId, importedArticle.getArticleId());
        if (!articleId.equals(importedArticle.getArticleId()) && _log.isWarnEnabled()) {
            _log.warn((Object)("An article with the ID " + articleId + " already " + "exists. The new generated ID is " + importedArticle.getArticleId()));
        }
    }

    protected static String importDLFileEntries(PortletDataContext context, Element parentElement, String content) throws Exception {
        Map fileEntryPKs = context.getNewPrimaryKeysMap(DLFileEntry.class);
        List dlReferenceElements = parentElement.elements("dl-reference");
        for (Element dlReferenceElement : dlReferenceElements) {
            long fileEntryId;
            String dlReferencePath = dlReferenceElement.attributeValue("path");
            DLFileEntry fileEntry = (DLFileEntry)context.getZipEntryAsObject(dlReferencePath);
            if (fileEntry == null || (fileEntry = DLFileEntryUtil.fetchByPrimaryKey((long)(fileEntryId = MapUtil.getLong((Map)fileEntryPKs, (long)fileEntry.getFileEntryId(), (long)fileEntry.getFileEntryId())))) == null) continue;
            String dlReference = "[$dl-reference=" + dlReferencePath + "$]";
            StringBundler sb = new StringBundler(6);
            sb.append("/documents/");
            sb.append(context.getScopeGroupId());
            sb.append("/");
            sb.append(fileEntry.getFolderId());
            sb.append("/");
            sb.append(HttpUtil.encodeURL((String)HtmlUtil.unescape((String)fileEntry.getTitle())));
            content = StringUtil.replace((String)content, (String)dlReference, (String)sb.toString());
        }
        return content;
    }

    protected static void importFeed(PortletDataContext context, Element feedElement) throws Exception {
        String path = feedElement.attributeValue("path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        JournalFeed feed = (JournalFeed)context.getZipEntryAsObject(path);
        long userId = context.getUserId(feed.getUserUuid());
        String feedId = feed.getFeedId();
        boolean autoFeedId = false;
        if (Validator.isNumber((String)feedId) || JournalFeedUtil.fetchByG_F((long)context.getScopeGroupId(), (String)feedId) != null) {
            autoFeedId = true;
        }
        Map structureIds = context.getNewPrimaryKeysMap(JournalStructure.class);
        String parentStructureId = MapUtil.getString((Map)structureIds, (String)feed.getStructureId(), (String)feed.getStructureId());
        Map templateIds = context.getNewPrimaryKeysMap(JournalTemplate.class);
        String parentTemplateId = MapUtil.getString((Map)templateIds, (String)feed.getTemplateId(), (String)feed.getTemplateId());
        String parentRenderTemplateId = MapUtil.getString((Map)templateIds, (String)feed.getRendererTemplateId(), (String)feed.getRendererTemplateId());
        JournalCreationStrategy creationStrategy = JournalCreationStrategyFactory.getInstance();
        long authorId = creationStrategy.getAuthorUserId(context, feed);
        if (authorId != 0L) {
            userId = authorId;
        }
        boolean addCommunityPermissions = creationStrategy.addCommunityPermissions(context, feed);
        boolean addGuestPermissions = creationStrategy.addGuestPermissions(context, feed);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(addCommunityPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        serviceContext.setCreateDate(feed.getCreateDate());
        serviceContext.setModifiedDate(feed.getModifiedDate());
        JournalFeed existingFeed = null;
        if (context.isDataStrategyMirror()) {
            existingFeed = JournalFeedUtil.fetchByUUID_G((String)feed.getUuid(), (long)context.getScopeGroupId());
            if (existingFeed == null) {
                serviceContext.setUuid(feed.getUuid());
                existingFeed = JournalFeedLocalServiceUtil.addFeed((long)userId, (long)context.getScopeGroupId(), (String)feedId, (boolean)autoFeedId, (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentStructureId, (String)parentTemplateId, (String)parentRenderTemplateId, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedType(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
            } else {
                existingFeed = JournalFeedLocalServiceUtil.updateFeed((long)existingFeed.getGroupId(), (String)existingFeed.getFeedId(), (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentStructureId, (String)parentTemplateId, (String)parentRenderTemplateId, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedType(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
            }
        } else {
            existingFeed = JournalFeedLocalServiceUtil.addFeed((long)userId, (long)context.getScopeGroupId(), (String)feedId, (boolean)autoFeedId, (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentStructureId, (String)parentTemplateId, (String)parentRenderTemplateId, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedType(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
        }
        Map feedIds = context.getNewPrimaryKeysMap(JournalFeed.class);
        feedIds.put(feedId, existingFeed.getFeedId());
        context.importPermissions(JournalFeed.class, feed.getId(), existingFeed.getId());
        if (!feedId.equals(existingFeed.getFeedId()) && _log.isWarnEnabled()) {
            _log.warn((Object)("A feed with the ID " + feedId + " already " + "exists. The new generated ID is " + existingFeed.getFeedId()));
        }
    }

    protected static String importIGImages(PortletDataContext context, Element parentElement, String content) throws Exception {
        Map imagePKs = context.getNewPrimaryKeysMap(IGImage.class);
        List igReferenceElements = parentElement.elements("ig-reference");
        for (Element igReferenceElement : igReferenceElements) {
            long imageId;
            String igReferencePath = igReferenceElement.attributeValue("path");
            IGImage image = (IGImage)context.getZipEntryAsObject(igReferencePath);
            if (image == null || (image = IGImageUtil.fetchByPrimaryKey((long)(imageId = MapUtil.getLong((Map)imagePKs, (long)image.getImageId(), (long)image.getImageId())))) == null) continue;
            String igReference = "[$ig-reference=" + igReferencePath + "$]";
            StringBundler sb = new StringBundler(6);
            sb.append("/image/image_gallery?uuid=");
            sb.append(image.getUuid());
            sb.append("&groupId=");
            sb.append(context.getScopeGroupId());
            sb.append("&t=");
            sb.append(System.currentTimeMillis());
            content = StringUtil.replace((String)content, (String)igReference, (String)sb.toString());
        }
        return content;
    }

    protected static void importStructure(PortletDataContext context, Element structureElement) throws Exception {
        JournalCreationStrategy creationStrategy;
        long authorId;
        String path = structureElement.attributeValue("path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        JournalStructure structure = (JournalStructure)context.getZipEntryAsObject(path);
        long userId = context.getUserId(structure.getUserUuid());
        String structureId = structure.getStructureId();
        boolean autoStructureId = false;
        if (Validator.isNumber((String)structureId) || JournalStructureUtil.fetchByG_S((long)context.getScopeGroupId(), (String)structureId) != null) {
            autoStructureId = true;
        }
        if ((authorId = (creationStrategy = JournalCreationStrategyFactory.getInstance()).getAuthorUserId(context, structure)) != 0L) {
            userId = authorId;
        }
        boolean addCommunityPermissions = creationStrategy.addCommunityPermissions(context, structure);
        boolean addGuestPermissions = creationStrategy.addGuestPermissions(context, structure);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(addCommunityPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        serviceContext.setCreateDate(structure.getCreateDate());
        serviceContext.setModifiedDate(structure.getModifiedDate());
        JournalStructure existingStructure = null;
        if (context.isDataStrategyMirror()) {
            existingStructure = JournalStructureUtil.fetchByUUID_G((String)structure.getUuid(), (long)context.getScopeGroupId());
            if (existingStructure == null) {
                serviceContext.setUuid(structure.getUuid());
                existingStructure = JournalStructureLocalServiceUtil.addStructure((long)userId, (long)context.getScopeGroupId(), (String)structureId, (boolean)autoStructureId, (String)structure.getParentStructureId(), (String)structure.getName(), (String)structure.getDescription(), (String)structure.getXsd(), (ServiceContext)serviceContext);
            } else {
                existingStructure = JournalStructureLocalServiceUtil.updateStructure((long)existingStructure.getGroupId(), (String)existingStructure.getStructureId(), (String)structure.getParentStructureId(), (String)structure.getName(), (String)structure.getDescription(), (String)structure.getXsd(), (ServiceContext)serviceContext);
            }
        } else {
            existingStructure = JournalStructureLocalServiceUtil.addStructure((long)userId, (long)context.getScopeGroupId(), (String)structureId, (boolean)autoStructureId, (String)structure.getParentStructureId(), (String)structure.getName(), (String)structure.getDescription(), (String)structure.getXsd(), (ServiceContext)serviceContext);
        }
        Map structureIds = context.getNewPrimaryKeysMap(JournalStructure.class);
        structureIds.put(structureId, existingStructure.getStructureId());
        context.importPermissions(JournalStructure.class, structure.getId(), existingStructure.getId());
        if (!structureId.equals(existingStructure.getStructureId()) && _log.isWarnEnabled()) {
            _log.warn((Object)("A structure with the ID " + structureId + " already " + "exists. The new generated ID is " + existingStructure.getStructureId()));
        }
    }

    protected static void importTemplate(PortletDataContext context, Element templateElement) throws Exception {
        String path = templateElement.attributeValue("path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        JournalTemplate template = (JournalTemplate)context.getZipEntryAsObject(path);
        long userId = context.getUserId(template.getUserUuid());
        String templateId = template.getTemplateId();
        boolean autoTemplateId = false;
        if (Validator.isNumber((String)templateId) || JournalTemplateUtil.fetchByG_T((long)context.getScopeGroupId(), (String)templateId) != null) {
            autoTemplateId = true;
        }
        Map structureIds = context.getNewPrimaryKeysMap(JournalStructure.class);
        String parentStructureId = MapUtil.getString((Map)structureIds, (String)template.getStructureId(), (String)template.getStructureId());
        String xsl = template.getXsl();
        xsl = JournalPortletDataHandlerImpl.importDLFileEntries(context, templateElement, xsl);
        xsl = JournalPortletDataHandlerImpl.importIGImages(context, templateElement, xsl);
        Group group = GroupLocalServiceUtil.getGroup((long)context.getScopeGroupId());
        xsl = StringUtil.replace((String)xsl, (String)"@data_handler_group_friendly_url@", (String)group.getFriendlyURL());
        template.setXsl(xsl);
        boolean formatXsl = false;
        JournalCreationStrategy creationStrategy = JournalCreationStrategyFactory.getInstance();
        long authorId = creationStrategy.getAuthorUserId(context, template);
        if (authorId != 0L) {
            userId = authorId;
        }
        boolean addCommunityPermissions = creationStrategy.addCommunityPermissions(context, template);
        boolean addGuestPermissions = creationStrategy.addGuestPermissions(context, template);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(addCommunityPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        serviceContext.setCreateDate(template.getCreateDate());
        serviceContext.setModifiedDate(template.getModifiedDate());
        File smallFile = null;
        String smallImagePath = templateElement.attributeValue("small-image-path");
        if (template.isSmallImage() && Validator.isNotNull((String)smallImagePath)) {
            byte[] bytes;
            if (smallImagePath.endsWith(".")) {
                smallImagePath = String.valueOf(smallImagePath) + template.getSmallImageType();
            }
            if ((bytes = context.getZipEntryAsByteArray(smallImagePath)) != null) {
                smallFile = File.createTempFile(String.valueOf(template.getSmallImageId()), "." + template.getSmallImageType());
                FileUtil.write((File)smallFile, (byte[])bytes);
            }
        }
        JournalTemplate existingTemplate = null;
        if (context.isDataStrategyMirror()) {
            existingTemplate = JournalTemplateUtil.fetchByUUID_G((String)template.getUuid(), (long)context.getScopeGroupId());
            if (existingTemplate == null) {
                serviceContext.setUuid(template.getUuid());
                existingTemplate = JournalTemplateLocalServiceUtil.addTemplate((long)userId, (long)context.getScopeGroupId(), (String)templateId, (boolean)autoTemplateId, (String)parentStructureId, (String)template.getName(), (String)template.getDescription(), (String)template.getXsl(), (boolean)formatXsl, (String)template.getLangType(), (boolean)template.getCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
            } else {
                existingTemplate = JournalTemplateLocalServiceUtil.updateTemplate((long)existingTemplate.getGroupId(), (String)existingTemplate.getTemplateId(), (String)existingTemplate.getStructureId(), (String)template.getName(), (String)template.getDescription(), (String)template.getXsl(), (boolean)formatXsl, (String)template.getLangType(), (boolean)template.getCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
            }
        } else {
            existingTemplate = JournalTemplateLocalServiceUtil.addTemplate((long)userId, (long)context.getScopeGroupId(), (String)templateId, (boolean)autoTemplateId, (String)parentStructureId, (String)template.getName(), (String)template.getDescription(), (String)template.getXsl(), (boolean)formatXsl, (String)template.getLangType(), (boolean)template.getCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
        }
        Map templateIds = context.getNewPrimaryKeysMap(JournalTemplate.class);
        templateIds.put(templateId, existingTemplate.getTemplateId());
        context.importPermissions(JournalTemplate.class, template.getId(), existingTemplate.getId());
        if (!templateId.equals(existingTemplate.getTemplateId()) && _log.isWarnEnabled()) {
            _log.warn((Object)("A template with the ID " + templateId + " already " + "exists. The new generated ID is " + existingTemplate.getTemplateId()));
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_articles, _structuresTemplatesAndFeeds, _embeddedAssets, _images, _categories, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_articles, _structuresTemplatesAndFeeds, _images, _categories, _comments, _ratings, _tags};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return PropsValues.JOURNAL_PUBLISH_TO_LIVE_BY_DEFAULT;
    }

    protected PortletPreferences doDeleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        if (!context.addPrimaryKey(JournalPortletDataHandlerImpl.class, "deleteData")) {
            JournalArticleLocalServiceUtil.deleteArticles((long)context.getScopeGroupId());
            JournalTemplateLocalServiceUtil.deleteTemplates((long)context.getScopeGroupId());
            JournalStructureLocalServiceUtil.deleteStructures((long)context.getScopeGroupId());
        }
        return preferences;
    }

    protected String doExportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        context.addPermissions("com.liferay.portlet.journal", context.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("journal-data");
        rootElement.addAttribute("group-id", String.valueOf(context.getScopeGroupId()));
        Element structuresElement = rootElement.addElement("structures");
        List structures = JournalStructureUtil.findByGroupId((long)context.getScopeGroupId());
        for (JournalStructure structure : structures) {
            if (!context.isWithinDateRange(structure.getModifiedDate())) continue;
            JournalPortletDataHandlerImpl.exportStructure(context, structuresElement, structure);
        }
        Element templatesElement = rootElement.addElement("templates");
        Element dlFoldersElement = rootElement.addElement("dl-folders");
        Element dlFilesElement = rootElement.addElement("dl-file-entries");
        Element dlFileRanksElement = rootElement.addElement("dl-file-ranks");
        Element igFoldersElement = rootElement.addElement("ig-folders");
        Element igImagesElement = rootElement.addElement("ig-images");
        List templates = JournalTemplateUtil.findByGroupId((long)context.getScopeGroupId());
        for (JournalTemplate template : templates) {
            if (!context.isWithinDateRange(template.getModifiedDate())) continue;
            JournalPortletDataHandlerImpl.exportTemplate(context, templatesElement, dlFoldersElement, dlFilesElement, dlFileRanksElement, igFoldersElement, igImagesElement, template, true);
        }
        Element feedsElement = rootElement.addElement("feeds");
        List feeds = JournalFeedUtil.findByGroupId((long)context.getScopeGroupId());
        for (JournalFeed feed : feeds) {
            if (!context.isWithinDateRange(feed.getModifiedDate())) continue;
            JournalPortletDataHandlerImpl.exportFeed(context, feedsElement, feed);
        }
        Element articlesElement = rootElement.addElement("articles");
        if (context.getBooleanParameter(_NAMESPACE, "articles")) {
            List articles = JournalArticleUtil.findByG_ST((long)context.getScopeGroupId(), (int)0, (int)-1, (int)-1, (OrderByComparator)new ArticleIDComparator(true));
            for (JournalArticle article : articles) {
                JournalPortletDataHandlerImpl.exportArticle(context, articlesElement, structuresElement, templatesElement, dlFoldersElement, dlFilesElement, dlFileRanksElement, igFoldersElement, igImagesElement, article, true);
            }
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws Exception {
        context.importPermissions("com.liferay.portlet.journal", context.getSourceGroupId(), context.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element dlFoldersElement = rootElement.element("dl-folders");
        List dlFolderElements = dlFoldersElement.elements("folder");
        for (Element dlFolderElement : dlFolderElements) {
            DLPortletDataHandlerImpl.importFolder(context, dlFolderElement);
        }
        Element dlFileEntriesElement = rootElement.element("dl-file-entries");
        List dlFileEntryElements = dlFileEntriesElement.elements("file-entry");
        for (Element dlFileEntryElement : dlFileEntryElements) {
            DLPortletDataHandlerImpl.importFileEntry(context, dlFileEntryElement);
        }
        Element dlFileRanksElement = rootElement.element("dl-file-ranks");
        List dlFileRankElements = dlFileRanksElement.elements("file-rank");
        for (Element dlFileRankElement : dlFileRankElements) {
            DLPortletDataHandlerImpl.importFileRank(context, dlFileRankElement);
        }
        Element igFoldersElement = rootElement.element("ig-folders");
        List igFolderElements = igFoldersElement.elements("folder");
        for (Element igFolderElement : igFolderElements) {
            IGPortletDataHandlerImpl.importFolder(context, igFolderElement);
        }
        Element igImagesElement = rootElement.element("ig-images");
        List igImageElements = igImagesElement.elements("image");
        for (Element igImageElement : igImageElements) {
            IGPortletDataHandlerImpl.importImage(context, igImageElement);
        }
        Element structuresElement = rootElement.element("structures");
        List structureElements = structuresElement.elements("structure");
        for (Element structureElement : structureElements) {
            JournalPortletDataHandlerImpl.importStructure(context, structureElement);
        }
        Element templatesElement = rootElement.element("templates");
        List templateElements = templatesElement.elements("template");
        for (Element templateElement : templateElements) {
            JournalPortletDataHandlerImpl.importTemplate(context, templateElement);
        }
        Element feedsElement = rootElement.element("feeds");
        List feedElements = feedsElement.elements("feed");
        for (Element feedElement : feedElements) {
            JournalPortletDataHandlerImpl.importFeed(context, feedElement);
        }
        if (context.getBooleanParameter(_NAMESPACE, "articles")) {
            Element articlesElement = rootElement.element("articles");
            List articleElements = articlesElement.elements("article");
            for (Element articleElement : articleElements) {
                JournalPortletDataHandlerImpl.importArticle(context, articleElement);
            }
        }
        return preferences;
    }
}

