/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.social;

import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;

public class DLActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{DLFileEntry.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected SocialActivityFeedEntry doInterpret(SocialActivity activity, ThemeDisplay themeDisplay) throws Exception {
        DLFileEntry fileEntry;
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!DLFileEntryPermission.contains(permissionChecker, fileEntry = DLFileEntryLocalServiceUtil.getDLFileEntry((long)activity.getClassPK()), "VIEW")) {
            return null;
        }
        String groupName = "";
        if (activity.getGroupId() != themeDisplay.getScopeGroupId()) {
            groupName = this.getGroupName(activity.getGroupId(), themeDisplay);
        }
        String creatorUserName = this.getUserName(activity.getUserId(), themeDisplay);
        int activityType = activity.getType();
        String link = String.valueOf(themeDisplay.getPortalURL()) + themeDisplay.getPathMain() + "/document_library/get_file?groupId=" + fileEntry.getGroupId() + "&folderId=" + fileEntry.getFolderId() + "&name=" + fileEntry.getName();
        String titlePattern = null;
        if (activityType == 1) {
            titlePattern = "activity-document-library-add-file";
        } else if (activityType == 2) {
            titlePattern = "activity-document-library-update-file";
        }
        if (Validator.isNotNull((String)groupName)) {
            titlePattern = String.valueOf(titlePattern) + "-in";
        }
        String fileTitle = this.wrapLink(link, HtmlUtil.escape((String)this.cleanContent(fileEntry.getTitle())));
        Object[] titleArguments = new Object[]{groupName, creatorUserName, fileTitle};
        String title = themeDisplay.translate(titlePattern, titleArguments);
        StringBundler sb = new StringBundler(3);
        String fileEntryLink = String.valueOf(themeDisplay.getPortalURL()) + themeDisplay.getPathMain() + "/document_library/find_file_entry?fileEntryId=" + fileEntry.getFileEntryId();
        sb.append(this.wrapLink(fileEntryLink, "view-document", themeDisplay));
        sb.append(" ");
        String folderLink = String.valueOf(themeDisplay.getPortalURL()) + themeDisplay.getPathMain() + "/document_library/find_folder?groupId=" + fileEntry.getGroupId() + "&folderId=" + fileEntry.getFolderId();
        sb.append(this.wrapLink(folderLink, "go-to-folder", themeDisplay));
        String body = sb.toString();
        return new SocialActivityFeedEntry(link, title, body);
    }
}

