/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.ExpiredLockException;
import com.liferay.portal.InvalidLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFolderServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import java.io.File;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFolderServiceImpl
extends DLFolderServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFolderServiceImpl.class);

    public DLFolder addFolder(long groupId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, parentFolderId, "ADD_FOLDER");
        return this.dlFolderLocalService.addFolder(this.getUserId(), groupId, parentFolderId, name, description, serviceContext);
    }

    public DLFolder copyFolder(long groupId, long sourceFolderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, RemoteException, SystemException {
        DLFolder srcFolder = this.getFolder(sourceFolderId);
        DLFolder destFolder = this.addFolder(groupId, parentFolderId, name, description, serviceContext);
        this.copyFolder(srcFolder, destFolder, serviceContext);
        return destFolder;
    }

    public void deleteFolder(long folderId) throws PortalException, RemoteException, SystemException {
        DLFolder folder = this.dlFolderLocalService.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        boolean hasLock = this.lockLocalService.hasLock(this.getUserId(), DLFolder.class.getName(), folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(folderId);
        }
        try {
            this.dlFolderLocalService.deleteFolder(folderId);
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folder.getGroupId(), folderId, lock.getUuid());
            }
        }
    }

    public void deleteFolder(long groupId, long parentFolderId, String name) throws PortalException, RemoteException, SystemException {
        long folderId = this.getFolderId(groupId, parentFolderId, name);
        this.deleteFolder(folderId);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long groupId, List<Long> folderIds, int status, int start, int end) throws SystemException {
        return this.dlFolderFinder.filterFindFE_FS_ByG_F_S(groupId, folderIds, status, start, end);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long groupId, long folderId, int status, int start, int end) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFolderFinder.filterFindFE_FS_ByG_F_S(groupId, folderIds, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, List<Long> folderIds, int status) throws SystemException {
        return this.dlFolderFinder.filterCountFE_FS_ByG_F_S(groupId, folderIds, status);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFolderFinder.filterCountFE_FS_ByG_F_S(groupId, folderIds, status);
    }

    public DLFolder getFolder(long folderId) throws PortalException, SystemException {
        DLFolder folder = this.dlFolderLocalService.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), folder, "VIEW");
        return folder;
    }

    public DLFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        DLFolder folder = this.dlFolderLocalService.getFolder(groupId, parentFolderId, name);
        DLFolderPermission.check(this.getPermissionChecker(), folder, "VIEW");
        return folder;
    }

    public long getFolderId(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        DLFolder folder = this.getFolder(groupId, parentFolderId, name);
        return folder.getFolderId();
    }

    public long[] getFolderIds(long groupId, long folderId) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        this.getSubfolderIds(folderIds, groupId, folderId);
        return ArrayUtil.toArray((Long[])folderIds.toArray(new Long[folderIds.size()]));
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.dlFolderPersistence.filterFindByG_P(groupId, parentFolderId);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, int start, int end) throws SystemException {
        return this.dlFolderPersistence.filterFindByG_P(groupId, parentFolderId, start, end);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, List<Long> folderIds, int status, int start, int end) throws SystemException {
        return this.dlFolderFinder.filterFindF_FE_FS_ByG_F_S(groupId, folderIds, status, start, end);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, int start, int end) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "VIEW");
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.getFoldersAndFileEntriesAndFileShortcuts(groupId, folderIds, status, start, end);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, List<Long> folderIds, int status) throws SystemException {
        return this.dlFolderFinder.filterCountF_FE_FS_ByG_F_S(groupId, folderIds, status);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "VIEW");
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(groupId, folderIds, status);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.dlFolderPersistence.filterCountByG_P(groupId, parentFolderId);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List folders = this.dlFolderPersistence.filterFindByG_P(groupId, folderId);
        for (DLFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    public boolean hasInheritableLock(long folderId) throws PortalException, SystemException {
        boolean inheritable = false;
        try {
            Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
            inheritable = lock.isInheritable();
        }
        catch (ExpiredLockException expiredLockException) {
        }
        catch (NoSuchLockException noSuchLockException) {}
        return inheritable;
    }

    public Lock lockFolder(long folderId) throws PortalException, RemoteException, SystemException {
        return this.lockFolder(folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
    }

    /*
     * Unable to fully structure code
     */
    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException, RemoteException, SystemException {
        block8: {
            if (expirationTime <= 0L || expirationTime > DLFolderImpl.LOCK_EXPIRATION_TIME) {
                expirationTime = DLFolderImpl.LOCK_EXPIRATION_TIME;
            }
            lock = this.lockLocalService.lock(this.getUser().getUserId(), DLFolder.class.getName(), folderId, owner, inheritable, expirationTime);
            fileNames = new HashSet<String>();
            folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            groupId = folder.getGroupId();
            try {
                fileEntries = this.dlFileEntryService.getFileEntries(groupId, folderId);
                for (DLFileEntry fileEntry : fileEntries) {
                    this.dlFileEntryService.lockFileEntry(groupId, folderId, fileEntry.getName(), owner, expirationTime);
                    fileNames.add(fileEntry.getName());
                }
                break block8;
            }
            catch (Exception e) {
                ** for (fileName : fileNames)
            }
lbl-1000:
            // 1 sources

            {
                this.dlFileEntryService.unlockFileEntry(groupId, folderId, fileName);
                continue;
            }
lbl20:
            // 1 sources

            this.unlockFolder(groupId, folderId, lock.getUuid());
            if (e instanceof PortalException) {
                throw (PortalException)e;
            }
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            if (e instanceof SystemException) {
                throw (SystemException)e;
            }
            throw new PortalException((Throwable)e);
        }
        return lock;
    }

    public Lock refreshFolderLock(String lockUuid, long expirationTime) throws PortalException, SystemException {
        return this.lockLocalService.refresh(lockUuid, expirationTime);
    }

    public void unlockFolder(long groupId, long folderId, String lockUuid) throws PortalException, SystemException {
        block7: {
            if (Validator.isNotNull((String)lockUuid)) {
                try {
                    Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
                    if (!lock.getUuid().equals(lockUuid)) {
                        throw new InvalidLockException("UUIDs do not match");
                    }
                }
                catch (PortalException pe) {
                    if (pe instanceof ExpiredLockException || pe instanceof NoSuchLockException) break block7;
                    throw pe;
                }
            }
        }
        this.lockLocalService.unlock(DLFolder.class.getName(), folderId);
        try {
            List fileEntries = this.dlFileEntryLocalService.getFileEntries(groupId, folderId);
            for (DLFileEntry fileEntry : fileEntries) {
                this.dlFileEntryService.unlockFileEntry(groupId, folderId, fileEntry.getName());
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void unlockFolder(long groupId, long parentFolderId, String name, String lockUuid) throws PortalException, SystemException {
        long folderId = this.getFolderId(groupId, parentFolderId, name);
        this.unlockFolder(groupId, folderId, lockUuid);
    }

    public DLFolder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, RemoteException, SystemException {
        DLFolder folder = this.dlFolderLocalService.getFolder(folderId);
        DLFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        boolean hasLock = this.lockLocalService.hasLock(this.getUserId(), DLFolder.class.getName(), folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(folderId);
        }
        try {
            DLFolder dLFolder = this.dlFolderLocalService.updateFolder(folderId, parentFolderId, name, description, serviceContext);
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folder.getGroupId(), folderId, lock.getUuid());
            }
        }
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException, SystemException {
        boolean verified = false;
        try {
            Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
            if (!lock.isInheritable()) {
                throw new NoSuchLockException();
            }
            if (lock.getUuid().equals(lockUuid)) {
                verified = true;
            }
        }
        catch (ExpiredLockException ele) {
            throw new NoSuchLockException((Throwable)ele);
        }
        return verified;
    }

    protected void copyFolder(DLFolder srcFolder, DLFolder destFolder, ServiceContext serviceContext) throws PortalException, RemoteException, SystemException {
        String description;
        List srcFileEntries = this.dlFileEntryService.getFileEntries(srcFolder.getGroupId(), srcFolder.getFolderId());
        for (DLFileEntry srcFileEntry : srcFileEntries) {
            String name = srcFileEntry.getName();
            String title = srcFileEntry.getTitle();
            description = srcFileEntry.getDescription();
            String extraSettings = srcFileEntry.getExtraSettings();
            File file = null;
            try {
                file = FileUtil.createTempFile((String)FileUtil.getExtension((String)title));
                InputStream is = this.dlLocalService.getFileAsStream(srcFolder.getCompanyId(), srcFolder.getFolderId(), name);
                FileUtil.write((File)file, (InputStream)is);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                continue;
            }
            this.dlFileEntryService.addFileEntry(destFolder.getGroupId(), destFolder.getFolderId(), name, title, description, null, extraSettings, file, serviceContext);
            file.delete();
        }
        List<DLFolder> srcSubfolders = this.getFolders(srcFolder.getGroupId(), srcFolder.getFolderId());
        for (DLFolder srcSubfolder : srcSubfolders) {
            String name = srcSubfolder.getName();
            description = srcSubfolder.getDescription();
            DLFolder destSubfolder = this.addFolder(destFolder.getGroupId(), destFolder.getFolderId(), name, description, serviceContext);
            this.copyFolder(srcSubfolder, destSubfolder, serviceContext);
        }
    }
}

