/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.documentlibrary.NoSuchDirectoryException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.base.DLFolderLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFolderLocalServiceImpl
extends DLFolderLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFolderLocalServiceImpl.class);

    public DLFolder addFolder(long userId, long groupId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        Date now = new Date();
        this.validate(groupId, parentFolderId, name);
        long folderId = this.counterLocalService.increment();
        DLFolder folder = this.dlFolderPersistence.create(folderId);
        folder.setUuid(serviceContext.getUuid());
        folder.setGroupId(groupId);
        folder.setCompanyId(user.getCompanyId());
        folder.setUserId(user.getUserId());
        folder.setCreateDate(serviceContext.getCreateDate(now));
        folder.setModifiedDate(serviceContext.getModifiedDate(now));
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.dlFolderPersistence.update((BaseModel)folder, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addFolderResources(folder, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addFolderResources(folder, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        if (PropsValues.DL_LAYOUTS_SYNC_ENABLED && parentFolderId != 0L) {
            String[] pathArray = folder.getPathArray();
            String layoutsSyncPrivateFolder = GetterUtil.getString((String)PropsUtil.get("dl.layouts.sync.private.folder"));
            String layoutsSyncPublicFolder = GetterUtil.getString((String)PropsUtil.get("dl.layouts.sync.public.folder"));
            if (pathArray[0].equals(layoutsSyncPrivateFolder) || pathArray[0].equals(layoutsSyncPublicFolder)) {
                boolean privateLayout = true;
                if (pathArray[0].equals(layoutsSyncPublicFolder)) {
                    privateLayout = false;
                }
                long parentLayoutId = 0L;
                String title = "";
                String layoutDescription = "";
                String type = "portlet";
                boolean hidden = false;
                String friendlyURL = "";
                Layout dlFolderLayout = null;
                try {
                    dlFolderLayout = this.layoutLocalService.getDLFolderLayout(folder.getParentFolderId());
                    parentLayoutId = dlFolderLayout.getLayoutId();
                }
                catch (NoSuchLayoutException noSuchLayoutException) {}
                this.layoutLocalService.addLayout(userId, groupId, privateLayout, parentLayoutId, name, title, layoutDescription, type, hidden, friendlyURL, folder.getFolderId(), new ServiceContext());
            }
        }
        if (parentFolderId != 0L) {
            DLFolder parentFolder = this.dlFolderPersistence.findByPrimaryKey(parentFolderId);
            parentFolder.setLastPostDate(now);
            this.dlFolderPersistence.update((BaseModel)parentFolder, false);
        }
        return folder;
    }

    public void addFolderResources(DLFolder folder, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(folder.getCompanyId(), folder.getGroupId(), folder.getUserId(), DLFolder.class.getName(), folder.getFolderId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addFolderResources(DLFolder folder, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(folder.getCompanyId(), folder.getGroupId(), folder.getUserId(), DLFolder.class.getName(), folder.getFolderId(), communityPermissions, guestPermissions);
    }

    public void addFolderResources(long folderId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(folder, addCommunityPermissions, addGuestPermissions);
    }

    public void addFolderResources(long folderId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(folder, communityPermissions, guestPermissions);
    }

    public void deleteFolder(DLFolder folder) throws PortalException, SystemException {
        block3: {
            List folders = this.dlFolderPersistence.findByG_P(folder.getGroupId(), folder.getFolderId());
            for (DLFolder curFolder : folders) {
                this.deleteFolder(curFolder);
            }
            this.dlFolderPersistence.remove((BaseModel)folder);
            this.resourceLocalService.deleteResource(folder.getCompanyId(), DLFolder.class.getName(), 4, folder.getFolderId());
            this.webDAVPropsLocalService.deleteWebDAVProps(DLFolder.class.getName(), folder.getFolderId());
            this.dlFileEntryLocalService.deleteFileEntries(folder.getGroupId(), folder.getFolderId());
            this.expandoValueLocalService.deleteValues(DLFolder.class.getName(), folder.getFolderId());
            try {
                this.dlService.deleteDirectory(folder.getCompanyId(), "20", folder.getFolderId(), "");
            }
            catch (NoSuchDirectoryException nsde) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)nsde.getMessage());
            }
        }
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.deleteFolder(folder);
    }

    public void deleteFolders(long groupId) throws PortalException, SystemException {
        List folders = this.dlFolderPersistence.findByG_P(groupId, 0L);
        for (DLFolder folder : folders) {
            this.deleteFolder(folder);
        }
    }

    public List<DLFolder> getCompanyFolders(long companyId, int start, int end) throws SystemException {
        return this.dlFolderPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyFoldersCount(long companyId) throws SystemException {
        return this.dlFolderPersistence.countByCompanyId(companyId);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long groupId, List<Long> folderIds, int status, int start, int end) throws SystemException {
        return this.dlFolderFinder.findFE_FS_ByG_F_S(groupId, folderIds, status, start, end);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long groupId, long folderId, int status, int start, int end) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFolderFinder.findFE_FS_ByG_F_S(groupId, folderIds, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, List<Long> folderIds, int status) throws SystemException {
        return this.dlFolderFinder.countFE_FS_ByG_F_S(groupId, folderIds, status);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFolderFinder.countFE_FS_ByG_F_S(groupId, folderIds, status);
    }

    public DLFolder getFolder(long folderId) throws PortalException, SystemException {
        return this.dlFolderPersistence.findByPrimaryKey(folderId);
    }

    public DLFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        return this.dlFolderPersistence.findByG_P_N(groupId, parentFolderId, name);
    }

    public List<DLFolder> getFolders(long companyId) throws SystemException {
        return this.dlFolderPersistence.findByCompanyId(companyId);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.dlFolderPersistence.findByG_P(groupId, parentFolderId);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, int start, int end) throws SystemException {
        return this.dlFolderPersistence.findByG_P(groupId, parentFolderId, start, end);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, List<Long> folderIds, int status, int start, int end) throws SystemException {
        return this.dlFolderFinder.findF_FE_FS_ByG_F_S(groupId, folderIds, status, start, end);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, int start, int end) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.getFoldersAndFileEntriesAndFileShortcuts(groupId, folderIds, status, start, end);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, List<Long> folderIds, int status) throws SystemException {
        return this.dlFolderFinder.countF_FE_FS_ByG_F_S(groupId, folderIds, status);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(groupId, folderIds, status);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.dlFolderPersistence.countByG_P(groupId, parentFolderId);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List folders = this.dlFolderPersistence.findByG_P(groupId, folderId);
        for (DLFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    public DLFolder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        this.validate(folder.getFolderId(), folder.getGroupId(), parentFolderId, name);
        folder.setModifiedDate(serviceContext.getModifiedDate(null));
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.dlFolderPersistence.update((BaseModel)folder, false);
        if (PropsValues.DL_LAYOUTS_SYNC_ENABLED) {
            String privateFolder = GetterUtil.getString((String)PropsUtil.get("dl.layouts.sync.private.folder"));
            boolean privateLayout = false;
            String[] path = folder.getPathArray();
            if (path[0].equals(privateFolder)) {
                privateLayout = true;
            }
            Layout layout = this.layoutLocalService.getDLFolderLayout(folder.getFolderId());
            layout.setName(folder.getName());
            this.layoutLocalService.updateName(folder.getGroupId(), privateLayout, layout.getLayoutId(), folder.getName(), LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
        }
        return folder;
    }

    protected long getParentFolderId(DLFolder folder, long parentFolderId) throws SystemException {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (folder.getFolderId() == parentFolderId) {
            return folder.getParentFolderId();
        }
        DLFolder parentFolder = this.dlFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentFolder == null || folder.getGroupId() != parentFolder.getGroupId()) {
            return folder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, folder.getGroupId(), folder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return folder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) throws SystemException {
        DLFolder parentFolder;
        if (parentFolderId != 0L && ((parentFolder = this.dlFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected void validate(long folderId, long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        if (!AssetUtil.isValidWord(name)) {
            throw new FolderNameException();
        }
        try {
            this.dlFileEntryLocalService.getFileEntryByTitle(groupId, parentFolderId, name);
            throw new DuplicateFileException();
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            DLFolder folder = this.dlFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
            if (folder != null && folder.getFolderId() != folderId) {
                throw new DuplicateFolderNameException();
            }
            return;
        }
    }

    protected void validate(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        long folderId = 0L;
        this.validate(folderId, groupId, parentFolderId, name);
    }
}

