/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.documentlibrary.service.DLLocalServiceUtil;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileRankLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileShortcutLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileRankUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileShortcutUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.util.PwdGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;

public class DLPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "document_library";
    private static Log _log = LogFactoryUtil.getLog(DLPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("document_library", "categories");
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("document_library", "comments");
    private static PortletDataHandlerBoolean _foldersAndDocuments = new PortletDataHandlerBoolean("document_library", "folders-and-documents", true, true);
    private static PortletDataHandlerBoolean _ranks = new PortletDataHandlerBoolean("document_library", "ranks");
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("document_library", "ratings");
    private static PortletDataHandlerBoolean _shortcuts = new PortletDataHandlerBoolean("document_library", "shortcuts");
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("document_library", "tags");

    public static void exportFileEntry(PortletDataContext context, Element foldersElement, Element fileEntriesElement, Element fileRanksElement, DLFileEntry fileEntry, boolean checkDateRange) throws Exception {
        String path;
        if (checkDateRange && !context.isWithinDateRange(fileEntry.getModifiedDate())) {
            return;
        }
        DLFileVersion fileVersion = DLFileVersionLocalServiceUtil.getFileVersion((long)context.getScopeGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName(), (String)fileEntry.getVersion());
        if (fileVersion.getStatus() != 0) {
            return;
        }
        if (foldersElement != null) {
            DLPortletDataHandlerImpl.exportParentFolder(context, foldersElement, fileEntry.getFolderId());
        }
        if (context.isPathNotProcessed(path = DLPortletDataHandlerImpl.getFileEntryPath(context, fileEntry))) {
            Element fileEntryElement = fileEntriesElement.addElement("file-entry");
            fileEntryElement.addAttribute("path", path);
            String binPath = DLPortletDataHandlerImpl.getFileEntryBinPath(context, fileEntry);
            fileEntryElement.addAttribute("bin-path", binPath);
            fileEntry.setUserUuid(fileEntry.getUserUuid());
            context.addLocks(DLFileEntry.class, DLUtil.getLockId((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName()));
            context.addPermissions(DLFileEntry.class, fileEntry.getFileEntryId());
            if (context.getBooleanParameter(_NAMESPACE, "categories")) {
                context.addAssetCategories(DLFileEntry.class, fileEntry.getFileEntryId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "comments")) {
                context.addComments(DLFileEntry.class, fileEntry.getFileEntryId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
                context.addRatingsEntries(DLFileEntry.class, fileEntry.getFileEntryId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "tags")) {
                context.addAssetTags(DLFileEntry.class, fileEntry.getFileEntryId());
            }
            long repositoryId = DLPortletDataHandlerImpl.getRepositoryId(fileEntry.getGroupId(), fileEntry.getFolderId());
            InputStream is = DLLocalServiceUtil.getFileAsStream((long)fileEntry.getCompanyId(), (long)repositoryId, (String)fileEntry.getName(), (String)fileEntry.getVersion());
            if (is == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No file found for file entry " + fileEntry.getFileEntryId()));
                }
                fileEntryElement.detach();
                return;
            }
            try {
                context.addZipEntry(DLPortletDataHandlerImpl.getFileEntryBinPath(context, fileEntry), is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    _log.error((Object)ioe, (Throwable)ioe);
                }
            }
            context.addZipEntry(path, (Object)fileEntry);
            if (context.getBooleanParameter(_NAMESPACE, "ranks")) {
                List fileRanks = DLFileRankUtil.findByF_N((long)fileEntry.getFolderId(), (String)fileEntry.getName());
                for (DLFileRank fileRank : fileRanks) {
                    DLPortletDataHandlerImpl.exportFileRank(context, fileRanksElement, fileRank);
                }
            }
        }
    }

    public static String getFileEntryPath(PortletDataContext context, DLFileEntry fileEntry) {
        StringBundler sb = new StringBundler(6);
        sb.append(context.getPortletPath("20"));
        sb.append("/file-entries/");
        sb.append(fileEntry.getFileEntryId());
        sb.append("/");
        sb.append(fileEntry.getVersion());
        sb.append(".xml");
        return sb.toString();
    }

    public static void importFileEntry(PortletDataContext context, Element fileEntryElement) throws Exception {
        String path = fileEntryElement.attributeValue("path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        DLFileEntry fileEntry = (DLFileEntry)context.getZipEntryAsObject(path);
        String binPath = fileEntryElement.attributeValue("bin-path");
        long userId = context.getUserId(fileEntry.getUserUuid());
        Map folderPKs = context.getNewPrimaryKeysMap(DLFolder.class);
        long folderId = MapUtil.getLong((Map)folderPKs, (long)fileEntry.getFolderId(), (long)fileEntry.getFolderId());
        long[] assetCategoryIds = null;
        String[] assetTagNames = null;
        if (context.getBooleanParameter(_NAMESPACE, "categories")) {
            assetCategoryIds = context.getAssetCategoryIds(DLFileEntry.class, fileEntry.getFileEntryId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            assetTagNames = context.getAssetTagNames(DLFileEntry.class, fileEntry.getFileEntryId());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setCreateDate(fileEntry.getCreateDate());
        serviceContext.setModifiedDate(fileEntry.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        InputStream is = context.getZipEntryAsInputStream(binPath);
        if (folderId != 0L && folderId == fileEntry.getFolderId()) {
            String folderPath = DLPortletDataHandlerImpl.getImportFolderPath(context, folderId);
            DLFolder folder = (DLFolder)context.getZipEntryAsObject(folderPath);
            DLPortletDataHandlerImpl.importFolder(context, folder);
            folderId = MapUtil.getLong((Map)folderPKs, (long)fileEntry.getFolderId(), (long)fileEntry.getFolderId());
        }
        DLFileEntry importedFileEntry = null;
        String nameWithExtension = fileEntry.getName().concat(".").concat(fileEntry.getExtension());
        if (context.isDataStrategyMirror()) {
            DLFileEntry existingFileEntry = DLFileEntryUtil.fetchByUUID_G((String)fileEntry.getUuid(), (long)context.getScopeGroupId());
            if (existingFileEntry == null) {
                serviceContext.setUuid(fileEntry.getUuid());
                importedFileEntry = DLFileEntryLocalServiceUtil.addFileEntry((long)userId, (long)context.getScopeGroupId(), (long)folderId, (String)nameWithExtension, (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), null, (String)fileEntry.getExtraSettings(), (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            } else if (!DLPortletDataHandlerImpl.isDuplicateFileEntry(fileEntry, existingFileEntry)) {
                importedFileEntry = DLFileEntryLocalServiceUtil.updateFileEntry((long)userId, (long)context.getScopeGroupId(), (long)existingFileEntry.getFolderId(), (String)existingFileEntry.getName(), (String)fileEntry.getTitle(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), null, (boolean)true, (String)fileEntry.getExtraSettings(), (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            } else {
                DLFileVersion latestFileVersion = DLFileVersionLocalServiceUtil.getLatestFileVersion((long)context.getScopeGroupId(), (long)folderId, (String)existingFileEntry.getName());
                DLFileEntryLocalServiceUtil.updateAsset((long)userId, (DLFileEntry)existingFileEntry, (DLFileVersion)latestFileVersion, (long[])assetCategoryIds, (String[])assetTagNames);
                Indexer indexer = IndexerRegistryUtil.getIndexer(DLFileEntry.class);
                indexer.reindex((Object)existingFileEntry);
                importedFileEntry = existingFileEntry;
            }
        } else {
            String title = fileEntry.getTitle();
            try {
                importedFileEntry = DLFileEntryLocalServiceUtil.addFileEntry((long)userId, (long)context.getScopeGroupId(), (long)folderId, (String)nameWithExtension, (String)title, (String)fileEntry.getDescription(), null, (String)fileEntry.getExtraSettings(), (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            }
            catch (DuplicateFileException duplicateFileException) {
                String[] titleParts = title.split("\\.", 2);
                title = String.valueOf(titleParts[0]) + PwdGenerator.getPassword();
                if (titleParts.length > 1) {
                    title = String.valueOf(title) + "." + titleParts[1];
                }
                importedFileEntry = DLFileEntryLocalServiceUtil.addFileEntry((long)userId, (long)context.getScopeGroupId(), (long)folderId, (String)nameWithExtension, (String)title, (String)fileEntry.getDescription(), null, (String)fileEntry.getExtraSettings(), (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            }
        }
        Map fileEntryPKs = context.getNewPrimaryKeysMap(DLFileEntry.class);
        fileEntryPKs.put(fileEntry.getFileEntryId(), importedFileEntry.getFileEntryId());
        Map fileEntryNames = context.getNewPrimaryKeysMap(String.valueOf(DLFileEntry.class.getName()) + ".name");
        fileEntryNames.put(fileEntry.getName(), importedFileEntry.getName());
        String lockKey = DLUtil.getLockId((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName());
        String newLockKey = DLUtil.getLockId((long)importedFileEntry.getGroupId(), (long)importedFileEntry.getFolderId(), (String)importedFileEntry.getName());
        context.importLocks(DLFileEntry.class, lockKey, newLockKey);
        context.importPermissions(DLFileEntry.class, fileEntry.getFileEntryId(), importedFileEntry.getFileEntryId());
        if (context.getBooleanParameter(_NAMESPACE, "comments")) {
            context.importComments(DLFileEntry.class, fileEntry.getFileEntryId(), importedFileEntry.getFileEntryId(), context.getScopeGroupId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
            context.importRatingsEntries(DLFileEntry.class, fileEntry.getFileEntryId(), importedFileEntry.getFileEntryId());
        }
    }

    public static void importFileRank(PortletDataContext context, Element fileRankElement) throws Exception {
        String path = fileRankElement.attributeValue("path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        DLFileRank fileRank = (DLFileRank)context.getZipEntryAsObject(path);
        DLPortletDataHandlerImpl.importFileRank(context, fileRank);
    }

    public static void importFolder(PortletDataContext context, Element folderElement) throws Exception {
        String path = folderElement.attributeValue("path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        DLFolder folder = (DLFolder)context.getZipEntryAsObject(path);
        DLPortletDataHandlerImpl.importFolder(context, folder);
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_foldersAndDocuments, _shortcuts, _ranks, _categories, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_foldersAndDocuments, _shortcuts, _ranks, _categories, _comments, _ratings, _tags};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return PropsValues.DL_PUBLISH_TO_LIVE_BY_DEFAULT;
    }

    protected static void exportFileRank(PortletDataContext context, Element fileRanksElement, DLFileRank fileRank) throws Exception {
        String path = DLPortletDataHandlerImpl.getFileRankPath(context, fileRank);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element fileRankElement = fileRanksElement.addElement("file-rank");
        fileRankElement.addAttribute("path", path);
        fileRank.setUserUuid(fileRank.getUserUuid());
        context.addZipEntry(path, (Object)fileRank);
    }

    protected static void exportFileShortcut(PortletDataContext context, Element foldersElement, Element fileShortcutsElement, DLFileShortcut fileShortcut) throws Exception {
        DLPortletDataHandlerImpl.exportParentFolder(context, foldersElement, fileShortcut.getFolderId());
        String path = DLPortletDataHandlerImpl.getFileShortcutPath(context, fileShortcut);
        if (context.isPathNotProcessed(path)) {
            Element fileShortcutElement = fileShortcutsElement.addElement("file-shortcut");
            fileShortcutElement.addAttribute("path", path);
            fileShortcut.setUserUuid(fileShortcut.getUserUuid());
            context.addPermissions(DLFileShortcut.class, fileShortcut.getFileShortcutId());
            context.addZipEntry(path, (Object)fileShortcut);
        }
    }

    protected static void exportFolder(PortletDataContext context, Element foldersElement, Element fileEntriesElement, Element fileShortcutsElement, Element fileRanksElement, DLFolder folder) throws Exception {
        if (context.isWithinDateRange(folder.getModifiedDate())) {
            DLPortletDataHandlerImpl.exportParentFolder(context, foldersElement, folder.getParentFolderId());
            String path = DLPortletDataHandlerImpl.getFolderPath(context, folder);
            if (context.isPathNotProcessed(path)) {
                Element folderElement = foldersElement.addElement("folder");
                folderElement.addAttribute("path", path);
                folder.setUserUuid(folder.getUserUuid());
                context.addPermissions(DLFolder.class, folder.getFolderId());
                context.addZipEntry(path, (Object)folder);
            }
        }
        List fileEntries = DLFileEntryUtil.findByG_F((long)folder.getGroupId(), (long)folder.getFolderId());
        for (DLFileEntry fileEntry : fileEntries) {
            DLPortletDataHandlerImpl.exportFileEntry(context, foldersElement, fileEntriesElement, fileRanksElement, fileEntry, true);
        }
        if (context.getBooleanParameter(_NAMESPACE, "shortcuts")) {
            List fileShortcuts = DLFileShortcutUtil.findByG_F((long)folder.getGroupId(), (long)folder.getFolderId());
            for (DLFileShortcut fileShortcut : fileShortcuts) {
                DLPortletDataHandlerImpl.exportFileShortcut(context, foldersElement, fileShortcutsElement, fileShortcut);
            }
        }
    }

    protected static void exportParentFolder(PortletDataContext context, Element foldersElement, long folderId) throws Exception {
        if (folderId == 0L) {
            return;
        }
        DLFolder folder = DLFolderUtil.findByPrimaryKey((long)folderId);
        DLPortletDataHandlerImpl.exportParentFolder(context, foldersElement, folder.getParentFolderId());
        String path = DLPortletDataHandlerImpl.getFolderPath(context, folder);
        if (context.isPathNotProcessed(path)) {
            Element folderElement = foldersElement.addElement("folder");
            folderElement.addAttribute("path", path);
            folder.setUserUuid(folder.getUserUuid());
            context.addPermissions(DLFolder.class, folder.getFolderId());
            context.addZipEntry(path, (Object)folder);
        }
    }

    protected static String getFileEntryBinPath(PortletDataContext context, DLFileEntry fileEntry) {
        StringBundler sb = new StringBundler(5);
        sb.append(context.getPortletPath("20"));
        sb.append("/bin/");
        sb.append(fileEntry.getFileEntryId());
        sb.append("/");
        sb.append(fileEntry.getVersion());
        return sb.toString();
    }

    protected static String getFileRankPath(PortletDataContext context, DLFileRank fileRank) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("20"));
        sb.append("/ranks/");
        sb.append(fileRank.getFileRankId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFileShortcutPath(PortletDataContext context, DLFileShortcut fileShortcut) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("20"));
        sb.append("/shortcuts/");
        sb.append(fileShortcut.getFileShortcutId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFolderName(long companyId, long groupId, long parentFolderId, String name, int count) throws Exception {
        DLFolder folder = DLFolderUtil.fetchByG_P_N((long)groupId, (long)parentFolderId, (String)name);
        if (folder == null) {
            return name;
        }
        if (Pattern.matches(".* \\(\\d+\\)", name)) {
            int pos = name.lastIndexOf(" (");
            name = name.substring(0, pos);
        }
        StringBundler sb = new StringBundler(5);
        sb.append(name);
        sb.append(" ");
        sb.append("(");
        sb.append(count);
        sb.append(")");
        name = sb.toString();
        return DLPortletDataHandlerImpl.getFolderName(companyId, groupId, parentFolderId, name, ++count);
    }

    protected static String getFolderPath(PortletDataContext context, DLFolder folder) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("20"));
        sb.append("/folders/");
        sb.append(folder.getFolderId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getImportFolderPath(PortletDataContext context, long folderId) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getSourcePortletPath("20"));
        sb.append("/folders/");
        sb.append(folderId);
        sb.append(".xml");
        return sb.toString();
    }

    protected static long getRepositoryId(long groupId, long folderId) {
        if (folderId == 0L) {
            return groupId;
        }
        return folderId;
    }

    protected static void importFileRank(PortletDataContext context, DLFileRank rank) throws Exception {
        long userId = context.getUserId(rank.getUserUuid());
        Map folderPKs = context.getNewPrimaryKeysMap(DLFolder.class);
        long folderId = MapUtil.getLong((Map)folderPKs, (long)rank.getFolderId(), (long)rank.getFolderId());
        Map fileEntryNames = context.getNewPrimaryKeysMap(String.valueOf(DLFileEntry.class.getName()) + ".name");
        String name = (String)fileEntryNames.get(rank.getName());
        if (name == null) {
            name = rank.getName();
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCreateDate(rank.getCreateDate());
        if (folderId != 0L && folderId == rank.getFolderId()) {
            String path = DLPortletDataHandlerImpl.getImportFolderPath(context, folderId);
            DLFolder folder = (DLFolder)context.getZipEntryAsObject(path);
            DLPortletDataHandlerImpl.importFolder(context, folder);
            folderId = MapUtil.getLong((Map)folderPKs, (long)rank.getFolderId(), (long)rank.getFolderId());
        }
        DLFileRankLocalServiceUtil.updateFileRank((long)context.getScopeGroupId(), (long)context.getCompanyId(), (long)userId, (long)folderId, (String)name, (ServiceContext)serviceContext);
    }

    protected static void importFileShortcut(PortletDataContext context, DLFileShortcut fileShortcut) throws Exception {
        long userId = context.getUserId(fileShortcut.getUserUuid());
        Map folderPKs = context.getNewPrimaryKeysMap(DLFolder.class);
        long folderId = MapUtil.getLong((Map)folderPKs, (long)fileShortcut.getFolderId(), (long)fileShortcut.getFolderId());
        long toFolderId = MapUtil.getLong((Map)folderPKs, (long)fileShortcut.getToFolderId(), (long)fileShortcut.getToFolderId());
        Map fileEntryNames = context.getNewPrimaryKeysMap(String.valueOf(DLFileEntry.class.getName()) + ".name");
        String toName = MapUtil.getString((Map)fileEntryNames, (String)fileShortcut.getToName(), (String)fileShortcut.getToName());
        DLFolder folder = DLFolderUtil.findByPrimaryKey((long)folderId);
        DLFileEntry fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)folder.getGroupId(), (long)toFolderId, (String)toName);
        long[] assetCategoryIds = null;
        String[] assetTagNames = null;
        if (context.getBooleanParameter(_NAMESPACE, "categories")) {
            assetCategoryIds = context.getAssetCategoryIds(DLFileEntry.class, fileEntry.getFileEntryId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            assetTagNames = context.getAssetTagNames(DLFileEntry.class, fileEntry.getFileEntryId());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setCreateDate(fileShortcut.getCreateDate());
        serviceContext.setModifiedDate(fileShortcut.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        DLFileShortcut importedFileShortcut = null;
        if (context.isDataStrategyMirror()) {
            DLFileShortcut existingFileShortcut = DLFileShortcutUtil.fetchByUUID_G((String)fileShortcut.getUuid(), (long)context.getScopeGroupId());
            if (existingFileShortcut == null) {
                serviceContext.setUuid(fileShortcut.getUuid());
                importedFileShortcut = DLFileShortcutLocalServiceUtil.addFileShortcut((long)userId, (long)folder.getGroupId(), (long)folderId, (long)toFolderId, (String)toName, (ServiceContext)serviceContext);
            } else {
                importedFileShortcut = DLFileShortcutLocalServiceUtil.updateFileShortcut((long)userId, (long)existingFileShortcut.getFileShortcutId(), (long)folderId, (long)toFolderId, (String)toName, (ServiceContext)serviceContext);
            }
        } else {
            importedFileShortcut = DLFileShortcutLocalServiceUtil.addFileShortcut((long)userId, (long)folder.getGroupId(), (long)folderId, (long)toFolderId, (String)toName, (ServiceContext)serviceContext);
        }
        context.importPermissions(DLFileShortcut.class, fileShortcut.getPrimaryKey(), importedFileShortcut.getPrimaryKey());
    }

    protected static void importFileShortcut(PortletDataContext context, Element fileShortcutElement) throws Exception {
        String path = fileShortcutElement.attributeValue("path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        DLFileShortcut fileShortcut = (DLFileShortcut)context.getZipEntryAsObject(path);
        DLPortletDataHandlerImpl.importFileShortcut(context, fileShortcut);
    }

    protected static void importFolder(PortletDataContext context, DLFolder folder) throws Exception {
        long userId = context.getUserId(folder.getUserUuid());
        Map folderPKs = context.getNewPrimaryKeysMap(DLFolder.class);
        long parentFolderId = MapUtil.getLong((Map)folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(folder.getCreateDate());
        serviceContext.setModifiedDate(folder.getModifiedDate());
        if (parentFolderId != 0L && parentFolderId == folder.getParentFolderId()) {
            String path = DLPortletDataHandlerImpl.getImportFolderPath(context, parentFolderId);
            DLFolder parentFolder = (DLFolder)context.getZipEntryAsObject(path);
            DLPortletDataHandlerImpl.importFolder(context, parentFolder);
            parentFolderId = MapUtil.getLong((Map)folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        }
        DLFolder importedFolder = null;
        if (context.isDataStrategyMirror()) {
            DLFolder existingFolder = DLFolderUtil.fetchByUUID_G((String)folder.getUuid(), (long)context.getScopeGroupId());
            if (existingFolder == null) {
                String name = DLPortletDataHandlerImpl.getFolderName(context.getCompanyId(), context.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                serviceContext.setUuid(folder.getUuid());
                importedFolder = DLFolderLocalServiceUtil.addFolder((long)userId, (long)context.getScopeGroupId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedFolder = DLFolderLocalServiceUtil.updateFolder((long)existingFolder.getFolderId(), (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            String name = DLPortletDataHandlerImpl.getFolderName(context.getCompanyId(), context.getScopeGroupId(), parentFolderId, folder.getName(), 2);
            importedFolder = DLFolderLocalServiceUtil.addFolder((long)userId, (long)context.getScopeGroupId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        folderPKs.put(folder.getFolderId(), importedFolder.getFolderId());
        context.importPermissions(DLFolder.class, folder.getFolderId(), importedFolder.getFolderId());
    }

    protected static boolean isDuplicateFileEntry(DLFileEntry fileEntry1, DLFileEntry fileEntry2) {
        try {
            DLFolder folder1 = fileEntry1.getFolder();
            DLFolder folder2 = fileEntry2.getFolder();
            return folder1.getUuid().equals(folder2.getUuid()) && fileEntry1.getSize() == fileEntry2.getSize() && DLUtil.compareVersions((String)fileEntry1.getVersion(), (String)fileEntry2.getVersion()) == 0 && fileEntry1.getVersionUserUuid().equals(fileEntry2.getVersionUserUuid());
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected PortletPreferences doDeleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        if (!context.addPrimaryKey(DLPortletDataHandlerImpl.class, "deleteData")) {
            DLFolderLocalServiceUtil.deleteFolders((long)context.getScopeGroupId());
            DLFileEntryLocalServiceUtil.deleteFileEntries((long)context.getScopeGroupId(), (long)0L);
        }
        return null;
    }

    protected String doExportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        context.addPermissions("com.liferay.portlet.documentlibrary", context.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("documentlibrary-data");
        rootElement.addAttribute("group-id", String.valueOf(context.getScopeGroupId()));
        Element foldersElement = rootElement.addElement("folders");
        Element fileEntriesElement = rootElement.addElement("file-entries");
        Element fileShortcutsElement = rootElement.addElement("file-shortcuts");
        Element fileRanksElement = rootElement.addElement("file-ranks");
        List folders = DLFolderUtil.findByGroupId((long)context.getScopeGroupId());
        for (DLFolder folder : folders) {
            DLPortletDataHandlerImpl.exportFolder(context, foldersElement, fileEntriesElement, fileShortcutsElement, fileRanksElement, folder);
        }
        List fileEntries = DLFileEntryUtil.findByG_F((long)context.getScopeGroupId(), (long)0L);
        for (DLFileEntry fileEntry : fileEntries) {
            DLPortletDataHandlerImpl.exportFileEntry(context, foldersElement, fileEntriesElement, fileRanksElement, fileEntry, true);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws Exception {
        context.importPermissions("com.liferay.portlet.documentlibrary", context.getSourceGroupId(), context.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element foldersElement = rootElement.element("folders");
        List folderElements = foldersElement.elements("folder");
        for (Element folderElement : folderElements) {
            DLPortletDataHandlerImpl.importFolder(context, folderElement);
        }
        Element fileEntriesElement = rootElement.element("file-entries");
        List fileEntryElements = fileEntriesElement.elements("file-entry");
        for (Element fileEntryElement : fileEntryElements) {
            DLPortletDataHandlerImpl.importFileEntry(context, fileEntryElement);
        }
        if (context.getBooleanParameter(_NAMESPACE, "shortcuts")) {
            List fileShortcutElements = rootElement.element("file-shortcuts").elements("file-shortcut");
            for (Element fileShortcutElement : fileShortcutElements) {
                DLPortletDataHandlerImpl.importFileShortcut(context, fileShortcutElement);
            }
        }
        if (context.getBooleanParameter(_NAMESPACE, "ranks")) {
            Element fileRanksElement = rootElement.element("file-ranks");
            List fileRankElements = fileRanksElement.elements("file-rank");
            for (Element fileRankElement : fileRankElements) {
                DLPortletDataHandlerImpl.importFileRank(context, fileRankElement);
            }
        }
        return null;
    }
}

