/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.util;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.LayoutSettings;
import com.liferay.portal.util.PortalUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommunitiesUtil {
    public static void applyLayoutSetPrototypes(Group group, long publicLayoutSetPrototypeId, long privateLayoutSetPrototypeId) throws Exception {
        LayoutSetPrototype layoutSetPrototype;
        if (publicLayoutSetPrototypeId > 0L) {
            layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)publicLayoutSetPrototypeId);
            LayoutSet publicLayoutSet = group.getPublicLayoutSet();
            CommunitiesUtil.copyLayoutSet(layoutSetPrototype.getLayoutSet(), publicLayoutSet);
        }
        if (privateLayoutSetPrototypeId > 0L) {
            layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)privateLayoutSetPrototypeId);
            LayoutSet privateLayoutSet = group.getPrivateLayoutSet();
            CommunitiesUtil.copyLayoutSet(layoutSetPrototype.getLayoutSet(), privateLayoutSet);
        }
    }

    public static void copyLayoutSet(LayoutSet sourceLayoutSet, LayoutSet targetLayoutSet) throws Exception {
        Map<String, String[]> parameterMap = CommunitiesUtil.getLayoutSetPrototypeParameters();
        File file = LayoutLocalServiceUtil.exportLayoutsAsFile((long)sourceLayoutSet.getGroupId(), (boolean)sourceLayoutSet.isPrivateLayout(), null, parameterMap, null, null);
        try {
            LayoutServiceUtil.importLayouts((long)targetLayoutSet.getGroupId(), (boolean)targetLayoutSet.isPrivateLayout(), parameterMap, (File)file);
        }
        finally {
            file.delete();
        }
    }

    public static void deleteLayout(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        CommunitiesUtil.deleteLayout(request, response);
    }

    public static void deleteLayout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"plid");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutId");
        Layout layout = null;
        if (plid <= 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
        } else {
            layout = LayoutLocalServiceUtil.getLayout((long)plid);
            groupId = layout.getGroupId();
            privateLayout = layout.isPrivateLayout();
            layoutId = layout.getLayoutId();
        }
        Group group = layout.getGroup();
        if (group.isStagingGroup() && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"MANAGE_STAGING") && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"PUBLISH_STAGING")) {
            throw new PrincipalException();
        }
        if (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"DELETE")) {
            LayoutSettings layoutSettings = LayoutSettings.getInstance(layout);
            EventsProcessorUtil.process("layout.configuration.action.delete", layoutSettings.getConfigurationActionDelete(), request, response);
        }
        LayoutServiceUtil.deleteLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
    }

    public static void deleteLayout(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)renderResponse);
        CommunitiesUtil.deleteLayout(request, response);
    }

    public static Map<String, String[]> getLayoutSetPrototypeParameters() {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("CATEGORIES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_USER_PREFERENCES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        parameterMap.put("USER_PERMISSIONS", new String[]{Boolean.FALSE.toString()});
        return parameterMap;
    }
}

