/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.FolderNameException;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.base.BookmarksFolderLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksFolderLocalServiceImpl
extends BookmarksFolderLocalServiceBaseImpl {
    public BookmarksFolder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        Date now = new Date();
        this.validate(name);
        long folderId = this.counterLocalService.increment();
        BookmarksFolder folder = this.bookmarksFolderPersistence.create(folderId);
        folder.setUuid(serviceContext.getUuid());
        folder.setGroupId(groupId);
        folder.setCompanyId(user.getCompanyId());
        folder.setUserId(user.getUserId());
        folder.setCreateDate(serviceContext.getCreateDate(now));
        folder.setModifiedDate(serviceContext.getModifiedDate(now));
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.bookmarksFolderPersistence.update((BaseModel)folder, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addFolderResources(folder, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addFolderResources(folder, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        return folder;
    }

    public void addFolderResources(BookmarksFolder folder, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(folder.getCompanyId(), folder.getGroupId(), folder.getUserId(), BookmarksFolder.class.getName(), folder.getFolderId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addFolderResources(BookmarksFolder folder, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(folder.getCompanyId(), folder.getGroupId(), folder.getUserId(), BookmarksFolder.class.getName(), folder.getFolderId(), communityPermissions, guestPermissions);
    }

    public void addFolderResources(long folderId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(folder, addCommunityPermissions, addGuestPermissions);
    }

    public void addFolderResources(long folderId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(folder, communityPermissions, guestPermissions);
    }

    public void deleteFolder(BookmarksFolder folder) throws PortalException, SystemException {
        List folders = this.bookmarksFolderPersistence.findByG_P(folder.getGroupId(), folder.getFolderId());
        for (BookmarksFolder curFolder : folders) {
            this.deleteFolder(curFolder);
        }
        this.bookmarksFolderPersistence.remove((BaseModel)folder);
        this.resourceLocalService.deleteResource(folder.getCompanyId(), BookmarksFolder.class.getName(), 4, folder.getFolderId());
        this.bookmarksEntryLocalService.deleteEntries(folder.getGroupId(), folder.getFolderId());
        this.expandoValueLocalService.deleteValues(BookmarksFolder.class.getName(), folder.getFolderId());
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        this.deleteFolder(folder);
    }

    public void deleteFolders(long groupId) throws PortalException, SystemException {
        List folders = this.bookmarksFolderPersistence.findByG_P(groupId, 0L);
        for (BookmarksFolder folder : folders) {
            this.deleteFolder(folder);
        }
    }

    public List<BookmarksFolder> getCompanyFolders(long companyId, int start, int end) throws SystemException {
        return this.bookmarksFolderPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyFoldersCount(long companyId) throws SystemException {
        return this.bookmarksFolderPersistence.countByCompanyId(companyId);
    }

    public BookmarksFolder getFolder(long folderId) throws PortalException, SystemException {
        return this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
    }

    public List<BookmarksFolder> getFolders(long groupId) throws SystemException {
        return this.bookmarksFolderPersistence.findByGroupId(groupId);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.bookmarksFolderPersistence.findByG_P(groupId, parentFolderId);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId, int start, int end) throws SystemException {
        return this.bookmarksFolderPersistence.findByG_P(groupId, parentFolderId, start, end);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.bookmarksFolderPersistence.countByG_P(groupId, parentFolderId);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List folders = this.bookmarksFolderPersistence.findByG_P(groupId, folderId);
        for (BookmarksFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    public BookmarksFolder updateFolder(long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        if (mergeWithParentFolder && folderId != parentFolderId) {
            this.mergeFolders(folder, parentFolderId);
            return folder;
        }
        this.validate(name);
        folder.setModifiedDate(serviceContext.getModifiedDate(null));
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.bookmarksFolderPersistence.update((BaseModel)folder, false);
        return folder;
    }

    protected long getParentFolderId(BookmarksFolder folder, long parentFolderId) throws SystemException {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (folder.getFolderId() == parentFolderId) {
            return folder.getParentFolderId();
        }
        BookmarksFolder parentFolder = this.bookmarksFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentFolder == null || folder.getGroupId() != parentFolder.getGroupId()) {
            return folder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, folder.getGroupId(), folder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return folder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) throws SystemException {
        BookmarksFolder parentFolder;
        if (parentFolderId != 0L && ((parentFolder = this.bookmarksFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected void mergeFolders(BookmarksFolder fromFolder, long toFolderId) throws PortalException, SystemException {
        List folders = this.bookmarksFolderPersistence.findByG_P(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (BookmarksFolder folder : folders) {
            this.mergeFolders(folder, toFolderId);
        }
        List entries = this.bookmarksEntryPersistence.findByG_F(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (BookmarksEntry entry : entries) {
            entry.setFolderId(toFolderId);
            this.bookmarksEntryPersistence.update((BaseModel)entry, false);
            Indexer indexer = IndexerRegistryUtil.getIndexer(BookmarksEntry.class);
            indexer.reindex((Object)entry);
        }
        this.deleteFolder(fromFolder);
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name) || name.indexOf("\\\\") != -1 || name.indexOf("//") != -1) {
            throw new FolderNameException();
        }
    }
}

