/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;

public class BlogsIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{BlogsEntry.class.getName()};
    public static final String PORTLET_ID = "33";

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String entryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/blogs/view_entry");
        portletURL.setParameter("entryId", entryId);
        return new Summary(title, content, portletURL);
    }

    protected void doDelete(Object obj) throws Exception {
        BlogsEntry entry = (BlogsEntry)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, entry.getEntryId());
        SearchEngineUtil.deleteDocument((long)entry.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        BlogsEntry entry = (BlogsEntry)obj;
        long companyId = entry.getCompanyId();
        long groupId = this.getParentGroupId(entry.getGroupId());
        long scopeGroupId = entry.getGroupId();
        long userId = entry.getUserId();
        String userName = PortalUtil.getUserName((long)userId, (String)entry.getUserName());
        long entryId = entry.getEntryId();
        String title = entry.getTitle();
        String content = HtmlUtil.extractText((String)entry.getContent());
        Date displayDate = entry.getDisplayDate();
        long[] assetCategoryIds = AssetCategoryLocalServiceUtil.getCategoryIds((String)BlogsEntry.class.getName(), (long)entryId);
        String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)BlogsEntry.class.getName(), (long)entryId);
        ExpandoBridge expandoBridge = entry.getExpandoBridge();
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, entryId);
        document.addModifiedDate(displayDate);
        document.addKeyword("companyId", companyId);
        document.addKeyword("portletId", PORTLET_ID);
        document.addKeyword("groupId", groupId);
        document.addKeyword("scopeGroupId", scopeGroupId);
        document.addKeyword("userId", userId);
        document.addText("userName", userName);
        document.addText("title", title);
        document.addText("content", content);
        document.addKeyword("assetCategoryIds", assetCategoryIds);
        document.addKeyword("assetTagNames", assetTagNames);
        document.addKeyword("entryClassName", BlogsEntry.class.getName());
        document.addKeyword("entryClassPK", entryId);
        ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
        return document;
    }

    protected void doReindex(Object obj) throws Exception {
        BlogsEntry entry = (BlogsEntry)obj;
        if (!entry.isApproved()) {
            return;
        }
        Document document = this.getDocument(entry);
        SearchEngineUtil.updateDocument((long)entry.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)classPK);
        this.doReindex(entry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexEntries(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEntries(long companyId) throws Exception {
        int count = BlogsEntryLocalServiceUtil.getCompanyEntriesCount((long)companyId, (int)0);
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            this.reindexEntries(companyId, start, end);
            ++i;
        }
    }

    protected void reindexEntries(long companyId, int start, int end) throws Exception {
        List entries = BlogsEntryLocalServiceUtil.getCompanyEntries((long)companyId, (int)0, (int)start, (int)end);
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (BlogsEntry entry : entries) {
            Document document = this.getDocument(entry);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }
}

