/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.DuplicateVocabularyException;
import com.liferay.portlet.asset.VocabularyNameException;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.base.AssetVocabularyLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetVocabularyLocalServiceImpl
extends AssetVocabularyLocalServiceBaseImpl {
    public AssetVocabulary addVocabulary(long userId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        String name = titleMap.get(LocaleUtil.getDefault());
        Date now = new Date();
        this.validate(groupId, name);
        long vocabularyId = this.counterLocalService.increment();
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.create(vocabularyId);
        vocabulary.setUuid(serviceContext.getUuid());
        vocabulary.setGroupId(groupId);
        vocabulary.setCompanyId(user.getCompanyId());
        vocabulary.setUserId(user.getUserId());
        vocabulary.setUserName(user.getFullName());
        vocabulary.setCreateDate(now);
        vocabulary.setModifiedDate(now);
        vocabulary.setName(name);
        vocabulary.setTitleMap(titleMap);
        vocabulary.setDescriptionMap(descriptionMap);
        vocabulary.setSettings(settings);
        this.assetVocabularyPersistence.update((BaseModel)vocabulary, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addVocabularyResources(vocabulary, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addVocabularyResources(vocabulary, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        return vocabulary;
    }

    public void addVocabularyResources(AssetVocabulary vocabulary, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(vocabulary.getCompanyId(), vocabulary.getGroupId(), vocabulary.getUserId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addVocabularyResources(AssetVocabulary vocabulary, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(vocabulary.getCompanyId(), vocabulary.getGroupId(), vocabulary.getUserId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), communityPermissions, guestPermissions);
    }

    public void deleteVocabulary(AssetVocabulary vocabulary) throws PortalException, SystemException {
        this.assetVocabularyPersistence.remove((BaseModel)vocabulary);
        this.resourceLocalService.deleteResource(vocabulary.getCompanyId(), AssetVocabulary.class.getName(), 4, vocabulary.getVocabularyId());
        this.assetCategoryLocalService.deleteVocabularyCategories(vocabulary.getVocabularyId());
    }

    public void deleteVocabulary(long vocabularyId) throws PortalException, SystemException {
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        this.deleteVocabulary(vocabulary);
    }

    public List<AssetVocabulary> getCompanyVocabularies(long companyId) throws SystemException {
        return this.assetVocabularyPersistence.findByCompanyId(companyId);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds) throws PortalException, SystemException {
        ArrayList<AssetVocabulary> vocabularies = new ArrayList<AssetVocabulary>();
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            vocabularies.addAll(this.getGroupVocabularies(groupId));
            ++n2;
        }
        return vocabularies;
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId) throws PortalException, SystemException {
        List vocabularies = this.assetVocabularyPersistence.findByGroupId(groupId);
        if (vocabularies.isEmpty()) {
            Group group = this.groupLocalService.getGroup(groupId);
            long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setScopeGroupId(groupId);
            HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
            titleMap.put(LocaleUtil.getDefault(), PropsValues.ASSET_VOCABULARY_DEFAULT);
            AssetVocabulary vocabulary = this.assetVocabularyLocalService.addVocabulary(defaultUserId, titleMap, null, "", serviceContext);
            vocabularies = ListUtil.copy((List)vocabularies);
            vocabularies.add(vocabulary);
        }
        return vocabularies;
    }

    public AssetVocabulary getGroupVocabulary(long groupId, String name) throws PortalException, SystemException {
        return this.assetVocabularyPersistence.findByG_N(groupId, name);
    }

    public AssetVocabulary getVocabulary(long vocabularyId) throws PortalException, SystemException {
        return this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
    }

    public AssetVocabulary updateVocabulary(long vocabularyId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException, SystemException {
        long groupId = serviceContext.getScopeGroupId();
        String name = titleMap.get(LocaleUtil.getDefault());
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        if (!vocabulary.getName().equals(name)) {
            this.validate(groupId, name);
        }
        vocabulary.setModifiedDate(new Date());
        vocabulary.setName(name);
        vocabulary.setTitleMap(titleMap);
        vocabulary.setDescriptionMap(descriptionMap);
        vocabulary.setSettings(settings);
        this.assetVocabularyPersistence.update((BaseModel)vocabulary, false);
        return vocabulary;
    }

    protected boolean hasVocabulary(long groupId, String name) throws SystemException {
        return this.assetVocabularyPersistence.countByG_N(groupId, name) != 0;
    }

    protected void validate(long groupId, String name) throws PortalException, SystemException {
        if (Validator.isNull((String)name)) {
            throw new VocabularyNameException();
        }
        if (this.hasVocabulary(groupId, name)) {
            throw new DuplicateVocabularyException("A category vocabulary with the name " + name + " already exists");
        }
    }
}

