/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetEntryDisplay;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.service.base.AssetEntryServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.portlet.asset.service.permission.AssetTagPermission;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetEntryServiceImpl
extends AssetEntryServiceBaseImpl {
    public void deleteEntry(long entryId) throws PortalException, SystemException {
        this.assetEntryLocalService.deleteEntry(entryId);
    }

    public List<AssetEntry> getCompanyEntries(long companyId, int start, int end) throws SystemException {
        return this.assetEntryLocalService.getCompanyEntries(companyId, start, end);
    }

    public int getCompanyEntriesCount(long companyId) throws SystemException {
        return this.assetEntryLocalService.getCompanyEntriesCount(companyId);
    }

    public String getCompanyEntriesRSS(long companyId, int max, String type, double version, String displayStyle, String feedURL, String tagURL) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        String name = company.getName();
        List<AssetEntry> entries = this.getCompanyEntries(companyId, 0, max);
        return this.exportToRSS(name, null, type, version, displayStyle, feedURL, tagURL, entries);
    }

    public AssetEntryDisplay[] getCompanyEntryDisplays(long companyId, int start, int end, String languageId) throws SystemException {
        return this.assetEntryLocalService.getCompanyEntryDisplays(companyId, start, end, languageId);
    }

    public List<AssetEntry> getEntries(AssetEntryQuery entryQuery) throws PortalException, SystemException {
        this.setupQuery(entryQuery);
        Object[] results = this.filterQuery(entryQuery);
        return (List)results[0];
    }

    public int getEntriesCount(AssetEntryQuery entryQuery) throws PortalException, SystemException {
        this.setupQuery(entryQuery);
        Object[] results = this.filterQuery(entryQuery);
        return (Integer)results[1];
    }

    public String getEntriesRSS(AssetEntryQuery entryQuery, String name, String type, double version, String displayStyle, String feedURL, String tagURL) throws PortalException, SystemException {
        this.setupQuery(entryQuery);
        Object[] results = this.filterQuery(entryQuery);
        return this.exportToRSS(name, null, type, version, displayStyle, feedURL, tagURL, (List)results[0]);
    }

    public AssetEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.assetEntryLocalService.getEntry(entryId);
    }

    public void incrementViewCounter(String className, long classPK) throws PortalException, SystemException {
        this.assetEntryLocalService.incrementViewCounter(this.getGuestOrUserId(), className, classPK);
    }

    public AssetEntryDisplay[] searchEntryDisplays(long companyId, String portletId, String keywords, String languageId, int start, int end) throws SystemException {
        return this.assetEntryLocalService.searchEntryDisplays(companyId, portletId, keywords, languageId, start, end);
    }

    public int searchEntryDisplaysCount(long companyId, String portletId, String keywords, String languageId) throws SystemException {
        return this.assetEntryLocalService.searchEntryDisplaysCount(companyId, portletId, keywords, languageId);
    }

    public AssetEntry updateEntry(long groupId, String className, long classPK, String classUuid, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, int height, int width, Integer priority, boolean sync) throws PortalException, SystemException {
        return this.assetEntryLocalService.updateEntry(this.getUserId(), groupId, className, classPK, classUuid, categoryIds, tagNames, visible, startDate, endDate, publishDate, expirationDate, mimeType, title, description, summary, url, height, width, priority, sync);
    }

    protected String exportToRSS(String name, String description, String type, double version, String displayStyle, String feedURL, String tagURL, List<AssetEntry> assetEntries) throws SystemException {
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        syndFeed.setTitle(name);
        syndFeed.setLink(feedURL);
        syndFeed.setDescription(GetterUtil.getString((String)description, (String)name));
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(entries);
        for (AssetEntry entry : assetEntries) {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)entry.getClassName());
            String author = HtmlUtil.escape((String)PortalUtil.getUserName((long)entry.getUserId(), (String)entry.getUserName()));
            StringBundler sb = new StringBundler(4);
            sb.append(tagURL);
            sb.append(assetRendererFactory.getType());
            sb.append("/id/");
            sb.append(entry.getEntryId());
            String link = sb.toString();
            String value = null;
            value = displayStyle.equals("title") ? "" : entry.getSummary();
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            syndEntry.setAuthor(author);
            syndEntry.setTitle(entry.getTitle());
            syndEntry.setLink(link);
            syndEntry.setUri(syndEntry.getLink());
            syndEntry.setPublishedDate(entry.getCreateDate());
            syndEntry.setUpdatedDate(entry.getModifiedDate());
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType("html");
            syndContent.setValue(value);
            syndEntry.setDescription((SyndContent)syndContent);
            entries.add(syndEntry);
        }
        try {
            return RSSUtil.export((SyndFeed)syndFeed);
        }
        catch (FeedException fe) {
            throw new SystemException((Throwable)fe);
        }
    }

    protected long[] filterCategoryIds(long[] categoryIds) throws PortalException, SystemException {
        ArrayList<Long> viewableCategoryIds = new ArrayList<Long>();
        long[] lArray = categoryIds;
        int n = categoryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long categoryId = lArray[n2];
            if (AssetCategoryPermission.contains(this.getPermissionChecker(), categoryId, "VIEW")) {
                viewableCategoryIds.add(categoryId);
            }
            ++n2;
        }
        return ArrayUtil.toArray((Long[])viewableCategoryIds.toArray(new Long[viewableCategoryIds.size()]));
    }

    protected long[] filterTagIds(long[] tagIds) throws PortalException, SystemException {
        ArrayList<Long> viewableTagIds = new ArrayList<Long>();
        long[] lArray = tagIds;
        int n = tagIds.length;
        int n2 = 0;
        while (n2 < n) {
            long tagId = lArray[n2];
            if (AssetTagPermission.contains(this.getPermissionChecker(), tagId, "VIEW")) {
                viewableTagIds.add(tagId);
            }
            ++n2;
        }
        return ArrayUtil.toArray((Long[])viewableTagIds.toArray(new Long[viewableTagIds.size()]));
    }

    protected Object[] filterQuery(AssetEntryQuery entryQuery) throws PortalException, SystemException {
        int start = entryQuery.getStart();
        int end = entryQuery.getEnd();
        entryQuery.setStart(0);
        entryQuery.setEnd(end + PropsValues.ASSET_FILTER_SEARCH_LIMIT);
        List entries = this.assetEntryLocalService.getEntries(entryQuery);
        PermissionChecker permissionChecker = this.getPermissionChecker();
        List<AssetEntry> filteredEntries = new ArrayList();
        for (AssetEntry entry : entries) {
            String className = entry.getClassName();
            long classPK = entry.getClassPK();
            AssetRendererFactory factory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
            try {
                if (!factory.hasPermission(permissionChecker, classPK, "VIEW")) continue;
                filteredEntries.add(entry);
            }
            catch (Exception exception) {}
        }
        int length = filteredEntries.size();
        if (start != -1 && end != -1) {
            if (end > length) {
                end = length;
            }
            filteredEntries = filteredEntries.subList(start, end);
        }
        entryQuery.setStart(start);
        entryQuery.setEnd(end);
        return new Object[]{filteredEntries, length};
    }

    protected void setupQuery(AssetEntryQuery entryQuery) throws PortalException, SystemException {
        entryQuery.setAllCategoryIds(this.filterCategoryIds(entryQuery.getAllCategoryIds()));
        entryQuery.setAllTagIds(this.filterTagIds(entryQuery.getAllTagIds()));
        entryQuery.setAnyCategoryIds(this.filterCategoryIds(entryQuery.getAnyCategoryIds()));
        entryQuery.setAnyTagIds(this.filterTagIds(entryQuery.getAnyTagIds()));
    }
}

